/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.portfolio.Activities;
import org.yccheok.jstock.portfolio.Activity;

public class ActivitySummary {
    private List<Activities> activitiesList = new ArrayList<Activities>();
    private final Map<SimpleDate, Activities> activitiesMap = new HashMap<SimpleDate, Activities>();

    public boolean add(SimpleDate date, Activity activity) {
        Activities activities = this.activitiesMap.get(date);
        if (activities == null) {
            activities = new Activities(date);
            this.activitiesList.add(activities);
            this.activitiesMap.put(date, activities);
        }
        return activities.add(activity);
    }

    public void ensureSorted() {
        Collections.sort(this.activitiesList, new Comparator<Activities>(){

            @Override
            public int compare(Activities o1, Activities o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        for (Activities activities : this.activitiesList) {
            activities.ensureSorted();
        }
    }

    public int size() {
        return this.activitiesList.size();
    }

    public Activities get(int index) {
        return this.activitiesList.get(index);
    }
}

