/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;

public class CloseHandle
extends LocatorHandle {
    private boolean pressed;

    public CloseHandle(Figure owner) {
        super(owner, new RelativeLocator(1.0, 0.0));
    }

    @Override
    protected int getHandlesize() {
        return 9;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawRectangle(g, this.pressed ? Color.orange : Color.white, Color.black);
        Rectangle r = this.getBounds();
        g.drawLine(r.x, r.y, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width, r.y, r.x, r.y + r.height);
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        this.pressed = this.basicGetBounds().contains(lead);
        if (this.pressed) {
            this.getOwner().requestRemove();
        }
        this.fireAreaInvalidated(this.getDrawingArea());
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.pressed = true;
        this.fireAreaInvalidated(this.getDrawingArea());
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        boolean oldValue = this.pressed;
        this.pressed = this.basicGetBounds().contains(lead);
        if (oldValue != this.pressed) {
            this.fireAreaInvalidated(this.getDrawingArea());
        }
    }
}

