/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.SyspathArchive;
import org.python.core.imp;

public class ZipFileImporter
extends PyObject {
    private SyspathArchive archive;
    private String pathToArchive;

    public ZipFileImporter(PyObject pyObject) {
        if (!(pyObject instanceof SyspathArchive)) {
            throw Py.ImportError(pyObject.toString());
        }
        this.archive = (SyspathArchive)pyObject;
        String string2 = SyspathArchive.getArchiveName(this.archive.string);
        this.pathToArchive = new File(string2).getAbsolutePath() + File.separatorChar;
    }

    public PyObject find_module(String string2) {
        return this.find_module(string2, Py.None);
    }

    public PyObject find_module(String string2, PyObject pyObject) {
        ZipModuleInfo zipModuleInfo = this.getModuleInfo(string2, this.archive);
        return zipModuleInfo == null ? Py.None : new ZipFileLoader(zipModuleInfo);
    }

    public String toString() {
        return this.getType().toString();
    }

    private String getSubName(String string2) {
        int n = string2.lastIndexOf(".");
        if (n >= 0) {
            return string2.substring(n + 1);
        }
        return string2;
    }

    private ZipModuleInfo getModuleInfo(String string2, SyspathArchive syspathArchive) {
        boolean bl;
        String string3 = this.getSubName(string2);
        String string4 = string3 + "/__init__.py";
        String string5 = string3 + "/__init__$py.class";
        ZipEntry zipEntry = syspathArchive.getEntry(string4);
        ZipEntry zipEntry2 = syspathArchive.getEntry(string5);
        boolean bl2 = bl = zipEntry != null || zipEntry2 != null;
        if (!bl) {
            string4 = string3 + ".py";
            string5 = string3 + "$py.class";
            zipEntry = syspathArchive.getEntry(string4);
            zipEntry2 = syspathArchive.getEntry(string5);
        } else {
            syspathArchive = syspathArchive.makeSubfolder(string3);
        }
        ZipModuleInfo zipModuleInfo = null;
        if (zipEntry != null) {
            Py.writeDebug("import", "trying source entry: " + string4 + " from jar/zip file " + syspathArchive);
            if (zipEntry2 != null) {
                Py.writeDebug("import", "trying precompiled entry " + string5 + " from jar/zip file " + syspathArchive);
                long l = zipEntry.getTime();
                long l2 = zipEntry2.getTime();
                if (l2 >= l) {
                    zipModuleInfo = new ZipModuleInfo(syspathArchive, zipEntry2, true);
                }
            }
            if (zipModuleInfo == null) {
                zipModuleInfo = new ZipModuleInfo(syspathArchive, zipEntry, false);
            }
        }
        if (bl && zipModuleInfo != null) {
            zipModuleInfo.path = new PyList(new PyObject[]{syspathArchive});
        }
        return zipModuleInfo;
    }

    private class ZipModuleInfo {
        public PyObject path;
        public boolean compiled;
        public ZipEntry zipEntry;
        public SyspathArchive archive;

        public ZipModuleInfo(SyspathArchive syspathArchive, ZipEntry zipEntry, boolean bl) {
            this(syspathArchive, zipEntry, bl, null);
        }

        public ZipModuleInfo(SyspathArchive syspathArchive, ZipEntry zipEntry, boolean bl, PyObject pyObject) {
            this.path = pyObject;
            this.archive = syspathArchive;
            this.zipEntry = zipEntry;
            this.compiled = bl;
        }
    }

    public class ZipFileLoader
    extends PyObject {
        private ZipModuleInfo _info;

        public ZipFileLoader(ZipModuleInfo zipModuleInfo) {
            this._info = zipModuleInfo;
        }

        public PyObject load_module(String string2) {
            PyModule pyModule = null;
            if (this._info.path != null) {
                pyModule = imp.addModule(string2);
                pyModule.__dict__.__setitem__("__path__", this._info.path);
                pyModule.__dict__.__setitem__("__loader__", (PyObject)this);
            }
            InputStream inputStream = null;
            ZipEntry zipEntry = this._info.zipEntry;
            try {
                inputStream = this._info.archive.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                Py.writeDebug("import", "loadFromZipFile exception: " + iOException.toString());
                throw Py.ImportError("error loading from zipfile");
            }
            String string3 = ZipFileImporter.this.pathToArchive + zipEntry.getName();
            PyObject pyObject = this._info.compiled ? imp.createFromPyClass(string2, inputStream, true, string3) : imp.createFromSource(string2, inputStream, string3, null);
            return pyModule == null ? pyObject : pyModule;
        }

        public String toString() {
            return this.getType().toString();
        }
    }
}

