/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.tokenAttributes;

import net.java.sen.dictionary.Morpheme;
import org.apache.lucene.analysis.ja.ToStringUtil;
import org.apache.lucene.analysis.ja.tokenAttributes.PartOfSpeechAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class PartOfSpeechAttributeImpl
extends AttributeImpl
implements PartOfSpeechAttribute,
Cloneable {
    private Morpheme morpheme;

    public String getPartOfSpeech() {
        return this.morpheme == null ? null : this.morpheme.getPartOfSpeech();
    }

    public void setMorpheme(Morpheme morpheme) {
        this.morpheme = morpheme;
    }

    public void clear() {
        this.morpheme = null;
    }

    public void copyTo(AttributeImpl target) {
        PartOfSpeechAttribute t = (PartOfSpeechAttribute)target;
        t.setMorpheme(this.morpheme);
    }

    public void reflectWith(AttributeReflector reflector) {
        String partOfSpeech = this.getPartOfSpeech();
        String en = partOfSpeech == null ? null : ToStringUtil.getPOSTranslation(partOfSpeech);
        reflector.reflect(PartOfSpeechAttribute.class, "partOfSpeech", (Object)partOfSpeech);
        reflector.reflect(PartOfSpeechAttribute.class, "partOfSpeech (en)", (Object)en);
    }
}

