/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class SizeCellRenderer
extends DefaultTableCellRenderer {
    private final String sizeRendererProgress;
    private final String sizeRendererUnknown;
    private final String sizeRendererInBytes;
    private NumberFormat numberFormatter;

    SizeCellRenderer(ApplicationContext context) {
        ResourceMap map = context.getResourceMap();
        this.sizeRendererProgress = map.getString("sizeRendererProgress", new Object[0]);
        this.sizeRendererUnknown = map.getString("sizeRendererUnknown", new Object[0]);
        this.sizeRendererInBytes = map.getString("sizeRendererInBytes", new Object[0]);
        this.numberFormatter = NumberFormat.getIntegerInstance();
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        DownloadFile downloadFile = (DownloadFile)value;
        long fs = downloadFile.getFileSize();
        long dl = downloadFile.getDownloaded();
        if (fs >= 0L) {
            value = dl != fs ? String.format(this.sizeRendererProgress, ContentPanel.bytesToAnother(dl), ContentPanel.bytesToAnother(fs)) : ContentPanel.bytesToAnother(fs);
            this.setToolTipText(String.format(this.sizeRendererInBytes, this.numberFormatter.format(fs)));
        } else if (dl > 0L) {
            value = ContentPanel.bytesToAnother(dl);
            this.setToolTipText(String.format(this.sizeRendererInBytes, this.numberFormatter.format(dl)));
        } else {
            value = this.sizeRendererUnknown;
            this.setToolTipText(null);
        }
        this.getAccessibleContext().setAccessibleName(table.getColumnName(column) + " " + value);
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

