/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Icon;

public class FastScrollButton
extends BaseScrollButton {
    public FastScrollButton(int n, int n2) {
        super(n, n2);
    }

    public void paint(Graphics graphics) {
        boolean bl = this.getModel().isPressed();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = FastLookAndFeel.getTheme().getControlBackgroundColor();
        if (!JTattooUtilities.isActive(this)) {
            color = ColorHelper.brighter(color, 50.0);
        }
        if (bl) {
            color = ColorHelper.darker(color, 10.0);
        }
        Color color2 = ColorHelper.brighter(color, 40.0);
        Color color3 = ColorHelper.darker(color, 30.0);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        if (this.getDirection() == 1) {
            Icon icon = BaseIcons.getUpArrowIcon();
            int n3 = n / 2 - icon.getIconWidth() / 2;
            int n4 = n2 / 2 - icon.getIconHeight() / 2 - 1;
            icon.paintIcon(this, graphics, n3, n4);
        } else if (this.getDirection() == 5) {
            Icon icon = BaseIcons.getDownArrowIcon();
            int n5 = n / 2 - icon.getIconWidth() / 2;
            int n6 = n2 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this, graphics, n5, n6);
        } else if (this.getDirection() == 7) {
            Icon icon = BaseIcons.getLeftArrowIcon();
            int n7 = n / 2 - icon.getIconWidth() / 2 - 1;
            int n8 = n2 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this, graphics, n7, n8);
        } else {
            Icon icon = BaseIcons.getRightArrowIcon();
            int n9 = n / 2 - icon.getIconWidth() / 2;
            int n10 = n2 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this, graphics, n9, n10);
        }
        JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color3, 20.0), color3, 0, 0, n, n2);
        if (!bl) {
            graphics.setColor(color2);
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.drawLine(1, 1, 1, n2 - 2);
        }
    }
}

