/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.DetailAttribute;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.DetailAttributeDataSet;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ResultDataSet;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleType;

public class SingleResultController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SingleResultController.class);
    private SingleType _singleType;
    private DataSetViewerTablePanel _tblDetailsMetaData = new DataSetViewerTablePanel();
    private DataSetViewerTablePanel _tblDetailsData = new DataSetViewerTablePanel();
    private JPanel _pnlResults;

    public SingleResultController(SingleType singleType, JPanel pnlResults, ISession session) {
        this._pnlResults = pnlResults;
        try {
            this._singleType = singleType;
            DetailAttribute[] attributes = DetailAttribute.createDetailtAttributes(singleType.getMappedClassInfo().getAttributes());
            this._tblDetailsData.init(null, new DataModelImplementationDetails(session), session);
            this._tblDetailsData.show((IDataSet)new ResultDataSet(singleType));
            this._tblDetailsMetaData.init(null, new DataModelImplementationDetails(session), session);
            this._tblDetailsMetaData.show((IDataSet)new DetailAttributeDataSet(attributes));
            pnlResults.removeAll();
            pnlResults.add(this.createTabbedPane(this._tblDetailsData, this._tblDetailsMetaData, session));
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private JTabbedPane createTabbedPane(DataSetViewerTablePanel tblDetails, DataSetViewerTablePanel tblDetailsMetaData, ISession session) {
        SessionProperties props = session.getProperties();
        JTabbedPane ret = UIFactory.getInstance().createTabbedPane(props.getSQLExecutionTabPlacement());
        ret.addTab(s_stringMgr.getString("SingleResultController.data"), new JScrollPane(tblDetails.getComponent()));
        ret.addTab(s_stringMgr.getString("SingleResultController.metaData"), new JScrollPane(tblDetailsMetaData.getComponent()));
        ret.setSelectedIndex(0);
        return ret;
    }
}

