/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import net.htmlparser.jericho.Source;

public final class RowColumnVector {
    private final int row;
    private final int column;
    private final int pos;
    private static final RowColumnVector FIRST = new RowColumnVector(1, 1, 0);
    private static final RowColumnVector[] STREAMED = new RowColumnVector[0];

    private RowColumnVector(int row, int column, int pos) {
        this.row = row;
        this.column = column;
        this.pos = pos;
    }

    private RowColumnVector(int pos) {
        this(-1, -1, pos);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getPos() {
        return this.pos;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(20)).toString();
    }

    StringBuilder appendTo(StringBuilder sb) {
        if (this.row != -1) {
            return sb.append("(r").append(this.row).append(",c").append(this.column).append(",p").append(this.pos).append(')');
        }
        return sb.append("(p").append(this.pos).append(')');
    }

    static RowColumnVector[] getCacheArray(Source source) {
        if (source.isStreamed()) {
            return STREAMED;
        }
        int lastSourcePos = source.end - 1;
        ArrayList<RowColumnVector> list = new ArrayList<RowColumnVector>();
        list.add(FIRST);
        int row = 1;
        for (int pos = 0; pos <= lastSourcePos; ++pos) {
            char ch = source.charAt(pos);
            if (ch != '\n' && (ch != '\r' || pos != lastSourcePos && source.charAt(pos + 1) == '\n')) continue;
            list.add(new RowColumnVector(++row, 1, pos + 1));
        }
        return list.toArray(new RowColumnVector[list.size()]);
    }

    static RowColumnVector get(RowColumnVector[] cacheArray, int pos) {
        RowColumnVector rowColumnVector;
        if (cacheArray == STREAMED) {
            return new RowColumnVector(pos);
        }
        int low = 0;
        int high = cacheArray.length - 1;
        while (true) {
            int mid = low + high >> 1;
            rowColumnVector = cacheArray[mid];
            if (rowColumnVector.pos < pos) {
                if (mid == high) {
                    return new RowColumnVector(rowColumnVector.row, pos - rowColumnVector.pos + 1, pos);
                }
                low = mid + 1;
                continue;
            }
            if (rowColumnVector.pos <= pos) break;
            high = mid - 1;
        }
        return rowColumnVector;
    }
}

