/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    int boxHandle;
    int labelHandle;
    int imageHandle;
    int arrowHandle;
    int groupHandle;
    boolean selected;
    boolean grayed;
    ImageList imageList;
    Image image;
    String text;
    GdkRGBA background;
    static final int INNER_BORDER = 1;
    static final int DEFAULT_BORDER = 1;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    static GtkBorder getBorder(byte[] border, int handle, int defaultBorder) {
        GtkBorder gtkBorder = new GtkBorder();
        int[] borderPtr = new int[1];
        GTK.gtk_widget_style_get(handle, border, borderPtr, 0);
        if (borderPtr[0] != 0) {
            OS.memmove(gtkBorder, borderPtr[0], GtkBorder.sizeof);
            GTK.gtk_border_free(borderPtr[0]);
            return gtkBorder;
        }
        gtkBorder.left = defaultBorder;
        gtkBorder.top = defaultBorder;
        gtkBorder.right = defaultBorder;
        gtkBorder.bottom = defaultBorder;
        return gtkBorder;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        Point size;
        boolean wrap;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        this.forceResize();
        int[] reqWidth = null;
        int[] reqHeight = null;
        if ((this.style & 0x30) != 0) {
            reqWidth = new int[1];
            reqHeight = new int[1];
            GTK.gtk_widget_get_size_request(this.boxHandle, reqWidth, reqHeight);
            GTK.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        boolean bl = wrap = this.labelHandle != 0 && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (wrap) {
            int trimWidth;
            int borderWidth = GTK.gtk_container_get_border_width(this.handle);
            int[] focusWidth = new int[1];
            GTK.gtk_widget_style_get(this.handle, OS.focus_line_width, focusWidth, 0);
            int[] focusPadding = new int[1];
            GTK.gtk_widget_style_get(this.handle, OS.focus_padding, focusPadding, 0);
            int trimHeight = trimWidth = 2 * (borderWidth + focusWidth[0] + focusPadding[0]);
            int indicatorHeight = 0;
            if ((this.style & 0x30) != 0) {
                int[] indicatorSize = new int[1];
                GTK.gtk_widget_style_get(this.handle, OS.indicator_size, indicatorSize, 0);
                int[] indicatorSpacing = new int[1];
                GTK.gtk_widget_style_get(this.handle, OS.indicator_spacing, indicatorSpacing, 0);
                indicatorHeight = indicatorSize[0] + 2 * indicatorSpacing[0];
                trimWidth += indicatorHeight + indicatorSpacing[0];
            } else {
                Point thickness = this.getThickness(this.handle);
                trimWidth += thickness.x * 2;
                trimHeight += thickness.y * 2;
                GtkBorder innerBorder = Button.getBorder(OS.inner_border, this.handle, 1);
                trimWidth += innerBorder.left + innerBorder.right;
                trimHeight += innerBorder.top + innerBorder.bottom;
                if (GTK.gtk_widget_get_can_default(this.handle)) {
                    GtkBorder defaultBorder = Button.getBorder(OS.default_border, this.handle, 1);
                    trimWidth += defaultBorder.left + defaultBorder.right;
                    trimHeight += defaultBorder.top + defaultBorder.bottom;
                }
            }
            int imageWidth = 0;
            int imageHeight = 0;
            if (GTK.gtk_widget_get_visible(this.imageHandle)) {
                GtkRequisition requisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, requisition);
                imageWidth = requisition.width;
                imageHeight = requisition.height;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0);
                imageWidth += spacing[0];
            }
            int labelLayout = GTK.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            if (wHint != -1) {
                OS.pango_layout_set_width(labelLayout, Math.max(1, wHint - imageWidth - trimWidth) * 1024);
            } else {
                OS.pango_layout_set_width(labelLayout, -1);
            }
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            size = new Point(0, 0);
            size.x = size.x + (wHint == -1 ? w[0] + imageWidth + trimWidth : wHint);
            size.y = size.y + (hHint == -1 ? Math.max(Math.max(imageHeight, indicatorHeight), h[0]) + trimHeight : hHint);
        } else {
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if ((this.style & 0x30) != 0) {
            GTK.gtk_widget_set_size_request(this.boxHandle, reqWidth[0], reqHeight[0]);
        }
        if ((wHint != -1 || hHint != -1) && GTK.gtk_widget_get_can_default(this.handle)) {
            GtkBorder border = Button.getBorder(OS.default_border, this.handle, 1);
            if (wHint != -1) {
                size.x += border.left + border.right;
            }
            if (hHint != -1) {
                size.y += border.top + border.bottom;
            }
        }
        return size;
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 0xA) == 0) {
            this.state |= 0x10000;
        }
        int bits = 62;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.fixedHandle, true);
        switch (this.style & bits) {
            case 4: {
                if (GTK.GTK3) {
                    byte[] arrowType = GTK.GTK_NAMED_ICON_GO_UP;
                    if ((this.style & 0x80) != 0) {
                        arrowType = GTK.GTK_NAMED_ICON_GO_UP;
                    }
                    if ((this.style & 0x400) != 0) {
                        arrowType = GTK.GTK_NAMED_ICON_GO_DOWN;
                    }
                    if ((this.style & 0x4000) != 0) {
                        arrowType = GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                    }
                    if ((this.style & 0x20000) != 0) {
                        arrowType = GTK.GTK_NAMED_ICON_GO_NEXT;
                    }
                    this.arrowHandle = GTK.gtk_image_new_from_icon_name(arrowType, 1);
                } else {
                    int arrowType = 0;
                    if ((this.style & 0x80) != 0) {
                        arrowType = 0;
                    }
                    if ((this.style & 0x400) != 0) {
                        arrowType = 1;
                    }
                    if ((this.style & 0x4000) != 0) {
                        arrowType = 2;
                    }
                    if ((this.style & 0x20000) != 0) {
                        arrowType = 3;
                    }
                    this.arrowHandle = GTK.gtk_arrow_new(arrowType, 2);
                }
                if (this.arrowHandle == 0) {
                    this.error(2);
                }
                this.handle = GTK.gtk_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 2: {
                this.handle = GTK.gtk_toggle_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = GTK.gtk_check_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 16: {
                this.groupHandle = GTK.gtk_radio_button_new(0);
                if (this.groupHandle == 0) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                OS.g_object_ref_sink(this.groupHandle);
                this.handle = GTK.gtk_radio_button_new(GTK.gtk_radio_button_get_group(this.groupHandle));
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = GTK.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                GTK.gtk_widget_set_can_default(this.handle, true);
            }
        }
        if ((this.style & 4) != 0) {
            if (GTK.GTK3) {
                GTK.gtk_button_set_image(this.handle, this.arrowHandle);
            } else {
                GTK.gtk_container_add(this.handle, this.arrowHandle);
            }
        } else {
            this.boxHandle = this.gtk_box_new(0, false, 4);
            if (this.boxHandle == 0) {
                this.error(2);
            }
            this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = GTK.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            GTK.gtk_container_add(this.handle, this.boxHandle);
            GTK.gtk_container_add(this.boxHandle, this.imageHandle);
            GTK.gtk_container_add(this.boxHandle, this.labelHandle);
            if ((this.style & 0x40) != 0) {
                GTK.gtk_label_set_line_wrap(this.labelHandle, true);
                GTK.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
            }
        }
        GTK.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 4) != 0) {
            return;
        }
        if (GTK.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
        this._setAlignment(this.style & 0x1024000);
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.boxHandle != 0) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    @Override
    int fontHandle() {
        if (this.labelHandle != 0) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return GTK.gtk_toggle_button_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    @Override
    int gtk_clicked(int widget) {
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0;
        }
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0 && this.grayed) {
            if (GTK.gtk_toggle_button_get_active(this.handle)) {
                GTK.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                GTK.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        this.sendSelectionEvent(13);
        return 0;
    }

    @Override
    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && GTK.gtk_widget_has_default(this.handle)) {
            Decorations menuShell = this.menuShell();
            menuShell.defaultButton = this;
        }
        return result;
    }

    @Override
    int gtk_focus_out_event(int widget, int event) {
        int result = super.gtk_focus_out_event(widget, event);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0) {
            Decorations menuShell = this.menuShell();
            if (menuShell.defaultButton == this) {
                menuShell.defaultButton = null;
            }
        }
        return result;
    }

    @Override
    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean isDescribedByLabel() {
        return false;
    }

    @Override
    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    @Override
    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    @Override
    void register() {
        super.register();
        if (this.boxHandle != 0) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0;
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.boxHandle = 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.groupHandle != 0) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void resizeHandle(int width, int height) {
        if (GTK.GTK3) {
            if ((this.style & 0x30) != 0 && (this.style & 0x40) == 0) {
                OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.topHandle()), this.topHandle(), width, height);
            } else {
                super.resizeHandle(width, height);
            }
        } else {
            super.resizeHandle(width, height);
            if ((this.style & 0x30) != 0) {
                GTK.gtk_widget_set_size_request(this.boxHandle, width, -1);
            }
        }
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (this == child) continue;
            child.setRadioSelection(false);
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this._setAlignment(alignment);
    }

    void _setAlignment(int alignment) {
        boolean bothVisible;
        if ((this.style & 4) != 0) {
            boolean isRTL;
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            boolean bl = isRTL = (this.style & 0x4000000) != 0;
            if (GTK.GTK3) {
                byte[] arrowType = GTK.GTK_NAMED_ICON_GO_UP;
                switch (alignment) {
                    case 128: {
                        arrowType = GTK.GTK_NAMED_ICON_GO_UP;
                        break;
                    }
                    case 1024: {
                        arrowType = GTK.GTK_NAMED_ICON_GO_DOWN;
                        break;
                    }
                    case 16384: {
                        arrowType = isRTL ? GTK.GTK_NAMED_ICON_GO_NEXT : GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                        break;
                    }
                    case 131072: {
                        arrowType = isRTL ? GTK.GTK_NAMED_ICON_GO_PREVIOUS : GTK.GTK_NAMED_ICON_GO_NEXT;
                    }
                }
                GTK.gtk_image_set_from_icon_name(this.arrowHandle, arrowType, 1);
            } else {
                int arrowType = 0;
                switch (alignment) {
                    case 128: {
                        arrowType = 0;
                        break;
                    }
                    case 1024: {
                        arrowType = 1;
                        break;
                    }
                    case 16384: {
                        arrowType = isRTL ? 3 : 2;
                        break;
                    }
                    case 131072: {
                        arrowType = isRTL ? 2 : 3;
                    }
                }
                GTK.gtk_arrow_set(this.arrowHandle, arrowType, 2);
            }
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        boolean bl = bothVisible = GTK.gtk_widget_get_visible(this.labelHandle) && GTK.gtk_widget_get_visible(this.imageHandle);
        if (bothVisible) {
            if ((this.style & 0x30) != 0) {
                alignment = 16384;
            }
            if ((this.style & 0xA) != 0) {
                alignment = 0x1000000;
            }
        }
        if ((alignment & 0x4000) != 0) {
            if (bothVisible) {
                GTK.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 0);
                GTK.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
            } else if (GTK.GTK3) {
                GTK.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                GTK.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 1, 3);
            } else {
                GTK.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
                GTK.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            }
            GTK.gtk_label_set_justify(this.labelHandle, 0);
            return;
        }
        if ((alignment & 0x1000000) != 0) {
            if (bothVisible) {
                GTK.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                GTK.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                    this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
                    this.gtk_widget_set_align(this.imageHandle, 2, 3);
                } else {
                    GTK.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
                    GTK.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
                }
            } else {
                if (GTK.GTK3) {
                    GTK.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                    GTK.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                }
                if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                    this.gtk_label_set_align(this.labelHandle, 0.5f, 0.5f);
                    this.gtk_widget_set_align(this.imageHandle, 3, 3);
                } else {
                    GTK.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.5f);
                    GTK.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
                }
                GTK.gtk_label_set_justify(this.labelHandle, 2);
            }
            return;
        }
        if ((alignment & 0x20000) != 0) {
            if (bothVisible) {
                GTK.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 1);
                GTK.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 1);
            } else if (GTK.GTK3) {
                GTK.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                GTK.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_label_set_align(this.labelHandle, 1.0f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 2, 3);
            } else {
                GTK.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.5f);
                GTK.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            }
            GTK.gtk_label_set_justify(this.labelHandle, 1);
            return;
        }
    }

    @Override
    void setBackgroundGdkRGBA(int context, int handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        this.background = rgba;
        if (GTK.GTK_VERSION < OS.VERSION(3, 10, 3) && (this.style & 0x30) != 0) {
            super.setBackgroundGdkRGBA(context, handle, rgba);
            return;
        }
        String css = "* {background : ";
        String color = this.display.gtk_rgba_to_css_string(rgba);
        this.cssBackground = css = css + color + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    void setBackgroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setBackgroundGdkColor(color);
        this.setBackgroundGdkColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setBackgroundGdkColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setBackgroundGdkColor(this.imageHandle, color);
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean wrap;
        boolean bl = wrap = this.labelHandle != 0 && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (wrap) {
            GTK.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (wrap) {
            GtkRequisition requisition;
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.boxHandle, allocation);
            int boxWidth = allocation.width;
            int boxHeight = allocation.height;
            int labelLayout = GTK.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            OS.pango_layout_set_width(labelLayout, -1);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            int imageWidth = 0;
            if (GTK.gtk_widget_get_visible(this.imageHandle)) {
                requisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, requisition);
                imageWidth = requisition.width;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0);
                imageWidth += spacing[0];
            }
            GTK.gtk_widget_set_size_request(this.labelHandle, Math.min(w[0], boxWidth - imageWidth), -1);
            requisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.boxHandle, requisition);
            allocation.width = boxWidth;
            allocation.height = boxHeight;
            Point sizes = this.resizeCalculationsGTK3(this.boxHandle, boxWidth, boxHeight);
            allocation.width = sizes.x;
            allocation.height = sizes.y;
            GTK.gtk_widget_size_allocate(this.boxHandle, allocation);
        }
        return result;
    }

    @Override
    void setFontDescription(int fontDesc) {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0) && (this.text != null && this.text.isEmpty() || this.text == null)) {
            return;
        }
        super.setFontDescription(fontDesc);
        if (this.labelHandle != 0) {
            this.setFontDescription(this.labelHandle, fontDesc);
        }
        if (this.imageHandle != 0) {
            this.setFontDescription(this.imageHandle, fontDesc);
        }
    }

    @Override
    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        super.setForegroundGdkRGBA(rgba);
        this.setForegroundGdkRGBA(this.fixedHandle, rgba);
        if (this.labelHandle != 0) {
            this.setForegroundGdkRGBA(this.labelHandle, rgba);
        }
        if (this.imageHandle != 0) {
            this.setForegroundGdkRGBA(this.imageHandle, rgba);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(3, 10, 0) && GTK.GTK_VERSION < OS.VERSION(3, 16, 0) && (this.style & 0x30) != 0) {
            this.gtk_swt_set_border_color(rgba);
        }
    }

    @Override
    void setForegroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setForegroundGdkColor(color);
        this.setForegroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setForegroundColor(this.imageHandle, color);
        }
    }

    @Override
    void setForegroundGdkRGBA(int handle, GdkRGBA rgba) {
        String css;
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (GTK.GTK_VERSION < OS.VERSION(3, 14, 0)) {
            super.setForegroundGdkRGBA(handle, rgba);
            return;
        }
        GdkRGBA toSet = rgba == null ? this.display.COLOR_WIDGET_FOREGROUND_RGBA : rgba;
        int context = GTK.gtk_widget_get_style_context(handle);
        String color = this.display.gtk_rgba_to_css_string(toSet);
        String name = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "button" : "GtkButton";
        this.cssForeground = css = name + " {color: " + color + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    private void gtk_swt_set_border_color(GdkRGBA rgba) {
        String finalCss;
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        String css_string = "* {\n";
        if (rgba != null) {
            String css_color = this.display.gtk_rgba_to_css_string(rgba);
            css_string = css_string + "border-color: " + css_color + ";\n";
        }
        css_string = css_string + "}\n";
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.cssForeground = this.cssForeground + "\n" + css_string;
            finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        } else {
            finalCss = css_string;
        }
        int context = GTK.gtk_widget_get_style_context(this.handle);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
        if (grayed && GTK.gtk_toggle_button_get_active(this.handle)) {
            GTK.gtk_toggle_button_set_inconsistent(this.handle, true);
        } else {
            GTK.gtk_toggle_button_set_inconsistent(this.handle, false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int imageIndex = this.imageList.add(image);
            int pixbuf = this.imageList.getPixbuf(imageIndex);
            this.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
        }
        this.image = image;
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.boxHandle != 0) {
                GTK.gtk_widget_set_direction(this.boxHandle, dir);
            }
            if (this.labelHandle != 0) {
                GTK.gtk_widget_set_direction(this.labelHandle, dir);
            }
            if (this.imageHandle != 0) {
                GTK.gtk_widget_set_direction(this.imageHandle, dir);
            }
            if (this.arrowHandle != 0) {
                if (GTK.GTK3) {
                    byte[] arrowType = (this.style & 0x4000000) != 0 ? GTK.GTK_NAMED_ICON_GO_NEXT : GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                    switch (this.style & 0x24000) {
                        case 16384: {
                            GTK.gtk_image_set_from_icon_name(this.arrowHandle, arrowType, 1);
                            break;
                        }
                        case 131072: {
                            GTK.gtk_image_set_from_icon_name(this.arrowHandle, arrowType, 1);
                        }
                    }
                } else {
                    int arrowDir = (this.style & 0x4000000) != 0 ? 3 : 2;
                    switch (this.style & 0x24000) {
                        case 16384: {
                            GTK.gtk_arrow_set(this.arrowHandle, arrowDir, 2);
                            break;
                        }
                        case 131072: {
                            GTK.gtk_arrow_set(this.arrowHandle, arrowDir, 2);
                        }
                    }
                }
            }
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 8);
        GTK.gtk_toggle_button_set_active(this.handle, selected);
        if ((this.style & 0x20) != 0) {
            if (selected && this.grayed) {
                GTK.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                GTK.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        if ((this.style & 0x10) != 0) {
            GTK.gtk_toggle_button_set_active(this.groupHandle, !selected);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 8);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
            this.setFontDescription(this.font == null ? this.defaultFont().handle : this.font.handle);
        }
    }

    private void updateWidgetsVisibility() {
        if (this.text.length() == 0 && this.image == null) {
            GTK.gtk_widget_hide(this.boxHandle);
            GTK.gtk_widget_hide(this.labelHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        } else {
            GTK.gtk_widget_show(this.boxHandle);
            if (this.text.length() == 0) {
                GTK.gtk_widget_hide(this.labelHandle);
            } else {
                GTK.gtk_widget_show(this.labelHandle);
            }
            if (this.image == null) {
                GTK.gtk_widget_hide(this.imageHandle);
            } else {
                GTK.gtk_widget_show(this.imageHandle);
            }
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0 && (this.text != null && this.text.length() != 0 || this.image != null)) {
            GTK.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0 && this.text != null && this.text.length() != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        }
        if (this.arrowHandle != 0) {
            GTK.gtk_widget_show(this.arrowHandle);
        }
    }

    @Override
    int traversalCode(int key, GdkEventKey event) {
        int code = super.traversalCode(key, event);
        if ((this.style & 4) != 0) {
            code &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }

    @Override
    int windowProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 18: {
                if (GTK.GTK_VERSION < OS.VERSION(3, 9, 0) || this.paintHandle() != handle) break;
                return this.gtk_draw(handle, arg0);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }
}

