/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ansj.dic.PathToStream;
import org.ansj.domain.KV;
import org.ansj.recognition.impl.StopRecognition;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class StopLibrary {
    private static final Log LOG = LogFactory.getLog();
    public static final String DEFAULT = "stop";
    private static final Map<String, KV<String, StopRecognition>> STOP = new HashMap<String, KV<String, StopRecognition>>();

    public static void insertStopNatures(String key, String ... filterNatures) {
        StopRecognition fr = StopLibrary.get(key);
        fr.insertStopNatures(filterNatures);
    }

    public static void insertStopRegexes(String key, String ... regexes) {
        StopRecognition fr = StopLibrary.get(key);
        fr.insertStopRegexes(regexes);
    }

    public static void insertStopWords(String key, String ... stopWords) {
        StopRecognition fr = StopLibrary.get(key);
        fr.insertStopWords(stopWords);
    }

    public static void insertStopWords(String key, List<String> stopWords) {
        StopRecognition fr = StopLibrary.get(key);
        fr.insertStopWords(stopWords);
    }

    public static StopRecognition get() {
        return StopLibrary.get(DEFAULT);
    }

    public static StopRecognition get(String key) {
        KV<String, StopRecognition> kv = STOP.get(key);
        if (kv == null) {
            if (MyStaticValue.ENV.containsKey(key)) {
                StopLibrary.putIfAbsent(key, MyStaticValue.ENV.get(key));
                return StopLibrary.get(key);
            }
            LOG.warn("STOP " + key + " not found in config ");
            return null;
        }
        StopRecognition stopRecognition = kv.getV();
        if (stopRecognition == null) {
            stopRecognition = StopLibrary.init(key, kv);
        }
        return stopRecognition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized StopRecognition init(String key, KV<String, StopRecognition> kv) {
        StopRecognition stopRecognition = kv.getV();
        if (stopRecognition != null) {
            return stopRecognition;
        }
        try {
            stopRecognition = new StopRecognition();
            LOG.debug("begin init FILTER !");
            long start = System.currentTimeMillis();
            String temp = null;
            String[] strs = null;
            BufferedReader br = IOUtil.getReader((InputStream)PathToStream.stream(kv.getK()), (String)"UTF-8");
            Throwable throwable = null;
            try {
                block19: while ((temp = br.readLine()) != null) {
                    if (!StringUtil.isNotBlank((CharSequence)temp)) continue;
                    strs = (temp = StringUtil.trim((String)temp)).split("\t");
                    if (strs.length == 1) {
                        stopRecognition.insertStopWords(strs[0]);
                        continue;
                    }
                    String string = strs[1];
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1052607321: {
                            if (!string.equals("nature")) break;
                            n = 0;
                            break;
                        }
                        case 108392519: {
                            if (!string.equals("regex")) break;
                            n = 1;
                            break;
                        }
                    }
                    switch (n) {
                        case 0: {
                            stopRecognition.insertStopNatures(strs[0]);
                            continue block19;
                        }
                        case 1: {
                            stopRecognition.insertStopRegexes(strs[0]);
                            continue block19;
                        }
                    }
                    stopRecognition.insertStopWords(strs[0]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        br.close();
                    }
                }
            }
            LOG.info("load stop use time:" + (System.currentTimeMillis() - start) + " path is : " + kv.getK());
            kv.setV(stopRecognition);
            return stopRecognition;
        }
        catch (Exception e) {
            LOG.error("Init Stop library error :" + e.getMessage() + ", path: " + kv.getK());
            STOP.remove(key);
            return null;
        }
    }

    public static void put(String key, String path, StopRecognition stopRecognition) {
        KV<String, StopRecognition> kv = STOP.get(key);
        if (kv == null) {
            kv = KV.with(path, stopRecognition);
        } else {
            kv.setK(path);
            kv.setV(stopRecognition);
        }
        STOP.put(key, kv);
    }

    public static void putIfAbsent(String key, String path) {
        if (!STOP.containsKey(key)) {
            STOP.put(key, KV.with(path, null));
        }
    }

    public static void put(String key, String path) {
        StopLibrary.put(key, path, null);
    }

    public static synchronized StopRecognition putIfAbsent(String key, String path, StopRecognition stopRecognition) {
        KV<String, StopRecognition> kv = STOP.get(key);
        if (kv != null && kv.getV() != null) {
            return kv.getV();
        }
        StopLibrary.put(key, path, stopRecognition);
        return stopRecognition;
    }

    public static KV<String, StopRecognition> remove(String key) {
        return STOP.remove(key);
    }

    public static Set<String> keys() {
        return STOP.keySet();
    }

    public static void reload(String key) {
        KV<String, StopRecognition> kv = STOP.get(key);
        if (kv != null) {
            STOP.get(key).setV(null);
        }
    }

    static {
        for (Map.Entry<String, String> entry : MyStaticValue.ENV.entrySet()) {
            if (!entry.getKey().startsWith(DEFAULT)) continue;
            StopLibrary.put(entry.getKey(), entry.getValue());
        }
        StopLibrary.putIfAbsent(DEFAULT, "library/stop.dic");
    }
}

