/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.tool.Attribute;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class NameSpaceChecker {
    protected Grammar grammar;

    public NameSpaceChecker(Grammar grammar) {
        this.grammar = grammar;
    }

    public void checkConflicts() {
        for (int i = 1; i < this.grammar.composite.ruleIndexToRuleList.size(); ++i) {
            Rule r = this.grammar.composite.ruleIndexToRuleList.elementAt(i);
            if (r == null) continue;
            if (r.labelNameSpace != null) {
                Iterator<Grammar.LabelElementPair> it = r.labelNameSpace.values().iterator();
                while (it.hasNext()) {
                    Grammar.LabelElementPair pair = it.next();
                    this.checkForLabelConflict(r, pair.label);
                }
            }
            if (r.ruleScope != null) {
                List<Attribute> attributes = r.ruleScope.getAttributes();
                for (int j = 0; j < attributes.size(); ++j) {
                    Attribute attribute = attributes.get(j);
                    this.checkForRuleScopeAttributeConflict(r, attribute);
                }
            }
            this.checkForRuleDefinitionProblems(r);
            this.checkForRuleArgumentAndReturnValueConflicts(r);
        }
        Iterator it = this.grammar.getGlobalScopes().values().iterator();
        while (it.hasNext()) {
            AttributeScope scope = (AttributeScope)it.next();
            this.checkForGlobalScopeTokenConflict(scope);
        }
        this.lookForReferencesToUndefinedSymbols();
    }

    protected void checkForRuleArgumentAndReturnValueConflicts(Rule r) {
        Set conflictingKeys;
        if (r.returnScope != null && (conflictingKeys = r.returnScope.intersection(r.parameterScope)) != null) {
            Iterator it = conflictingKeys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                ErrorManager.grammarError(126, this.grammar, r.tree.getToken(), key, r.name);
            }
        }
    }

    protected void checkForRuleDefinitionProblems(Rule r) {
        String ruleName = r.name;
        Token ruleToken = r.tree.getToken();
        int msgID = 0;
        if ((this.grammar.type == 2 || this.grammar.type == 3) && Character.isUpperCase(ruleName.charAt(0))) {
            msgID = 102;
        } else if (this.grammar.type == 1 && Character.isLowerCase(ruleName.charAt(0)) && !r.isSynPred) {
            msgID = 103;
        } else if (this.grammar.getGlobalScope(ruleName) != null) {
            msgID = 118;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, ruleToken, ruleName);
        }
    }

    protected void lookForReferencesToUndefinedSymbols() {
        Rule rule;
        Iterator<Object> iter = this.grammar.ruleRefs.iterator();
        while (iter.hasNext()) {
            GrammarAST refAST = iter.next();
            Token tok = refAST.token;
            String ruleName = tok.getText();
            Rule localRule = this.grammar.getLocallyDefinedRule(ruleName);
            rule = this.grammar.getRule(ruleName);
            if (localRule == null && rule != null) {
                this.grammar.delegatedRuleReferences.add(rule);
                rule.imported = true;
            }
            if (rule != null || this.grammar.getTokenType(ruleName) == -1) continue;
            ErrorManager.grammarError(106, this.grammar, tok, ruleName);
        }
        if (this.grammar.type == 4) {
            iter = this.grammar.tokenIDRefs.iterator();
            while (iter.hasNext()) {
                Token tok = (Token)iter.next();
                String tokenID = tok.getText();
                if (this.grammar.composite.lexerRules.contains(tokenID) || this.grammar.getTokenType(tokenID) == -1) continue;
                ErrorManager.grammarWarning(105, this.grammar, tok, tokenID);
            }
        }
        Iterator<GrammarAST> it = this.grammar.scopedRuleRefs.iterator();
        while (it.hasNext()) {
            GrammarAST scopeAST = it.next();
            Grammar scopeG = this.grammar.composite.getGrammar(scopeAST.getText());
            GrammarAST refAST = (GrammarAST)scopeAST.getChild(1);
            String ruleName = refAST.getText();
            if (scopeG == null) {
                ErrorManager.grammarError(156, this.grammar, scopeAST.getToken(), scopeAST.getText(), ruleName);
                continue;
            }
            rule = this.grammar.getRule(scopeG.name, ruleName);
            if (rule != null) continue;
            ErrorManager.grammarError(157, this.grammar, scopeAST.getToken(), scopeAST.getText(), ruleName);
        }
    }

    protected void checkForGlobalScopeTokenConflict(AttributeScope scope) {
        if (this.grammar.getTokenType(scope.getName()) != -7) {
            ErrorManager.grammarError(118, this.grammar, null, scope.getName());
        }
    }

    public void checkForRuleScopeAttributeConflict(Rule r, Attribute attribute) {
        int msgID = 0;
        String arg2 = null;
        String attrName = attribute.name;
        if (r.name.equals(attrName)) {
            msgID = 123;
            arg2 = r.name;
        } else if (r.returnScope != null && r.returnScope.getAttribute(attrName) != null || r.parameterScope != null && r.parameterScope.getAttribute(attrName) != null) {
            msgID = 124;
            arg2 = r.name;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, r.tree.getToken(), attrName, arg2);
        }
    }

    protected void checkForLabelConflict(Rule r, Token label) {
        int msgID = 0;
        String arg2 = null;
        if (this.grammar.getGlobalScope(label.getText()) != null) {
            msgID = 118;
        } else if (this.grammar.getRule(label.getText()) != null) {
            msgID = 119;
        } else if (this.grammar.getTokenType(label.getText()) != -7) {
            msgID = 120;
        } else if (r.ruleScope != null && r.ruleScope.getAttribute(label.getText()) != null) {
            msgID = 121;
            arg2 = r.name;
        } else if (r.returnScope != null && r.returnScope.getAttribute(label.getText()) != null || r.parameterScope != null && r.parameterScope.getAttribute(label.getText()) != null) {
            msgID = 122;
            arg2 = r.name;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, label, label.getText(), arg2);
        }
    }

    public boolean checkForLabelTypeMismatch(Rule r, Token label, int type) {
        Grammar.LabelElementPair prevLabelPair = r.labelNameSpace.get(label.getText());
        if (prevLabelPair != null && prevLabelPair.type != type) {
            String typeMismatchExpr = Grammar.LabelTypeToString[type] + "!=" + Grammar.LabelTypeToString[prevLabelPair.type];
            ErrorManager.grammarError(125, this.grammar, label, label.getText(), typeMismatchExpr);
            return true;
        }
        return false;
    }
}

