/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.views.Page;

public class HeroImagePage
extends Page {
    private static final String COLOR_TITLE = "#505050";
    private static final String COLOR_DESCRIPTION = "#9B9B9B";
    private ImageDescriptor heroImage;
    private String title;
    private String description;

    public HeroImagePage(ImageDescriptor heroImage, String title, String description) {
        Assert.isNotNull((Object)heroImage);
        this.heroImage = heroImage;
        this.title = title;
        this.description = description;
    }

    protected Control doCreateControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Control centerControl = this.createHeroControl(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo(centerControl);
        return composite;
    }

    protected Control createHeroControl(Composite parent) {
        Control actionBar;
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 24).applyTo(composite);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage((Image)resources.get((DeviceResourceDescriptor)this.heroImage));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)imageLabel);
        Point imageSize = imageLabel.computeSize(-1, -1);
        if (this.title != null || this.description != null) {
            Control textArea = this.createTextArea(composite, (ResourceManager)resources);
            GridDataFactory.fillDefaults().align(0x1000000, 4).grab(true, false).hint(imageSize.x + 140, -1).applyTo(textArea);
        }
        if ((actionBar = this.createActionBar(composite)) != null) {
            GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 4).hint(imageSize.x, -1).applyTo(actionBar);
        }
        return composite;
    }

    protected Control createTextArea(Composite parent, ResourceManager resources) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 12).applyTo(composite);
        if (this.title != null) {
            Label titleLabel = new Label(composite, 0);
            titleLabel.setForeground((Color)resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_TITLE)));
            titleLabel.setFont((Font)resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().withStyle(1).setHeight(14)));
            titleLabel.setText(this.title);
            GridDataFactory.fillDefaults().align(0x1000000, 4).grab(true, false).applyTo((Control)titleLabel);
        }
        if (this.description != null) {
            Label descriptionLabel = new Label(composite, 0x1000040);
            descriptionLabel.setForeground((Color)resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_DESCRIPTION)));
            descriptionLabel.setFont((Font)resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setStyle(0).setHeight(12)));
            descriptionLabel.setText(this.description);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)descriptionLabel);
        }
        return composite;
    }

    protected Control createActionBar(Composite parent) {
        Composite actionBar = new Composite(parent, 0);
        actionBar.setBackground(parent.getBackground());
        actionBar.setForeground(parent.getForeground());
        this.fillActionBar(actionBar);
        Control[] actionItems = actionBar.getChildren();
        int actionItemsLength = actionItems.length;
        if (actionItemsLength == 0) {
            actionBar.dispose();
            return null;
        }
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(7, 7).numColumns(actionItemsLength).applyTo(actionBar);
        if (actionItemsLength == 2) {
            GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 4).applyTo(actionItems[0]);
            GridDataFactory.fillDefaults().grab(true, false).align(1, 4).applyTo(actionItems[1]);
        } else {
            int i = 0;
            while (i < actionItemsLength) {
                GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 4).applyTo(actionItems[i]);
                ++i;
            }
        }
        return actionBar;
    }

    protected void fillActionBar(Composite actionBar) {
    }
}

