/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import net.xmind.core.IAccount;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpEntityProxy;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.ObjectRefManager;
import org.xmind.core.util.ObjectRegistry;
import org.xmind.seawind.internal.core.ExtensionsDeserializer;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.PathInfo;
import org.xmind.seawind.internal.core.SPath;
import org.xmind.seawind.internal.core.STitled;
import org.xmind.seawind.internal.core.SeawindClient;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.seawind.internal.core.SeawindHttpException;
import org.xmind.seawind.internal.core.SeawindSheet;
import org.xmind.seawind.internal.core.SeawindWorkbook;
import org.xmind.seawind.internal.core.SeawindWorkingSet;
import org.xmind.seawind.internal.core.SheetDeserializer;
import org.xmind.seawind.internal.core.StorageEntryEntity;
import org.xmind.ui.internal.seawind.ISeawindSyncer;
import org.xmind.ui.internal.seawind.JobRunner;
import org.xmind.ui.internal.seawind.SeawindErrorCodes;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindSyncException;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.internal.seawind.SyncConstraint;

public class SeawindSyncer
implements ISeawindSyncer {
    private final SeawindLibrary library;
    private final SeawindClient client;
    private final JobRunner jobRunner;
    private Job nextSyncJob;
    private int syncIntervals;
    private boolean logSnapshots;
    private final SyncConstraint syncConstraint;

    public SeawindSyncer(SeawindLibrary library, SeawindClient client, JobRunner jobRunner) {
        int intervals;
        Assert.isLegal((library != null ? 1 : 0) != 0);
        Assert.isLegal((client != null ? 1 : 0) != 0);
        Assert.isLegal((jobRunner != null ? 1 : 0) != 0);
        this.library = library;
        this.client = client;
        this.jobRunner = jobRunner;
        this.nextSyncJob = null;
        String debugIntervals = SeawindUIPlugin.getDebugOption("/debug/sync/intervals", null);
        if (debugIntervals != null) {
            try {
                intervals = Integer.parseInt(debugIntervals, 10);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("[DEBUG] Invalid sync intervals (/debug/sync/intervals): " + debugIntervals);
                intervals = 300000;
            }
        } else {
            intervals = 300000;
        }
        this.syncIntervals = intervals;
        this.logSnapshots = SeawindUIPlugin.isDebugging("/debug/sync/log/snapshots", false);
        this.syncConstraint = library.getSyncConstraint();
    }

    public void startUp(final IAccount account) {
        final String userName = (String)account.getProperty("user");
        final String authToken = (String)account.getProperty("token");
        this.jobRunner.on(true);
        this.jobRunner.run(SeawindMessages.Sync_jobName, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (account.isAuthenticated()) {
                    SeawindSyncer.this.client.grantAuthorization(userName, authToken);
                }
                String oldUserName = SeawindSyncer.this.library.getUserName();
                if (userName == null || !userName.equals(oldUserName)) {
                    SeawindSyncer.this.clearLibrary();
                }
                SeawindSyncer.this.library.setUserName(userName);
                SeawindSyncer.this.sync(monitor, false);
            }
        });
    }

    public void shutDown(IProgressMonitor monitor) throws InterruptedException {
        this.stopAll();
        this.jobRunner.on(false);
        Job.getJobManager().join(this.jobRunner.getFamily(), monitor);
    }

    private void stopAll() {
        if (this.nextSyncJob != null) {
            this.nextSyncJob.cancel();
            this.nextSyncJob = null;
        }
        Job.getJobManager().cancel(this.jobRunner.getFamily());
    }

    public void onAuthorized(IAccount account) {
        final String userName = (String)account.getProperty("user");
        final String authToken = (String)account.getProperty("token");
        final boolean isCnUser = account.isCnUser();
        this.jobRunner.run(SeawindMessages.Sync_jobName, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SeawindSyncer.this.client.grantAuthorization(userName, authToken);
                SeawindSyncer.this.client.setCnUser(isCnUser);
                String oldUserName = SeawindSyncer.this.library.getUserName();
                if (!userName.equals(oldUserName)) {
                    SeawindSyncer.this.clearLibrary();
                }
                SeawindSyncer.this.library.setUserName(userName);
                SeawindSyncer.this.sync(monitor, false);
            }
        });
    }

    public void onUnauthorized(IAccount account) {
        final boolean toClear = !account.isAuthenticationExpired();
        final boolean isCnUser = account.isCnUser();
        this.stopAll();
        this.jobRunner.run(SeawindMessages.RemoveLocalData_jobName, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SeawindSyncer.this.client.revokeAuthorization();
                SeawindSyncer.this.client.setCnUser(isCnUser);
                SeawindSyncer.this.stopAll();
                if (toClear) {
                    SeawindSyncer.this.clearLibrary();
                }
            }
        });
    }

    private void clearLibrary() {
        this.library.removeAll();
    }

    @Override
    public void sync() {
        if (!this.client.isAuthorized()) {
            return;
        }
        if (this.library.isSyncing()) {
            return;
        }
        this.jobRunner.run(SeawindMessages.Sync_jobName, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SeawindSyncer.this.sync(monitor, false);
            }
        });
    }

    private void sync(IProgressMonitor monitor, boolean secondarySync) throws InterruptedException {
        if (this.nextSyncJob != null && this.nextSyncJob != Job.getJobManager().currentJob()) {
            this.nextSyncJob.cancel();
            this.nextSyncJob = null;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean shouldRetry = false;
        try {
            this.library.setGlobalSyncError(null);
            if (!this.client.isAuthorized()) {
                this.library.setStatus(1);
                this.scheduleNextSync(false);
                return;
            }
            try {
                boolean hasContent = this.library.getWorkingSet().getStorage().getInputSource().hasEntry("workbooks.json");
                if (this.library.isActive() && hasContent) {
                    this.library.setStatus(10);
                } else {
                    this.library.setStatus(2);
                }
                boolean hasUploadsOrCovering = new SyncSession().exec((IProgressMonitor)subMonitor);
                if (hasUploadsOrCovering && !secondarySync) {
                    shouldRetry = true;
                }
                if (this.library.isActive()) {
                    this.library.setStatus(11);
                } else {
                    this.library.setStatus(3);
                }
            }
            catch (InterruptedException e) {
                subMonitor.setCanceled(true);
                throw e;
            }
            catch (HttpException e) {
                SeawindHttpException se;
                if (e instanceof SeawindHttpException && (se = (SeawindHttpException)((Object)e)).getCode() == 403 && se.getSubCode() == 4032) {
                    boolean wasActive = this.library.isActive();
                    this.library.setActive(false);
                    if (wasActive) {
                        this.library.setStatus(2);
                    }
                    shouldRetry = true;
                    return;
                }
                if (e.getCode() == 401) {
                    this.client.revokeAuthorization();
                    this.stopAll();
                    this.library.setStatus(1);
                    return;
                }
                SeawindUIPlugin.log(e, "Sync failed.");
                if (e.getCode() < 100) {
                    this.library.setGlobalSyncError(SeawindMessages.SyncError_NetworkError);
                } else {
                    this.library.setGlobalSyncError(NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)));
                }
                if (!this.library.isActive()) {
                    this.library.setStatus(4);
                } else {
                    this.library.setStatus(11);
                }
            }
            catch (Throwable e) {
                SeawindUIPlugin.log(e, "Sync failed.");
                if (e instanceof SocketException || e instanceof SocketTimeoutException) {
                    this.library.setGlobalSyncError(SeawindMessages.SyncError_NetworkError);
                } else {
                    this.library.setGlobalSyncError(NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)));
                }
                if (!this.library.isActive()) {
                    this.library.setStatus(4);
                } else {
                    this.library.setStatus(11);
                }
            }
        }
        finally {
            if (monitor == null || !monitor.isCanceled()) {
                this.scheduleNextSync(shouldRetry);
            }
        }
    }

    private void scheduleNextSync(final boolean shouldStartShortlyAfter) {
        if (this.nextSyncJob != null) {
            this.nextSyncJob.cancel();
            this.nextSyncJob = null;
        }
        this.nextSyncJob = this.jobRunner.make(SeawindMessages.Sync_jobName, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SeawindSyncer.this.sync(monitor, shouldStartShortlyAfter);
            }
        });
        int delay = shouldStartShortlyAfter ? 1000 : this.syncIntervals;
        this.nextSyncJob.schedule((long)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWorkbookAsUploading(String workbookId) {
        Object object = this.library.getWorkingSetLock();
        synchronized (object) {
            SeawindWorkbookRef workbookRef = this.library.findWorkbookRefById(workbookId);
            if (workbookRef != null) {
                workbookRef.setSyncStatus(0, SeawindWorkbookRef.SYNC_STATUS_UPLOADING, SeawindWorkbookRef.LABEL_SYNCING);
                workbookRef.setSyncError(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWorkbookAsDownloading(String workbookId) {
        Object object = this.library.getWorkingSetLock();
        synchronized (object) {
            SeawindWorkbookRef workbookRef = this.library.findWorkbookRefById(workbookId);
            if (workbookRef != null) {
                workbookRef.setSyncStatus(0, SeawindWorkbookRef.SYNC_STATUS_DOWNLOADING, SeawindWorkbookRef.LABEL_SYNCING);
                workbookRef.setSyncError(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWorkbookAsSynced(String workbookId) {
        Object object = this.library.getWorkingSetLock();
        synchronized (object) {
            SeawindWorkbookRef workbookRef = this.library.findWorkbookRefById(workbookId);
            if (workbookRef != null) {
                workbookRef.setPending(false);
                workbookRef.setSyncStatus(0, SeawindWorkbookRef.SYNC_STATUS_SYNCED, null);
                workbookRef.setSyncError(null);
            }
        }
    }

    private void markSheetContentHash(IStorage sheetStorage, String rev, String contentHash) throws IOException {
        String newContentPath = EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{rev});
        SeawindClient.writeText((String)contentHash, (IOutputTarget)sheetStorage.getOutputTarget(), (String)SeawindClient.toHashPath((String)newContentPath));
    }

    private void ensureSheetContent(IStorage sheetStorage, String rev) {
        String contentHash;
        IInputSource source = sheetStorage.getInputSource();
        String newContentPath = EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{rev});
        String newPreviewPath = EncodingUtils.format((String)"revs/%s/preview.png", (Object[])new Object[]{rev});
        String newThumbnailPath = EncodingUtils.format((String)"revs/%s/thumbnail.png", (Object[])new Object[]{rev});
        if (source.hasEntry(newContentPath)) {
            return;
        }
        String contentHashPath = SeawindClient.toHashPath((String)newContentPath);
        if (!source.hasEntry(contentHashPath)) {
            return;
        }
        try {
            contentHash = SeawindClient.readText((IInputSource)source, (String)contentHashPath);
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, "Failed to read sheet content hash from: " + contentHashPath);
            return;
        }
        String hashedContentPath = EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash});
        String hashedPreviewPath = EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash});
        String hashedThumbnailPath = EncodingUtils.format((String)"hashs/%s/thumbnail.png", (Object[])new Object[]{contentHash});
        if (source.hasEntry(hashedPreviewPath)) {
            sheetStorage.renameEntry(hashedPreviewPath, newPreviewPath);
        }
        if (source.hasEntry(hashedThumbnailPath)) {
            sheetStorage.renameEntry(hashedThumbnailPath, newThumbnailPath);
        }
        if (source.hasEntry(hashedContentPath)) {
            sheetStorage.renameEntry(hashedContentPath, newContentPath);
            sheetStorage.deleteEntry(SeawindClient.toHashPath((String)hashedContentPath));
        }
    }

    private Set<String> collectResourcesToDownload(SeawindWorkbook swWorkbook) throws IOException {
        Workbook workbook = new Workbook((IStorage)new ByteArrayStorage(), "3.0", true, "resources/");
        SheetDeserializer deserializer = new SheetDeserializer(workbook);
        HashSet<String> resources = new HashSet<String>();
        for (SeawindSheet swSheet : swWorkbook.getSheets()) {
            String contentPath;
            Sheet sheet = new Sheet(workbook, swSheet.getId(), true);
            sheet.setTitleText(swSheet.getTitle());
            IInputSource source = swSheet.getStorage().getInputSource();
            if (swSheet.getRevAsContentHash() != null || !source.hasEntry(contentPath = EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{swSheet.getRev()}))) continue;
            JSONObject sheetObject = JSON.readObjectWithDamageCheck((IStorage)swSheet.getStorage(), (String)contentPath);
            deserializer.deserialize(sheet, sheetObject);
            workbook.addSheet((ISheet)sheet);
        }
        IWorkbookExtensionManager wbExtManager = (IWorkbookExtensionManager)workbook.getAdapter(IWorkbookExtensionManager.class);
        IInputSource extensionsSource = swWorkbook.getStorage().getInputSource();
        String extensionsHash = swWorkbook.getExtensionsRevAsContentHash();
        String extensionsPath = null;
        if (extensionsHash != null) {
            extensionsPath = EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
        } else if (swWorkbook.getExtensionsRev() != null) {
            extensionsPath = EncodingUtils.format((String)"revs/%s/extensions.json", (Object[])new Object[]{swWorkbook.getExtensionsRev()});
        }
        if (extensionsSource.hasEntry(extensionsPath)) {
            JSONObject extensionsObject = JSON.readObjectWithDamageCheck((IStorage)swWorkbook.getStorage(), (String)extensionsPath);
            ExtensionsDeserializer extensionsDeserializer = new ExtensionsDeserializer();
            extensionsDeserializer.deserialize(wbExtManager, extensionsObject);
        }
        ObjectRefManager refManager = (ObjectRefManager)workbook.getAdapter(ObjectRefManager.class);
        IInputSource source = this.library.getSharedResourceStorage().getInputSource();
        for (String entryPath : refManager.getRefsFor((Object)workbook, "file-entry")) {
            if (!entryPath.startsWith("resources/") || entryPath.endsWith("/")) continue;
            PathInfo pathInfo = new PathInfo(entryPath);
            if (source.hasEntry(pathInfo.hash)) continue;
            resources.add(pathInfo.hash);
        }
        return resources;
    }

    private boolean checkResourcesToUpload(Set<String> resources) {
        IInputSource source = this.library.getSharedResourceStorage().getInputSource();
        for (String path : resources) {
            long size = source.getEntrySize(path);
            if (size < 0x1400000L) continue;
            return false;
        }
        return true;
    }

    private Set<String> collectResourcesToUpload(SeawindWorkbook swWorkbook) throws IOException {
        SeawindSyncer.ensureWorkbookStorage(swWorkbook);
        Workbook workbook = new Workbook((IStorage)new ByteArrayStorage(), "3.0", true, "resources/");
        SheetDeserializer deserializer = new SheetDeserializer(workbook);
        HashSet<String> resources = new HashSet<String>();
        for (SeawindSheet swSheet : swWorkbook.getSheets()) {
            Sheet sheet = new Sheet(workbook, swSheet.getId(), true);
            sheet.setTitleText(swSheet.getTitle());
            SeawindSyncer.ensureSheetStorage(swSheet);
            IInputSource source = swSheet.getStorage().getInputSource();
            String contentHash = swSheet.getRevAsContentHash();
            String contentPath = contentHash != null ? EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash}) : EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{swSheet.getRev()});
            if (!source.hasEntry(contentPath)) continue;
            JSONObject sheetObject = JSON.readObjectWithDamageCheck((IStorage)swSheet.getStorage(), (String)contentPath);
            deserializer.deserialize(sheet, sheetObject);
            workbook.addSheet((ISheet)sheet);
        }
        IWorkbookExtensionManager wbExtManager = (IWorkbookExtensionManager)workbook.getAdapter(IWorkbookExtensionManager.class);
        IInputSource extensionsSource = swWorkbook.getStorage().getInputSource();
        String extensionsHash = swWorkbook.getExtensionsRevAsContentHash();
        String extensionsPath = null;
        if (extensionsHash != null) {
            extensionsPath = EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
        } else if (swWorkbook.getExtensionsRev() != null) {
            extensionsPath = EncodingUtils.format((String)"revs/%s/extensions.json", (Object[])new Object[]{swWorkbook.getExtensionsRev()});
        }
        if (extensionsSource.hasEntry(extensionsPath)) {
            JSONObject extensionsObject = JSON.readObjectWithDamageCheck((IStorage)swWorkbook.getStorage(), (String)extensionsPath);
            ExtensionsDeserializer extensionsDeserializer = new ExtensionsDeserializer();
            extensionsDeserializer.deserialize(wbExtManager, extensionsObject);
        }
        ObjectRefManager refManager = (ObjectRefManager)workbook.getAdapter(ObjectRefManager.class);
        for (String entryPath : refManager.getRefsFor((Object)workbook, "file-entry")) {
            if (!entryPath.startsWith("resources/") || entryPath.endsWith("/")) continue;
            PathInfo pathInfo = new PathInfo(entryPath);
            if (this.library.isResourceUploaded(pathInfo.hash)) continue;
            resources.add(pathInfo.hash);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingWorkbookToLocal(SeawindWorkbook localWorkbook) {
        Object object = this.library.getWorkingSetLock();
        synchronized (object) {
            SeawindWorkbook managedWorkbook = this.library.getWorkingSet().findWorkbook(localWorkbook.getId());
            if (managedWorkbook == null) {
                managedWorkbook = new SeawindWorkbook(localWorkbook.toJSON());
                Object object2 = this.library.getSeawindFolderLock();
                synchronized (object2) {
                    SeawindFolderManager sfm = this.library.getSeawindFolderManager();
                    SeawindFolder rootFolder = sfm.getRootSeawindFolder();
                    SeawindFile seawindFile = sfm.getSeawindFile(managedWorkbook.getId());
                    if (seawindFile == null) {
                        rootFolder.addFile(new SeawindFile(managedWorkbook.getId()));
                    }
                }
                this.library.getWorkingSet().addWorkbook(managedWorkbook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWorkbookSyncException(String workbookId, Exception e) {
        if (e instanceof SeawindSyncException) {
            this.updateWorkbookSyncError(workbookId, e.getMessage());
            return;
        }
        SeawindUIPlugin.log(e, "Failed to sync workbook: " + workbookId);
        if (e instanceof HttpException && ((HttpException)((Object)e)).getCode() < 100 || e instanceof SocketException || e instanceof SocketTimeoutException) {
            this.updateWorkbookSyncError(workbookId, SeawindMessages.SyncError_NetworkError);
            return;
        }
        this.updateWorkbookSyncError(workbookId, NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)));
        int errorCode = SeawindErrorCodes.parse(e);
        if (errorCode == 4034001 || errorCode == 4042002) {
            SeawindWorkbookRef workbookRef;
            Object object = this.library.getWorkingSetLock();
            synchronized (object) {
                workbookRef = this.library.findWorkbookRefById(workbookId);
            }
            if (workbookRef != null) {
                workbookRef.setPending(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWorkbookSyncError(String workbookId, String error) {
        SeawindWorkbookRef workbookRef;
        Object object = this.library.getWorkingSetLock();
        synchronized (object) {
            workbookRef = this.library.findWorkbookRefById(workbookId);
        }
        if (workbookRef != null) {
            workbookRef.setSyncError(error);
        }
    }

    private boolean lastModifiedByCurrentClient(SeawindWorkbook remoteWorkbook) {
        String xClientId = this.library.findXClientId();
        String workbookUpdateBy = remoteWorkbook.getUpdateBy();
        return xClientId.equals(workbookUpdateBy);
    }

    private static IStorage ensureWorkbookStorage(SeawindWorkbook workbook) {
        if (workbook.getStorage() != null) {
            return workbook.getStorage();
        }
        workbook.setStorage(SeawindLibrary.newStorageForWorkbook(workbook.getParent().getStorage(), workbook.getId()));
        return workbook.getStorage();
    }

    private static IStorage ensureSheetStorage(SeawindSheet sheet) {
        if (sheet.getStorage() != null) {
            return sheet.getStorage();
        }
        sheet.setStorage(SeawindLibrary.newStorageForSheet(sheet.getParent().getStorage(), sheet.getId()));
        return sheet.getStorage();
    }

    private static String getTitle(STitled titled) {
        String title = titled.getTitle();
        return title == null ? SeawindMessages.SeawindWorkbookRef_UntitledWorkbookName : title;
    }

    private static boolean objectEquals(Object oldValue, Object newValue) {
        return oldValue == newValue || oldValue != null && oldValue.equals(newValue);
    }

    private class AddSheetToRemote
    implements ISyncRunnable {
        private final SeawindWorkbook baseWorkbook;
        private final SeawindSheet localSheet;

        public AddSheetToRemote(SeawindSheet localSheet, SeawindWorkbook baseWorkbook) {
            this.baseWorkbook = baseWorkbook;
            this.localSheet = localSheet;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            JSONObject sheetObject;
            SeawindSyncer.this.markWorkbookAsUploading(this.baseWorkbook.getId());
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_UploadingNewSheet_withSheetName, (Object)SeawindSyncer.getTitle((STitled)this.localSheet)));
            IStorage sheetStorage = SeawindSyncer.ensureSheetStorage(this.localSheet);
            IInputSource source = sheetStorage.getInputSource();
            String contentHash = this.localSheet.getRevAsContentHash();
            String contentPath = contentHash == null ? null : EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash});
            StorageEntryEntity content = contentHash != null && source.hasEntry(contentPath) ? new StorageEntryEntity(source, contentPath) : null;
            String previewPath = contentHash == null ? null : EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash});
            StorageEntryEntity previewImage = previewPath != null && source.hasEntry(previewPath) ? new StorageEntryEntity(source, previewPath) : null;
            try {
                sheetObject = SeawindSyncer.this.client.uploadSheet((IProgressMonitor)subMonitor, this.baseWorkbook.getId(), this.localSheet.getId(), this.localSheet.toJSON(), (HttpEntity)content, (HttpEntity)previewImage);
            }
            catch (SeawindHttpException e) {
                if (e.getCode() == 403 && e.getSubCode() == 4301) {
                    throw new SeawindSyncException(SeawindMessages.SyncError_StorageFull, e);
                }
                throw e;
            }
            catch (SeawindClient.MissingFileException e) {
                throw new IOException(NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)), e);
            }
            SeawindSheet baseSheet = new SeawindSheet(sheetObject);
            this.baseWorkbook.addSheet(baseSheet);
            SeawindSyncer.this.markSheetContentHash(sheetStorage, baseSheet.getRev(), contentHash);
            this.localSheet.setRev(baseSheet.getRev());
            this.localSheet.setTitle(baseSheet.getTitle());
            this.localSheet.setModificationTime(baseSheet.getModificationTime());
        }

        @Override
        public boolean hasUploads() {
            return true;
        }
    }

    private class AddWorkbookToRemote
    implements ISyncRunnable {
        private final SeawindWorkbook localWorkbook;
        private final SeawindWorkingSet baseWorkingSet;
        private final SeawindWorkingSet remoteWorkingSet;

        public AddWorkbookToRemote(SeawindWorkbook localWorkbook, SeawindWorkingSet baseWorkingSet, SeawindWorkingSet remoteWorkingSet) {
            this.localWorkbook = localWorkbook;
            this.baseWorkingSet = baseWorkingSet;
            this.remoteWorkingSet = remoteWorkingSet;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            JSONObject workbookObject;
            StorageEntryEntity extensions;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.localWorkbook.getId());
            if (syncState != null && syncState.conflictSource != null && syncState.sheetsMapping != null) {
                SyncConstraint.SyncState syncStateOfConflictingFile;
                String remoteWorkbookId = syncState.conflictSource;
                SeawindWorkbook remoteWorkbook = this.remoteWorkingSet.findWorkbook(remoteWorkbookId);
                if (remoteWorkbook != null) {
                    SeawindSyncer.this.markWorkbookAsDownloading(this.localWorkbook.getId());
                    IStorage workbookStorage = SeawindSyncer.ensureWorkbookStorage(this.localWorkbook);
                    List localSheets = this.localWorkbook.getSheets();
                    SubMonitor loopProgress = subMonitor.newChild(50).setWorkRemaining(localSheets.size() * 2);
                    Iterator iterator = localSheets.iterator();
                    while (iterator.hasNext()) {
                        SeawindSheet localSheet = (SeawindSheet)iterator.next();
                        String remoteSheetId = syncState.sheetsMapping.optString(localSheet.getId());
                        SeawindSheet remoteSheet = remoteWorkbook.findSheet(remoteSheetId);
                        SeawindSheet baseSheet = this.baseWorkingSet.findWorkbook(remoteWorkbookId).findSheet(remoteSheetId);
                        if (remoteSheet == null) continue;
                        String tempContentPath = "content.json";
                        String tempPreviewPath = "preview.png";
                        String tempThumbnailPath = "thumbnail.png";
                        IStorage sheetStorage = SeawindSyncer.ensureSheetStorage(localSheet);
                        new DownloadSheetContent(remoteWorkbookId, remoteSheet, baseSheet, localSheet, tempContentPath, sheetStorage).run((IProgressMonitor)loopProgress.newChild(1));
                        new DownloadSheetPreviewImage(remoteWorkbookId, remoteSheet, tempPreviewPath, sheetStorage).run((IProgressMonitor)loopProgress.newChild(1));
                        new DownloadSheetThumbnailImage(remoteWorkbookId, remoteSheet, tempThumbnailPath, sheetStorage).run((IProgressMonitor)loopProgress.newChild(1));
                        String contentHash = SeawindClient.getFileHash((IInputSource)sheetStorage.getInputSource(), (String)tempContentPath);
                        String contentPath = EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash});
                        String previewPath = EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash});
                        sheetStorage.renameEntry(tempContentPath, contentPath);
                        sheetStorage.renameEntry(tempPreviewPath, previewPath);
                        sheetStorage.renameEntry(SeawindClient.toHashPath((String)tempContentPath), SeawindClient.toHashPath((String)contentPath));
                        localSheet.setRevAsContentHash(contentHash);
                    }
                    if (remoteWorkbook.getExtensionsRev() != null) {
                        String tempExtensionsPath = "extensions.json";
                        new DownloadExtensions(remoteWorkbookId, tempExtensionsPath, workbookStorage, remoteWorkbook.getExtensionsHash()).run((IProgressMonitor)loopProgress.newChild(1));
                        String extensionsHash = SeawindClient.getFileHash((IInputSource)workbookStorage.getInputSource(), (String)tempExtensionsPath);
                        String extensionsPath = EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
                        workbookStorage.renameEntry(tempExtensionsPath, extensionsPath);
                        workbookStorage.renameEntry(SeawindClient.toHashPath((String)tempExtensionsPath), SeawindClient.toHashPath((String)extensionsPath));
                        this.localWorkbook.setExtensionsRevAsContentHash(extensionsHash);
                    }
                }
                syncState.conflictSource = null;
                syncState.sheetsMapping = null;
                if (syncState.isNone()) {
                    SeawindSyncer.this.syncConstraint.unregister(this.localWorkbook.getId());
                }
                if (remoteWorkbook != null && (syncStateOfConflictingFile = SeawindSyncer.this.syncConstraint.getSyncState(remoteWorkbook.getId())) != null && syncStateOfConflictingFile.conflicting) {
                    syncStateOfConflictingFile.conflicting = false;
                    if (syncStateOfConflictingFile.isNone()) {
                        SeawindSyncer.this.syncConstraint.unregister(remoteWorkbook.getId());
                    }
                }
            }
            SeawindSyncer.this.markWorkbookAsUploading(this.localWorkbook.getId());
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_UploadingNewWorkbook_withWorkbookName, (Object)SeawindSyncer.getTitle((STitled)this.localWorkbook)));
            SeawindSyncer.ensureWorkbookStorage(this.localWorkbook);
            Set resourcesToUpload = SeawindSyncer.this.collectResourcesToUpload(this.localWorkbook);
            if (!resourcesToUpload.isEmpty()) {
                if (!SeawindSyncer.this.checkResourcesToUpload(resourcesToUpload)) {
                    throw new SeawindSyncException(SeawindMessages.SyncError_LargeAttachment, null);
                }
                new UploadResources(resourcesToUpload, this.localWorkbook.getId()).run((IProgressMonitor)subMonitor.newChild(70));
            } else {
                SyncConstraint.SyncState syncStateForResourceUpload = SeawindSyncer.this.syncConstraint.getSyncState(this.localWorkbook.getId());
                if (syncStateForResourceUpload != null && syncStateForResourceUpload.resourceUploadUnfinished) {
                    syncStateForResourceUpload.resourceUploadUnfinished = false;
                    if (syncStateForResourceUpload.isNone()) {
                        SeawindSyncer.this.syncConstraint.unregister(this.localWorkbook.getId());
                    }
                }
            }
            subMonitor.setWorkRemaining(30);
            FieldSet files = new FieldSet();
            for (SeawindSheet localSheet : this.localWorkbook.getSheets()) {
                IStorage sheetStorage = SeawindSyncer.ensureSheetStorage(localSheet);
                IInputSource source = sheetStorage.getInputSource();
                String contentHash = localSheet.getRevAsContentHash();
                String contentPath = contentHash == null ? null : EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash});
                String previewPath = contentHash == null ? null : EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash});
                StorageEntryEntity content = contentHash != null && source.hasEntry(contentPath) ? new StorageEntryEntity(source, contentPath) : null;
                StorageEntryEntity previewImage = previewPath != null && source.hasEntry(previewPath) ? new StorageEntryEntity(source, previewPath) : null;
                SeawindSyncer.this.client.addSheetFiles(files, localSheet.getId(), (HttpEntity)content, (HttpEntity)previewImage);
            }
            IStorage extensionsStorage = this.localWorkbook.getStorage();
            IInputSource extensionsSource = extensionsStorage.getInputSource();
            String extensionsHash = this.localWorkbook.getExtensionsRevAsContentHash();
            String extensionsPath = extensionsHash == null ? null : EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
            StorageEntryEntity storageEntryEntity = extensions = extensionsHash != null && extensionsSource.hasEntry(extensionsPath) ? new StorageEntryEntity(extensionsSource, extensionsPath) : null;
            if (extensions != null) {
                if (!"application/vnd.seawind.object+json".equals(extensions.getContentType())) {
                    extensions = new HttpEntityProxy((HttpEntity)extensions, "application/vnd.seawind.object+json");
                }
                files.add("extensions.json", (Object)extensions);
            }
            try {
                workbookObject = SeawindSyncer.this.client.uploadWorkbook((IProgressMonitor)subMonitor.newChild(30), this.localWorkbook.getId(), this.localWorkbook.toJSON(), files);
            }
            catch (SeawindHttpException e) {
                if (e.getCode() == 403 && e.getSubCode() == 4301) {
                    throw new SeawindSyncException(SeawindMessages.SyncError_StorageFull, e);
                }
                throw e;
            }
            catch (SeawindClient.MissingFileException e) {
                throw new IOException(NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)), e);
            }
            SeawindWorkbook baseWorkbook = new SeawindWorkbook(workbookObject);
            this.baseWorkingSet.addWorkbook(baseWorkbook);
            for (SeawindSheet localSheet : this.localWorkbook.getSheets()) {
                SeawindSheet baseSheet = baseWorkbook.findSheet(localSheet.getId());
                if (baseSheet == null) continue;
                IStorage sheetStorage = SeawindSyncer.ensureSheetStorage(localSheet);
                String contentHash = localSheet.getRevAsContentHash();
                if (contentHash == null) continue;
                String rev = baseSheet.getRev();
                SeawindSyncer.this.markSheetContentHash(sheetStorage, rev, contentHash);
                localSheet.setRev(rev);
            }
            this.localWorkbook.setTitle(baseWorkbook.getTitle());
            this.localWorkbook.setModificationTime(baseWorkbook.getModificationTime());
            this.localWorkbook.setExtensionsRev(baseWorkbook.getExtensionsRev());
            SeawindSyncer.this.markWorkbookAsSynced(this.localWorkbook.getId());
        }

        @Override
        public boolean hasUploads() {
            return true;
        }
    }

    private class DownloadExtensions
    implements ISyncRunnable {
        private final String workbookId;
        private final String extensionPath;
        private final IStorage targetStorage;
        private final String hash;

        private DownloadExtensions(String workbookId, String extensionPath, IStorage targetStorage, String hash) {
            this.workbookId = workbookId;
            this.extensionPath = extensionPath;
            this.targetStorage = targetStorage;
            this.hash = hash;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(SeawindMessages.SyncStatus_DownloadingWorkbookExtensions);
            try {
                SeawindSyncer.this.client.downloadWorkbookExtensions((IProgressMonitor)subMonitor, this.workbookId, this.targetStorage.getOutputTarget(), this.extensionPath, this.hash);
            }
            catch (HttpException e) {
                if (e.getCode() == 404) {
                    SeawindUIPlugin.log(NLS.bind((String)"Failed to download workbook extensions({0}/{1}): {2}", (Object[])new Object[]{this.workbookId, this.hash, e.getStatus()}));
                }
                throw e;
            }
        }

        @Override
        public boolean hasUploads() {
            return false;
        }

        @Override
        public boolean canExecute() {
            boolean canExecute = true;
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncState != null && syncState.resourceUploadUnfinished) {
                canExecute = false;
            }
            return canExecute;
        }
    }

    private class DownloadResources
    implements ISyncRunnable {
        private Set<String> resources;
        private String workbookId;

        public DownloadResources(Set<String> resources, String workbookId) {
            this.resources = resources;
            this.workbookId = workbookId;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SeawindSyncer.this.markWorkbookAsDownloading(this.workbookId);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.resources.size());
            IStorage storage = SeawindSyncer.this.library.getSharedResourceStorage();
            IInputSource source = storage.getInputSource();
            IOutputTarget target = storage.getOutputTarget();
            subMonitor.subTask(SeawindMessages.SyncStatus_DownloadingAttachments);
            ArrayList<HttpException> exceptions = new ArrayList<HttpException>();
            for (String hash : this.resources) {
                if (source.hasEntry(hash)) continue;
                try {
                    SeawindSyncer.this.client.downloadResource((IProgressMonitor)subMonitor.newChild(1), hash, target);
                }
                catch (HttpException e) {
                    SeawindUIPlugin.log(NLS.bind((String)"Failed to download resource({0}/{1}): {2}", (Object[])new Object[]{this.workbookId, hash, e.getStatus()}));
                    if (e.getCode() == 404) continue;
                    exceptions.add(e);
                }
                if (!source.hasEntry(hash)) continue;
                SeawindSyncer.this.library.setResourceUploaded(hash);
            }
            try {
                if (exceptions.size() != 0) {
                    throw (HttpException)((Object)exceptions.get(0));
                }
            }
            finally {
                exceptions.clear();
                exceptions = null;
            }
        }

        @Override
        public boolean hasUploads() {
            return false;
        }

        @Override
        public boolean canExecute() {
            boolean canExecute = true;
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncState != null && syncState.resourceUploadUnfinished) {
                canExecute = false;
            }
            return canExecute;
        }
    }

    private class DownloadResourcesForWorkbook
    implements ISyncRunnable {
        private final SeawindWorkbook workbook;

        public DownloadResourcesForWorkbook(SeawindWorkbook workbook) {
            this.workbook = workbook;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SeawindSyncer.this.markWorkbookAsDownloading(this.workbook.getId());
            monitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_DeterminingAttachmentsForWorkbook_withWorkbookName, (Object)SeawindSyncer.getTitle((STitled)this.workbook)));
            Set resourcesToDownload = SeawindSyncer.this.collectResourcesToDownload(this.workbook);
            if (resourcesToDownload.isEmpty()) {
                return;
            }
            new DownloadResources(resourcesToDownload, this.workbook.getId()).run(monitor);
        }

        @Override
        public boolean hasUploads() {
            return false;
        }

        @Override
        public boolean canExecute() {
            boolean canExecute = true;
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.workbook.getId());
            if (syncState != null && syncState.resourceUploadUnfinished) {
                canExecute = false;
            }
            return canExecute;
        }
    }

    private class DownloadSheetContent
    implements ISyncRunnable {
        private final String workbookId;
        private final String contentPath;
        private final IStorage targetStorage;
        private final SeawindSheet remoteSheet;
        private final SeawindSheet baseSheet;
        private final SeawindSheet localSheet;

        private DownloadSheetContent(String workbookId, SeawindSheet remoteSheet, SeawindSheet baseSheet, SeawindSheet localSheet, String contentPath, IStorage targetStorage) {
            this.workbookId = workbookId;
            this.remoteSheet = remoteSheet;
            this.baseSheet = baseSheet;
            this.localSheet = localSheet;
            this.contentPath = contentPath;
            this.targetStorage = targetStorage;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_DownloadingSheetContent_withSheetName, (Object)SeawindSyncer.getTitle((STitled)this.localSheet)));
            boolean successed = false;
            try {
                SeawindSyncer.this.client.downloadSheetContent((IProgressMonitor)subMonitor, this.workbookId, this.remoteSheet.getId(), this.targetStorage.getOutputTarget(), this.contentPath, this.remoteSheet.getHash());
                successed = true;
            }
            catch (HttpException e) {
                if (e.getCode() == 404) {
                    SeawindUIPlugin.log(NLS.bind((String)"Failed to download sheet content({0}/{1}/{2}): {3}", (Object[])new Object[]{this.workbookId, this.remoteSheet.getId(), this.remoteSheet.getHash(), e.getStatus()}));
                }
                throw e;
            }
            if (successed) {
                this.baseSheet.setRev(this.remoteSheet.getRev());
                this.localSheet.setRev(this.remoteSheet.getRev());
            }
        }

        @Override
        public boolean hasUploads() {
            return false;
        }

        @Override
        public boolean canExecute() {
            boolean canExecute = true;
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncState != null && syncState.resourceUploadUnfinished) {
                canExecute = false;
            }
            return canExecute;
        }
    }

    private class DownloadSheetPreviewImage
    implements ISyncRunnable {
        private final String workbookId;
        private final SeawindSheet sheet;
        private final String previewPath;
        private final IStorage targetStorage;

        public DownloadSheetPreviewImage(String workbookId, SeawindSheet sheet, String previewPath, IStorage targetStorage) {
            this.workbookId = workbookId;
            this.sheet = sheet;
            this.previewPath = previewPath;
            this.targetStorage = targetStorage;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_DownloadingSheetPreviewImage_withSheetName, (Object)SeawindSyncer.getTitle((STitled)this.sheet)));
            try {
                SeawindSyncer.this.client.downloadSheetPreviewImage((IProgressMonitor)subMonitor.newChild(10), this.workbookId, this.sheet.getId(), this.targetStorage.getOutputTarget(), this.previewPath);
            }
            catch (HttpException e) {
                if (e.getCode() == 404) {
                    SeawindUIPlugin.log("Failed to download sheet preview image" + e.getStatus());
                }
                throw e;
            }
        }

        @Override
        public boolean hasUploads() {
            return false;
        }

        @Override
        public boolean canExecute() {
            boolean canExecute = true;
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncState != null && syncState.resourceUploadUnfinished) {
                canExecute = false;
            }
            return canExecute;
        }
    }

    private class DownloadSheetThumbnailImage
    implements ISyncRunnable {
        private final String workbookId;
        private final SeawindSheet sheet;
        private final String thumbnailPath;
        private final IStorage targetStorage;

        public DownloadSheetThumbnailImage(String workbookId, SeawindSheet sheet, String previewPath, IStorage targetStorage) {
            this.workbookId = workbookId;
            this.sheet = sheet;
            this.thumbnailPath = previewPath;
            this.targetStorage = targetStorage;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_DownloadingSheetPreviewImage_withSheetName, (Object)SeawindSyncer.getTitle((STitled)this.sheet)));
            try {
                SeawindSyncer.this.client.downloadSheetThumbnailImage((IProgressMonitor)subMonitor.newChild(10), this.workbookId, this.sheet.getId(), this.targetStorage.getOutputTarget(), this.thumbnailPath);
            }
            catch (HttpException e) {
                if (e.getCode() == 404) {
                    SeawindUIPlugin.log("Failed to download sheet thumbnail image" + e.getStatus());
                }
                throw e;
            }
        }

        @Override
        public boolean hasUploads() {
            return false;
        }

        @Override
        public boolean canExecute() {
            boolean canExecute = true;
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncState != null && syncState.resourceUploadUnfinished) {
                canExecute = false;
            }
            return canExecute;
        }
    }

    private class FinishWorkbookSync
    implements ISyncRunnable {
        private final SeawindWorkbook localWorkbook;
        private final SeawindWorkbook baseWorkbook;
        private final long newModificationTime;

        public FinishWorkbookSync(SeawindWorkbook localWorkbook, SeawindWorkbook baseWorkbook, long newModificationTime) {
            this.localWorkbook = localWorkbook;
            this.baseWorkbook = baseWorkbook;
            this.newModificationTime = newModificationTime;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SyncConstraint.SyncState syncState;
            if (this.newModificationTime > 0L) {
                this.baseWorkbook.setModificationTime(this.newModificationTime);
                this.localWorkbook.setModificationTime(this.newModificationTime);
            }
            if ((syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.localWorkbook.getId())) != null && syncState.newFileDownloadUnfinished) {
                syncState.newFileDownloadUnfinished = false;
                if (syncState.isNone()) {
                    SeawindSyncer.this.syncConstraint.unregister(this.localWorkbook.getId());
                }
            }
            SeawindSyncer.this.markWorkbookAsSynced(this.localWorkbook.getId());
        }

        @Override
        public boolean hasUploads() {
            return false;
        }
    }

    private class HandleSheetConflicting
    implements ISyncRunnable {
        private final SeawindWorkingSet baseWorkingSet;
        private final SeawindWorkingSet remoteWorkingSet;
        private final SeawindWorkbook remoteWorkbook;
        private final SeawindWorkbook localWorkbook;
        private final SeawindWorkbook baseWorkbook;
        private final long conflictTime;
        private final Map<String, SeawindSheet> sheetMapping;

        public HandleSheetConflicting(SeawindWorkingSet localWorkingSet, SeawindWorkingSet baseWorkingSet, SeawindWorkingSet remoteWorkingSet, SeawindWorkbook remoteWorkbook) {
            this.remoteWorkingSet = remoteWorkingSet;
            this.sheetMapping = new HashMap<String, SeawindSheet>();
            this.baseWorkingSet = baseWorkingSet;
            this.remoteWorkbook = remoteWorkbook;
            this.baseWorkbook = baseWorkingSet.findWorkbook(remoteWorkbook.getId());
            this.conflictTime = System.currentTimeMillis();
            SyncConstraint.SyncState syncState = new SyncConstraint.SyncState(new JSONObject());
            syncState.conflicting = true;
            SeawindSyncer.this.syncConstraint.register(remoteWorkbook.getId(), syncState);
            SeawindWorkbook baseWorkbook = baseWorkingSet.findWorkbook(remoteWorkbook.getId());
            if (baseWorkbook != null) {
                baseWorkingSet.removeWorkbook(baseWorkbook);
            }
            baseWorkingSet.addWorkbook(remoteWorkbook);
            try {
                baseWorkingSet.save(null);
            }
            catch (IOException | InterruptedException e) {
                SeawindUIPlugin.log(e, e.getMessage());
            }
            this.localWorkbook = new SeawindWorkbook(SeawindLibrary.createUniqueWorkbookId());
            this.init(localWorkingSet);
        }

        private void init(SeawindWorkingSet localWorkingSet) {
            SyncConstraint.SyncState syncState = new SyncConstraint.SyncState(new JSONObject());
            syncState.conflictSource = this.remoteWorkbook.getId();
            String conflictTimestamp = String.format("%1$ty-%1$tm-%1$td %1$tH:%1$tM", this.conflictTime);
            String newWorkbookTitle = NLS.bind((String)SeawindMessages.ConflictedWorkbookName_withOldWorkbookName_andConflictTime, (Object)SeawindSyncer.getTitle((STitled)this.remoteWorkbook), (Object)conflictTimestamp);
            this.localWorkbook.setTitle(newWorkbookTitle);
            for (SeawindSheet remoteSheet : this.remoteWorkbook.getSheets()) {
                SeawindSheet localSheet = new SeawindSheet(ObjectRegistry.createUniversalUniqueId());
                localSheet.setTitle(remoteSheet.getTitle());
                this.localWorkbook.addSheet(localSheet);
                this.sheetMapping.put(localSheet.getId(), remoteSheet);
                JSONObject sheetsMapping = syncState.sheetsMapping;
                if (sheetsMapping == null) {
                    syncState.sheetsMapping = new JSONObject();
                }
                syncState.sheetsMapping.put(localSheet.getId(), (Object)remoteSheet.getId());
            }
            SeawindSyncer.this.syncConstraint.register(this.localWorkbook.getId(), syncState);
            localWorkingSet.addWorkbook(this.localWorkbook);
            SeawindSyncer.this.addPendingWorkbookToLocal(this.localWorkbook);
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SyncConstraint.SyncState syncStateOfConflictingFile;
            SyncConstraint.SyncState syncStateOfNewFileByConflict;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            String workbookId = this.remoteWorkbook.getId();
            IStorage workbookStorage = SeawindSyncer.ensureWorkbookStorage(this.localWorkbook);
            List localSheets = this.localWorkbook.getSheets();
            SubMonitor loopProgress = subMonitor.newChild(50).setWorkRemaining(localSheets.size() * 2);
            for (SeawindSheet localSheet : localSheets) {
                SeawindSheet remoteSheet = this.sheetMapping.get(localSheet.getId());
                Assert.isNotNull((Object)remoteSheet);
                String tempContentPath = "content.json";
                String tempPreviewPath = "preview.png";
                String tempThumbnailPath = "thumbnail.png";
                IStorage sheetStorage = SeawindSyncer.ensureSheetStorage(localSheet);
                new DownloadSheetContent(workbookId, remoteSheet, this.baseWorkbook.findSheet(remoteSheet.getId()), localSheet, tempContentPath, sheetStorage).run((IProgressMonitor)loopProgress.newChild(1));
                new DownloadSheetPreviewImage(workbookId, remoteSheet, tempPreviewPath, sheetStorage).run((IProgressMonitor)loopProgress.newChild(1));
                new DownloadSheetThumbnailImage(workbookId, remoteSheet, tempThumbnailPath, sheetStorage).run((IProgressMonitor)loopProgress.newChild(1));
                String contentHash = SeawindClient.getFileHash((IInputSource)sheetStorage.getInputSource(), (String)tempContentPath);
                String contentPath = EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash});
                String previewPath = EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash});
                sheetStorage.renameEntry(tempContentPath, contentPath);
                sheetStorage.renameEntry(tempPreviewPath, previewPath);
                sheetStorage.renameEntry(SeawindClient.toHashPath((String)tempContentPath), SeawindClient.toHashPath((String)contentPath));
                localSheet.setRevAsContentHash(contentHash);
            }
            if (this.remoteWorkbook.getExtensionsRev() != null) {
                String tempExtensionsPath = "extensions.json";
                new DownloadExtensions(workbookId, tempExtensionsPath, workbookStorage, this.remoteWorkbook.getExtensionsHash()).run((IProgressMonitor)loopProgress.newChild(1));
                String extensionsHash = SeawindClient.getFileHash((IInputSource)workbookStorage.getInputSource(), (String)tempExtensionsPath);
                String extensionsPath = EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
                workbookStorage.renameEntry(tempExtensionsPath, extensionsPath);
                workbookStorage.renameEntry(SeawindClient.toHashPath((String)tempExtensionsPath), SeawindClient.toHashPath((String)extensionsPath));
                this.localWorkbook.setExtensionsRevAsContentHash(extensionsHash);
            }
            if ((syncStateOfNewFileByConflict = SeawindSyncer.this.syncConstraint.getSyncState(this.localWorkbook.getId())) != null && syncStateOfNewFileByConflict.conflictSource != null) {
                syncStateOfNewFileByConflict.conflictSource = null;
                syncStateOfNewFileByConflict.sheetsMapping = null;
                if (syncStateOfNewFileByConflict.isNone()) {
                    SeawindSyncer.this.syncConstraint.unregister(this.localWorkbook.getId());
                }
            }
            if ((syncStateOfConflictingFile = SeawindSyncer.this.syncConstraint.getSyncState(this.remoteWorkbook.getId())) != null && syncStateOfConflictingFile.conflicting) {
                syncStateOfConflictingFile.conflicting = false;
                if (syncStateOfConflictingFile.isNone()) {
                    SeawindSyncer.this.syncConstraint.unregister(this.remoteWorkbook.getId());
                }
            }
            new AddWorkbookToRemote(this.localWorkbook, this.baseWorkingSet, this.remoteWorkingSet).run((IProgressMonitor)subMonitor.newChild(49));
        }

        @Override
        public boolean hasUploads() {
            return true;
        }
    }

    private static interface ISyncRunnable {
        public void run(IProgressMonitor var1) throws IOException, InterruptedException;

        public boolean hasUploads();

        default public boolean canExecute() {
            return true;
        }
    }

    private class LabelMonitor
    extends ProgressMonitorWrapper {
        private final String workbookId;
        private int total;
        private double progress;
        private String taskName;

        protected LabelMonitor(IProgressMonitor monitor, String workbookId) {
            super(monitor);
            this.workbookId = workbookId;
            this.total = 0;
            this.progress = 0.0;
            this.taskName = SeawindWorkbookRef.LABEL_SYNCING;
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.total = totalWork;
            if (name != null) {
                this.taskName = name;
                this.updateWorkbookSyncStatus();
            }
        }

        public void subTask(String name) {
            super.subTask(name);
            if (name != null) {
                this.taskName = name;
                this.updateWorkbookSyncStatus();
            }
        }

        public void internalWorked(double work) {
            super.internalWorked(work);
            this.progress += work;
            this.updateWorkbookSyncStatus();
        }

        public void worked(int work) {
            super.worked(work);
            this.progress += (double)work;
            this.updateWorkbookSyncStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateWorkbookSyncStatus() {
            SeawindWorkbookRef workbookRef;
            Object object = SeawindSyncer.this.library.getWorkingSetLock();
            synchronized (object) {
                workbookRef = SeawindSyncer.this.library.findWorkbookRefById(this.workbookId);
            }
            if (workbookRef == null) {
                return;
            }
            int prog = this.total == 0 ? 0 : (int)(this.progress * 10000.0 / (double)this.total);
            workbookRef.setSyncStatus(prog, this.taskName);
        }
    }

    private class ModifyRemoteSheet
    implements ISyncRunnable {
        private final SeawindWorkbook remoteWorkbook;
        private final SeawindSheet baseSheet;
        private final SeawindSheet localSheet;
        private final boolean titleChanged;
        private final String newContentHash;
        private final String baseRev;
        private final IStorage sheetStorage;
        private final SeawindWorkingSet localWorkingSet;
        private final SeawindWorkingSet baseWorkingSet;
        private final SeawindWorkingSet remoteWorkingSet;
        private final SyncRunner jobManager;

        public ModifyRemoteSheet(SeawindWorkbook remoteWorkbook, SeawindSheet localSheet, SeawindSheet baseSheet, boolean titleChanged, String newContentHash, String baseRev, IStorage sheetStorage, SeawindWorkingSet localWorkingSet, SeawindWorkingSet baseWorkingSet, SeawindWorkingSet remoteWorkingSet, SyncRunner jobManager, Set<String> conflictedWorkbookIds) {
            this.remoteWorkbook = remoteWorkbook;
            this.localSheet = localSheet;
            this.baseSheet = baseSheet;
            this.titleChanged = titleChanged;
            this.newContentHash = newContentHash;
            this.baseRev = baseRev;
            this.sheetStorage = sheetStorage;
            this.jobManager = jobManager;
            this.localWorkingSet = localWorkingSet;
            this.baseWorkingSet = baseWorkingSet;
            this.remoteWorkingSet = remoteWorkingSet;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            String newRev;
            JSONObject updates;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_UploadingSheetChanges_withSheetName, (Object)SeawindSyncer.getTitle((STitled)this.localSheet)));
            JSONObject changes = new JSONObject();
            if (this.titleChanged) {
                changes.put("title", (Object)this.localSheet.getTitle());
            }
            if (this.newContentHash != null && this.baseRev != null) {
                changes.put("rev", (Object)this.baseRev);
            }
            if (this.localSheet.getModificationTime() != this.baseSheet.getModificationTime()) {
                changes.put("modificationTime", this.localSheet.getModificationTime());
            }
            String contentPath = this.newContentHash == null ? null : EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{this.newContentHash});
            String previewPath = this.newContentHash == null ? null : EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{this.newContentHash});
            IInputSource source = this.sheetStorage.getInputSource();
            if (!(contentPath == null || source.hasEntry(contentPath) && source.isEntryAvailable(contentPath))) {
                throw new FileNotFoundException("Missing sheet content: " + contentPath);
            }
            StorageEntryEntity contentToUpload = this.newContentHash == null ? null : new StorageEntryEntity(source, contentPath);
            StorageEntryEntity previewImageToUpload = this.newContentHash == null || !source.hasEntry(previewPath) ? null : new StorageEntryEntity(source, previewPath);
            String workbookId = this.remoteWorkbook.getId();
            try {
                updates = SeawindSyncer.this.client.uploadSheet((IProgressMonitor)subMonitor.newChild(90), workbookId, this.baseSheet.getId(), changes, (HttpEntity)contentToUpload, (HttpEntity)previewImageToUpload);
            }
            catch (SeawindHttpException e) {
                if (e.getCode() == 403 && e.getSubCode() == 4301) {
                    throw new SeawindSyncException(SeawindMessages.SyncError_StorageFull, e);
                }
                if (e.getCode() == 409) {
                    String newRev2 = e.getAdditionalData().optString("rev", null);
                    if (newRev2 == null) {
                        throw e;
                    }
                    SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(workbookId);
                    if (syncStateOfConflicting != null && syncStateOfConflicting.conflicting) {
                        return;
                    }
                    this.jobManager.schedule(new HandleSheetConflicting(this.localWorkingSet, this.baseWorkingSet, this.remoteWorkingSet, this.remoteWorkbook), workbookId);
                    return;
                }
                throw e;
            }
            catch (SeawindClient.MissingFileException e) {
                throw new IOException(NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)), e);
            }
            if (this.titleChanged) {
                String newTitle = updates.has("title") ? updates.getString("title") : this.localSheet.getTitle();
                this.baseSheet.setTitle(newTitle);
                this.localSheet.setTitle(newTitle);
            }
            if ((newRev = updates.optString("rev")) != null) {
                if (this.newContentHash != null) {
                    SeawindSyncer.this.markSheetContentHash(this.sheetStorage, newRev, this.newContentHash);
                }
                this.baseSheet.setRev(newRev);
                this.localSheet.setRev(newRev);
            }
            if (updates.has("modificationTime")) {
                long newModificationTime = updates.getLong("modificationTime");
                this.baseSheet.setModificationTime(newModificationTime);
                this.localSheet.setModificationTime(newModificationTime);
            }
        }

        @Override
        public boolean hasUploads() {
            return true;
        }
    }

    private class ModifyRemoteWorkbook
    implements ISyncRunnable {
        private final SeawindWorkbook remoteWorkbook;
        private final SeawindWorkbook localWorkbook;
        private final SeawindWorkbook baseWorkbook;
        private JSONObject changes;
        private final String newExtensionsHash;
        private final String baseExtensionsRev;
        private final SeawindWorkingSet localWorkingSet;
        private final SeawindWorkingSet baseWorkingSet;
        private final SeawindWorkingSet remoteWorkingSet;
        private final SyncRunner jobManager;

        public ModifyRemoteWorkbook(JSONObject changes, SeawindWorkbook remoteWorkbook, SeawindWorkbook localWorkbook, SeawindWorkbook workbook, String newExtensionsHash, String baseExtensionsRev, SeawindWorkingSet localWorkingSet, SeawindWorkingSet baseWorkingSet, SeawindWorkingSet remoteWorkingSet, SyncRunner jobManager, Set<String> conflictedWorkbookIds) {
            this.changes = changes;
            this.remoteWorkbook = remoteWorkbook;
            this.localWorkbook = localWorkbook;
            this.baseWorkbook = workbook;
            this.newExtensionsHash = newExtensionsHash;
            this.baseExtensionsRev = baseExtensionsRev;
            this.localWorkingSet = localWorkingSet;
            this.baseWorkingSet = baseWorkingSet;
            this.remoteWorkingSet = remoteWorkingSet;
            this.jobManager = jobManager;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            JSONObject extensionsObject;
            JSONObject updates;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_UploadingWorkbookChanges_withWorkbookName, (Object)SeawindSyncer.getTitle((STitled)this.baseWorkbook)));
            if (this.changes == null) {
                this.changes = new JSONObject();
            }
            String extensionsPath = this.newExtensionsHash == null ? null : EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{this.newExtensionsHash});
            IStorage workbookStorage = this.localWorkbook.getStorage();
            IInputSource source = workbookStorage.getInputSource();
            if (!(extensionsPath == null || source.hasEntry(extensionsPath) && source.isEntryAvailable(extensionsPath))) {
                throw new FileNotFoundException("Missing workbook extensions: " + extensionsPath);
            }
            StorageEntryEntity extensionsEntity = this.newExtensionsHash != null && source.hasEntry(extensionsPath) ? new StorageEntryEntity(source, extensionsPath) : null;
            FieldSet files = null;
            if (extensionsEntity != null) {
                if (this.newExtensionsHash != null && this.baseExtensionsRev != null) {
                    JSONObject extensions = new JSONObject();
                    extensions.put("rev", (Object)this.baseExtensionsRev);
                    this.changes.put("extensions", (Object)extensions);
                }
                if (!"application/vnd.seawind.object+json".equals(extensionsEntity.getContentType())) {
                    extensionsEntity = new HttpEntityProxy((HttpEntity)extensionsEntity, "application/vnd.seawind.object+json");
                }
                files = new FieldSet();
                files.add("extensions.json", (Object)extensionsEntity);
            }
            String workbookId = this.localWorkbook.getId();
            try {
                updates = SeawindSyncer.this.client.uploadWorkbook((IProgressMonitor)subMonitor, this.localWorkbook.getId(), this.changes, files);
            }
            catch (SeawindHttpException e) {
                if (e.getCode() == 403 && e.getSubCode() == 4301) {
                    throw new SeawindSyncException(SeawindMessages.SyncError_StorageFull, e);
                }
                if (e.getCode() == 409) {
                    String newExtensionsRev = e.getAdditionalData().optString("rev", null);
                    if (newExtensionsRev == null) {
                        throw e;
                    }
                    SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(workbookId);
                    if (syncStateOfConflicting != null && syncStateOfConflicting.conflicting) {
                        return;
                    }
                    this.jobManager.schedule(new HandleSheetConflicting(this.localWorkingSet, this.baseWorkingSet, this.remoteWorkingSet, this.remoteWorkbook), workbookId);
                    return;
                }
                throw e;
            }
            catch (SeawindClient.MissingFileException e) {
                throw new IOException(NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)), e);
            }
            if (updates.has("title")) {
                this.baseWorkbook.setTitle(updates.getString("title"));
                this.localWorkbook.setTitle(updates.getString("title"));
            }
            if ((extensionsObject = updates.optJSONObject("extensions")) != null) {
                this.baseWorkbook.setExtensionsRev(extensionsObject.optString("rev"));
                this.localWorkbook.setExtensionsRev(extensionsObject.optString("rev"));
            }
            if (updates.has("sheetOrder")) {
                JSONArray sheetOrderArray = updates.getJSONArray("sheetOrder");
                ArrayList<String> sheetIds = new ArrayList<String>(sheetOrderArray.length());
                for (Object o : sheetOrderArray) {
                    if (!(o instanceof String)) continue;
                    sheetIds.add((String)o);
                }
                this.baseWorkbook.reorderSheets(sheetIds);
                this.localWorkbook.reorderSheets(sheetIds);
            }
        }

        @Override
        public boolean hasUploads() {
            return true;
        }
    }

    private class RemoveSheetFromRemote
    implements ISyncRunnable {
        private final SeawindWorkbook baseWorkbook;
        private final SeawindSheet baseSheet;

        public RemoveSheetFromRemote(SeawindWorkbook baseWorkbook, SeawindSheet baseSheet) {
            this.baseWorkbook = baseWorkbook;
            this.baseSheet = baseSheet;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_DeletingSheet_withSheetName, (Object)SeawindSyncer.getTitle((STitled)this.baseSheet)));
            SeawindSyncer.this.client.deleteSheet((IProgressMonitor)subMonitor, this.baseWorkbook.getId(), this.baseSheet.getId(), this.baseSheet.getRev());
            this.baseWorkbook.removeSheet(this.baseSheet);
        }

        @Override
        public boolean hasUploads() {
            return true;
        }
    }

    private class RemoveWorkbookFromRemote
    implements ISyncRunnable {
        private final SeawindWorkbook baseWorkbook;
        private final SeawindWorkingSet baseWorkingSet;

        public RemoveWorkbookFromRemote(SeawindWorkbook baseWorkbook, SeawindWorkingSet baseWorkingSet) {
            this.baseWorkbook = baseWorkbook;
            this.baseWorkingSet = baseWorkingSet;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)SeawindMessages.SyncStatus_DeletingWorkbook_withWorkbookName, (Object)SeawindSyncer.getTitle((STitled)this.baseWorkbook)));
            String workbookId = this.baseWorkbook.getId();
            SeawindSyncer.this.client.deleteWorkbook((IProgressMonitor)subMonitor, workbookId);
            this.baseWorkingSet.removeWorkbook(this.baseWorkbook);
        }

        @Override
        public boolean hasUploads() {
            return true;
        }
    }

    private class SyncRunner {
        private Map<String, Queue<ISyncRunnable>> jobs = new HashMap<String, Queue<ISyncRunnable>>();

        public void schedule(ISyncRunnable job, String workbookId) {
            Assert.isLegal((workbookId != null ? 1 : 0) != 0);
            Queue<ISyncRunnable> jobGroup = this.jobs.get(workbookId);
            if (jobGroup == null) {
                jobGroup = new LinkedBlockingQueue<ISyncRunnable>();
                this.jobs.put(workbookId, jobGroup);
            }
            jobGroup.add(job);
        }

        public boolean run(IProgressMonitor monitor) throws InterruptedException, IOException {
            String workbookId;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.jobs.size());
            boolean hasUploads = false;
            while ((workbookId = this.getNextGroupId()) != null) {
                ArrayList<Exception> exceptions = new ArrayList<Exception>();
                try {
                    ISyncRunnable job;
                    SyncConstraint.SyncState syncState;
                    Queue<ISyncRunnable> jobGroup = this.jobs.get(workbookId);
                    SubMonitor groupMonitor = SubMonitor.convert((IProgressMonitor)new LabelMonitor((IProgressMonitor)subMonitor.newChild(jobGroup.size()), workbookId), (int)jobGroup.size());
                    while (!((syncState = SeawindSyncer.this.syncConstraint.getSyncState(workbookId)) != null && syncState.conflicting || (job = jobGroup.poll()) == null)) {
                        if (job.canExecute()) {
                            try {
                                job.run((IProgressMonitor)groupMonitor.newChild(1));
                            }
                            catch (Exception e) {
                                if (e instanceof InterruptedException) {
                                    throw e;
                                }
                                exceptions.add(e);
                                continue;
                            }
                        }
                        boolean bl = hasUploads = hasUploads || job.hasUploads();
                        if (groupMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        groupMonitor.setWorkRemaining(jobGroup.size());
                    }
                    if (exceptions.size() == 0 && (syncState = SeawindSyncer.this.syncConstraint.getSyncState(workbookId)) != null && syncState.newFileDownloadUnfinished) {
                        syncState.newFileDownloadUnfinished = false;
                        if (syncState.isNone()) {
                            SeawindSyncer.this.syncConstraint.unregister(workbookId);
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    SeawindSyncer.this.handleWorkbookSyncException(workbookId, e);
                }
                if (exceptions.size() != 0) {
                    SeawindSyncer.this.handleWorkbookSyncException(workbookId, (Exception)exceptions.get(0));
                }
                exceptions.clear();
                exceptions = null;
                this.jobs.remove(workbookId);
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                subMonitor.setWorkRemaining(this.jobs.size());
            }
            return hasUploads;
        }

        private String getNextGroupId() {
            Iterator<String> it = this.jobs.keySet().iterator();
            return it.hasNext() ? it.next() : null;
        }

        public int size() {
            return this.jobs.size();
        }
    }

    private class SyncSession {
        private SyncRunner jobManager;
        private Set<String> conflictedWorkbookIds;
        private SeawindWorkingSet remoteWorkingSet;
        private SeawindWorkingSet baseWorkingSet;
        private SeawindWorkingSet localWorkingSet;
        private String workbookId;
        private SeawindWorkbook remoteWorkbook;
        private SeawindWorkbook baseWorkbook;
        private SeawindWorkbook localWorkbook;
        private String sheetId;
        private SeawindSheet remoteSheet;
        private SeawindSheet baseSheet;
        private SeawindSheet localSheet;
        private List<SeawindWorkbook> remoteWorkbooks;
        private List<SeawindWorkbook> baseWorkbooks;
        private List<SeawindWorkbook> localWorkbooks;
        private List<SeawindSheet> remoteSheets;
        private List<SeawindSheet> baseSheets;
        private List<SeawindSheet> localSheets;

        private SyncSession() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean exec(IProgressMonitor monitor) throws IOException, InterruptedException {
            boolean toChangeBaseFolders;
            JSONObject uploadFolderResult;
            boolean success;
            boolean toUploadFolders;
            SeawindFolderManager localSFM;
            SeawindWorkingSet localSnapshot;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.jobManager = new SyncRunner();
            this.conflictedWorkbookIds = new HashSet<String>();
            subMonitor.subTask(SeawindMessages.SyncStatus_FetchingWorkbookList);
            JSONObject userSettings = SeawindSyncer.this.client.downloadUserInfo((IProgressMonitor)subMonitor.newChild(10));
            SeawindSyncer.this.library.setCapacities(userSettings.getLong("capacity_max"), userSettings.getLong("capacity_used"));
            boolean active = userSettings.getBoolean("cloud_actived");
            if (!active) {
                throw new SeawindHttpException(new HttpException(null, 403, null, null), 4032, null, null, null);
            }
            SeawindSyncer.this.library.setActive(active);
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            JSONObject workbookListObject = SeawindSyncer.this.client.downloadWorkbookList((IProgressMonitor)subMonitor.newChild(5));
            this.remoteWorkingSet = new SeawindWorkingSet(workbookListObject);
            if (SeawindSyncer.this.logSnapshots) {
                System.out.println("[BEFORE SYNC] Remote: " + workbookListObject.toString(4));
            }
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            JSONObject folderList = SeawindSyncer.this.client.downloadFolderList((IProgressMonitor)subMonitor.newChild(5));
            SeawindFolderManager remoteSFM = new SeawindFolderManager(folderList);
            remoteSFM.init(this.remoteWorkingSet);
            if (SeawindSyncer.this.logSnapshots) {
                System.out.println("[BEFORE SYNC FOLDERS] Remote" + folderList.toString(4));
            }
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            subMonitor.subTask(SeawindMessages.SyncStatus_GatheringData);
            IStorage localStorage = SeawindSyncer.this.library.getWorkingSet().getStorage();
            this.baseWorkingSet = new SeawindWorkingSet(JSON.readOrCreateObjectWithDamageCheck((IStorage)localStorage, (String)"base.json"));
            this.baseWorkingSet.setDebugName("base working set");
            this.baseWorkingSet.setStorage(localStorage);
            this.baseWorkingSet.setPath("base.json");
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            Object object = SeawindSyncer.this.library.getWorkingSetLock();
            synchronized (object) {
                localSnapshot = new SeawindWorkingSet(SeawindSyncer.this.library.getWorkingSet().toJSON());
            }
            this.localWorkingSet = new SeawindWorkingSet(localSnapshot.toJSON());
            this.localWorkingSet.setDebugName("index working set");
            this.localWorkingSet.setStorage(localStorage);
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            IStorage folderStorage = SeawindSyncer.this.library.getSeawindFolderManager().getStorage();
            SeawindFolderManager baseSFM = new SeawindFolderManager(JSON.readOrCreateObjectWithDamageCheck((IStorage)folderStorage, (String)"folders_base.json"));
            baseSFM.setStorage(folderStorage);
            baseSFM.setPath("folders_base.json");
            baseSFM.init(this.baseWorkingSet);
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            if (SeawindSyncer.this.logSnapshots) {
                System.out.println("[BEFORE SYNC FOLDERS] Local: " + SeawindSyncer.this.library.getSeawindFolderManager().toString());
                System.out.println("[BEFORE SYNC FOLDERS] Base: " + baseSFM.toString());
            }
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            SeawindFolder syncedFolder = SeawindFolderManager.createRootFolder();
            Object object2 = SeawindSyncer.this.library.getSeawindFolderLock();
            synchronized (object2) {
                boolean toChangeLocalFolders;
                SeawindFolderManager sfm = SeawindSyncer.this.library.getSeawindFolderManager();
                localSFM = new SeawindFolderManager(sfm.getRootSeawindFolder().toJSON());
                localSFM.setStorage(folderStorage);
                localSFM.init(localSnapshot);
                SeawindFolderManager.mergeFolders(localSFM.getRootSeawindFolder(), baseSFM.getRootSeawindFolder(), remoteSFM.getRootSeawindFolder(), syncedFolder);
                boolean bl = toChangeLocalFolders = !syncedFolder.isSameWith((SPath)localSFM.getRootSeawindFolder());
                if (toChangeLocalFolders) {
                    localSFM.replaceRoot(syncedFolder);
                    sfm.replaceRoot(syncedFolder);
                    sfm.save((IProgressMonitor)subMonitor.newChild(1));
                }
            }
            SeawindSyncer.this.library.fireLibraryEvent(8, null);
            boolean bl = toUploadFolders = !syncedFolder.isSameWith((SPath)remoteSFM.getRootSeawindFolder());
            if (toUploadFolders && !(success = (uploadFolderResult = SeawindSyncer.this.client.uploadFolderList((IProgressMonitor)subMonitor.newChild(1), syncedFolder.toJSON())).optBoolean("result"))) {
                return false;
            }
            boolean bl2 = toChangeBaseFolders = !syncedFolder.isSameWith((SPath)baseSFM.getRootSeawindFolder());
            if (toChangeBaseFolders) {
                baseSFM.replaceRoot(syncedFolder);
                baseSFM.save((IProgressMonitor)subMonitor.newChild(1));
            }
            if (SeawindSyncer.this.logSnapshots) {
                System.out.println("[AFTER SYNC FOLDERS] Base: " + baseSFM.toString());
                System.out.println("[AFTER SYNC FOLDERS] Index: " + localSFM.toString());
                System.out.println("[AFTER SYNC FOLDERS] Local: " + SeawindSyncer.this.library.getSeawindFolderManager().toString());
            }
            boolean hasUploadsOrCovering = false;
            while (true) {
                boolean hasLocalChanges;
                ModalContext.checkCanceled((IProgressMonitor)subMonitor);
                if (SeawindSyncer.this.logSnapshots) {
                    System.out.println("[BEFORE SYNC] Local: " + SeawindSyncer.this.library.getWorkingSet().toString());
                    System.out.println("[BEFORE SYNC] Index: " + this.localWorkingSet.toString());
                    System.out.println("[BEFORE SYNC] Base:  " + this.baseWorkingSet.toString());
                }
                subMonitor.setWorkRemaining(77);
                this.syncWorkingSet();
                subMonitor.worked(5);
                ModalContext.checkCanceled((IProgressMonitor)subMonitor);
                SeawindSyncer.this.syncConstraint.save((IProgressMonitor)subMonitor.newChild(1));
                SeawindSyncer.this.library.getWorkingSet().save((IProgressMonitor)subMonitor.newChild(1));
                this.baseWorkingSet.save((IProgressMonitor)subMonitor.newChild(1));
                SeawindSyncer.this.library.setStatus(10);
                boolean covering = false;
                Set<String> workbookIds = SeawindSyncer.this.syncConstraint.getWorkbookIds();
                for (String workbookId : workbookIds) {
                    SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(workbookId);
                    if (syncState == null || !syncState.covering) continue;
                    covering = true;
                    syncState.covering = false;
                    if (!syncState.isNone()) continue;
                    SeawindSyncer.this.syncConstraint.unregister(this.remoteWorkbook.getId());
                }
                hasUploadsOrCovering = hasUploadsOrCovering || covering;
                boolean jobHasUploads = this.jobManager.run((IProgressMonitor)subMonitor.newChild(67));
                hasUploadsOrCovering = hasUploadsOrCovering || jobHasUploads;
                ModalContext.checkCanceled((IProgressMonitor)subMonitor);
                Object object3 = SeawindSyncer.this.library.getWorkingSetLock();
                synchronized (object3) {
                    SeawindWorkingSet newWorkingSet = SeawindSyncer.this.library.getWorkingSet();
                    hasLocalChanges = this.mergeLocalWorkingSet(newWorkingSet, localSnapshot, this.localWorkingSet);
                    localSnapshot = new SeawindWorkingSet(newWorkingSet.toJSON());
                    newWorkingSet.save((IProgressMonitor)subMonitor.newChild(1));
                }
                this.baseWorkingSet.save((IProgressMonitor)subMonitor.newChild(1));
                if (!hasLocalChanges) break;
                this.remoteWorkingSet = new SeawindWorkingSet(this.baseWorkingSet.toJSON());
            }
            if (SeawindSyncer.this.logSnapshots) {
                System.out.println("[AFTER SYNC] Local: " + SeawindSyncer.this.library.getWorkingSet().toString());
                System.out.println("[AFTER SYNC] Index: " + this.localWorkingSet.toString());
                System.out.println("[AFTER SYNC] Base:  " + this.baseWorkingSet.toString());
            }
            return hasUploadsOrCovering;
        }

        private boolean mergeLocalWorkingSet(SeawindWorkingSet newWorkingSet, SeawindWorkingSet oldWorkingSet, SeawindWorkingSet syncedWorkingSet) {
            String workbookId;
            boolean hasLocalChanges = false;
            ArrayList newWorkbooks = new ArrayList(newWorkingSet.getWorkbooks());
            ArrayList oldWorkbooks = new ArrayList(oldWorkingSet.getWorkbooks());
            ArrayList syncedWorkbooks = new ArrayList(syncedWorkingSet.getWorkbooks());
            int workbookIndex = 0;
            for (SeawindWorkbook newWorkbook : newWorkbooks) {
                String sheetId;
                boolean shouldUpdateModificationTime;
                workbookId = newWorkbook.getId();
                SeawindWorkbook oldWorkbook = oldWorkingSet.findWorkbook(workbookId);
                SeawindWorkbook syncedWorkbook = syncedWorkingSet.findWorkbook(workbookId);
                if (syncedWorkbook != null && syncedWorkbook.getStorage() == null) {
                    syncedWorkbook.setStorage(newWorkbook.getStorage());
                }
                if (oldWorkbook == null) {
                    hasLocalChanges = true;
                    if (syncedWorkbook == null) {
                        syncedWorkbook = new SeawindWorkbook(newWorkbook.toJSON());
                        syncedWorkingSet.addWorkbook(syncedWorkbook);
                        syncedWorkingSet.moveWorkbook(syncedWorkbook, workbookIndex);
                        SeawindSyncer.ensureWorkbookStorage(syncedWorkbook);
                    } else {
                        syncedWorkbooks.remove(syncedWorkbook);
                    }
                    ++workbookIndex;
                    continue;
                }
                oldWorkbooks.remove(oldWorkbook);
                if (syncedWorkbook == null) {
                    if (newWorkbook.isSameWith(oldWorkbook)) {
                        newWorkingSet.removeWorkbook(newWorkbook);
                        continue;
                    }
                    hasLocalChanges = true;
                    syncedWorkbook = new SeawindWorkbook(newWorkbook.toJSON());
                    syncedWorkingSet.addWorkbook(syncedWorkbook);
                    syncedWorkingSet.moveWorkbook(syncedWorkbook, workbookIndex);
                    SeawindSyncer.ensureWorkbookStorage(syncedWorkbook);
                } else {
                    syncedWorkbooks.remove(syncedWorkbook);
                }
                boolean bl = shouldUpdateModificationTime = newWorkbook.getModificationTime() == oldWorkbook.getModificationTime();
                if (!SeawindSyncer.objectEquals(newWorkbook.getTitle(), oldWorkbook.getTitle())) {
                    hasLocalChanges = true;
                    syncedWorkbook.setTitle(newWorkbook.getTitle());
                } else {
                    newWorkbook.setTitle(syncedWorkbook.getTitle());
                }
                if (!SeawindSyncer.objectEquals(newWorkbook.getExtensionsRev(), oldWorkbook.getExtensionsRev())) {
                    hasLocalChanges = true;
                    syncedWorkbook.setExtensionsRev(newWorkbook.getExtensionsRev());
                } else {
                    newWorkbook.setExtensionsRev(syncedWorkbook.getExtensionsRev());
                }
                ArrayList newSheets = new ArrayList(newWorkbook.getSheets());
                ArrayList oldSheets = new ArrayList(oldWorkbook.getSheets());
                ArrayList syncedSheets = new ArrayList(syncedWorkbook.getSheets());
                int sheetIndex = 0;
                for (SeawindSheet newSheet : newSheets) {
                    sheetId = newSheet.getId();
                    SeawindSheet oldSheet = oldWorkbook.findSheet(sheetId);
                    SeawindSheet syncedSheet = syncedWorkbook.findSheet(sheetId);
                    if (syncedSheet != null && syncedSheet.getStorage() == null) {
                        syncedSheet.setStorage(newSheet.getStorage());
                    }
                    if (oldSheet == null) {
                        hasLocalChanges = true;
                        if (syncedSheet == null) {
                            syncedSheet = new SeawindSheet(newSheet.toJSON());
                            syncedWorkbook.addSheet(syncedSheet);
                            syncedWorkbook.moveSheet(syncedSheet, sheetIndex);
                            SeawindSyncer.ensureSheetStorage(syncedSheet);
                        } else {
                            syncedSheets.remove(syncedSheet);
                        }
                        ++sheetIndex;
                        continue;
                    }
                    oldSheets.remove(oldSheet);
                    if (syncedSheet == null) {
                        if (newSheet.isSameWith(oldSheet)) {
                            newWorkbook.removeSheet(newSheet);
                            continue;
                        }
                        hasLocalChanges = true;
                        syncedSheet = new SeawindSheet(newSheet.toJSON());
                        syncedWorkbook.addSheet(syncedSheet);
                        syncedWorkbook.moveSheet(syncedSheet, sheetIndex);
                        SeawindSyncer.ensureSheetStorage(syncedSheet);
                    } else {
                        syncedSheets.remove(syncedSheet);
                    }
                    if (!SeawindSyncer.objectEquals(newSheet.getTitle(), oldSheet.getTitle())) {
                        hasLocalChanges = true;
                        syncedSheet.setTitle(newSheet.getTitle());
                    } else {
                        newSheet.setTitle(syncedSheet.getTitle());
                    }
                    SeawindSyncer.ensureSheetStorage(syncedSheet);
                    SeawindSyncer.this.ensureSheetContent(syncedSheet.getStorage(), syncedSheet.getRev());
                    if (!SeawindSyncer.objectEquals(newSheet.getRev(), oldSheet.getRev())) {
                        hasLocalChanges = true;
                        syncedSheet.setRev(newSheet.getRev());
                    } else {
                        newSheet.setRev(syncedSheet.getRev());
                    }
                    ++sheetIndex;
                }
                for (SeawindSheet oldSheet : oldSheets) {
                    hasLocalChanges = true;
                    sheetId = oldSheet.getId();
                    SeawindSheet syncedSheet = syncedWorkbook.findSheet(sheetId);
                    if (syncedSheet == null) continue;
                    syncedWorkbook.removeSheet(syncedSheet);
                    syncedSheets.remove(syncedSheet);
                }
                for (SeawindSheet syncedSheet : syncedSheets) {
                    SeawindSheet newSheet = new SeawindSheet(syncedSheet.toJSON());
                    newWorkbook.addSheet(newSheet);
                    SeawindSyncer.ensureSheetStorage(newSheet);
                }
                newWorkbook.reorderSheets(syncedWorkbook.getSheetOrder());
                if (shouldUpdateModificationTime) {
                    newWorkbook.setModificationTime(syncedWorkbook.getModificationTime());
                }
                ++workbookIndex;
            }
            for (SeawindWorkbook oldWorkbook : oldWorkbooks) {
                hasLocalChanges = true;
                workbookId = oldWorkbook.getId();
                SeawindWorkbook syncedWorkbook = syncedWorkingSet.findWorkbook(workbookId);
                if (syncedWorkbook == null) continue;
                syncedWorkingSet.removeWorkbook(syncedWorkbook);
                syncedWorkbooks.remove(syncedWorkbook);
            }
            for (SeawindWorkbook syncedWorkbook : syncedWorkbooks) {
                SeawindWorkbook newWorkbook = new SeawindWorkbook(syncedWorkbook.toJSON());
                newWorkingSet.addWorkbook(newWorkbook);
                SeawindSyncer.ensureWorkbookStorage(newWorkbook);
            }
            return hasLocalChanges;
        }

        private void syncWorkingSet() throws IOException {
            this.remoteWorkbooks = new ArrayList<SeawindWorkbook>(this.remoteWorkingSet.getWorkbooks());
            this.localWorkbooks = new ArrayList<SeawindWorkbook>(this.localWorkingSet.getWorkbooks());
            this.baseWorkbooks = new ArrayList<SeawindWorkbook>(this.baseWorkingSet.getWorkbooks());
            this.loopRemoteWorkbooks();
            this.loopBaseWorkbooks();
            this.loopLocalWorkbooks();
        }

        private void loopRemoteWorkbooks() throws IOException {
            int index = 0;
            for (SeawindWorkbook this.remoteWorkbook : this.remoteWorkbooks) {
                this.workbookId = this.remoteWorkbook.getId();
                this.localWorkbook = this.localWorkingSet.findWorkbook(this.workbookId);
                this.baseWorkbook = this.baseWorkingSet.findWorkbook(this.workbookId);
                if (this.localWorkbook == null) {
                    if (this.baseWorkbook != null) {
                        this.jobManager.schedule(new RemoveWorkbookFromRemote(this.baseWorkbook, this.baseWorkingSet), this.workbookId);
                        continue;
                    }
                    this.baseWorkbook = new SeawindWorkbook(this.remoteWorkbook.toJSON());
                    this.baseWorkingSet.addWorkbook(this.baseWorkbook);
                    this.baseWorkingSet.moveWorkbook(this.baseWorkbook, index);
                    this.localWorkbook = new SeawindWorkbook(this.remoteWorkbook.toJSON());
                    this.localWorkingSet.addWorkbook(this.localWorkbook);
                    this.localWorkingSet.moveWorkbook(this.localWorkbook, index);
                    SyncConstraint.SyncState syncState = new SyncConstraint.SyncState(new JSONObject());
                    syncState.newFileDownloadUnfinished = true;
                    SeawindSyncer.this.syncConstraint.register(this.localWorkbook.getId(), syncState);
                    SeawindSyncer.this.addPendingWorkbookToLocal(this.localWorkbook);
                    this.syncWorkbook();
                    ++index;
                    continue;
                }
                if (this.baseWorkbook == null) {
                    this.baseWorkbook = new SeawindWorkbook(this.remoteWorkbook.toJSON());
                    this.baseWorkingSet.addWorkbook(this.baseWorkbook);
                }
                this.baseWorkingSet.moveWorkbook(this.baseWorkbook, index);
                this.baseWorkbooks.remove(this.baseWorkbook);
                this.localWorkingSet.moveWorkbook(this.localWorkbook, index);
                this.localWorkbooks.remove(this.localWorkbook);
                SeawindSyncer.this.addPendingWorkbookToLocal(this.localWorkbook);
                this.syncWorkbook();
                ++index;
            }
        }

        private void loopBaseWorkbooks() {
            for (SeawindWorkbook baseWorkbook : this.baseWorkbooks) {
                SeawindWorkbook localWorkbook = this.localWorkingSet.findWorkbook(baseWorkbook.getId());
                if (localWorkbook == null) {
                    this.baseWorkingSet.removeWorkbook(baseWorkbook);
                    continue;
                }
                if (!localWorkbook.isSameWith(baseWorkbook)) {
                    SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(localWorkbook.getId());
                    if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) continue;
                    this.jobManager.schedule(new AddWorkbookToRemote(localWorkbook, this.baseWorkingSet, this.remoteWorkingSet), localWorkbook.getId());
                } else {
                    this.baseWorkingSet.removeWorkbook(baseWorkbook);
                    this.localWorkingSet.removeWorkbook(localWorkbook);
                }
                this.localWorkbooks.remove(localWorkbook);
            }
        }

        private void loopLocalWorkbooks() {
            for (SeawindWorkbook localWorkbook : this.localWorkbooks) {
                SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(localWorkbook.getId());
                if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) continue;
                this.jobManager.schedule(new AddWorkbookToRemote(localWorkbook, this.baseWorkingSet, this.remoteWorkingSet), localWorkbook.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncWorkbook() throws IOException {
            int jobCountAfterSync;
            SeawindSyncer.ensureWorkbookStorage(this.localWorkbook);
            SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            int jobCountBeforeSync = this.jobManager.size();
            boolean modificationTimeChanged = this.baseWorkbook.getModificationTime() != this.localWorkbook.getModificationTime();
            Set resourcesToUpload = SeawindSyncer.this.collectResourcesToUpload(this.localWorkbook);
            if (!resourcesToUpload.isEmpty()) {
                if (!SeawindSyncer.this.checkResourcesToUpload(resourcesToUpload)) {
                    Object object = SeawindSyncer.this.library.getWorkingSetLock();
                    synchronized (object) {
                        SeawindWorkbookRef workbookRef = SeawindSyncer.this.library.findWorkbookRefById(this.workbookId);
                        if (workbookRef != null) {
                            workbookRef.setSyncError(SeawindMessages.SyncError_LargeAttachment);
                        }
                    }
                    return;
                }
                this.jobManager.schedule(new UploadResources(resourcesToUpload, this.localWorkbook.getId()), this.workbookId);
            } else {
                SyncConstraint.SyncState syncStateForResourceUpload = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
                if (syncStateForResourceUpload != null && syncStateForResourceUpload.resourceUploadUnfinished) {
                    syncStateForResourceUpload.resourceUploadUnfinished = false;
                    if (syncStateForResourceUpload.isNone()) {
                        SeawindSyncer.this.syncConstraint.unregister(this.workbookId);
                    }
                }
            }
            syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            JSONObject updates = this.syncWorkbookMetaInfo();
            syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            this.remoteSheets = new ArrayList<SeawindSheet>(this.remoteWorkbook.getSheets());
            this.baseSheets = new ArrayList<SeawindSheet>(this.baseWorkbook.getSheets());
            this.localSheets = new ArrayList<SeawindSheet>(this.localWorkbook.getSheets());
            this.loopRemoteSheets();
            syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            this.loopBaseSheets();
            syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            this.loopLocalSheets();
            syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            if (updates == null || !updates.has("sheetOrder")) {
                List sheetOrder = this.remoteWorkbook.getSheetOrder();
                this.baseWorkbook.reorderSheets(sheetOrder);
                this.localWorkbook.reorderSheets(sheetOrder);
            }
            boolean hasSyncJobs = jobCountBeforeSync != (jobCountAfterSync = this.jobManager.size());
            FinishWorkbookSync finishSync = new FinishWorkbookSync(this.localWorkbook, this.baseWorkbook, !modificationTimeChanged || !hasSyncJobs ? this.remoteWorkbook.getModificationTime() : -1L);
            if (hasSyncJobs) {
                this.jobManager.schedule(new DownloadResourcesForWorkbook(this.localWorkbook), this.workbookId);
                this.jobManager.schedule(finishSync, this.workbookId);
                return;
            }
            Set resourcesToDownload = SeawindSyncer.this.collectResourcesToDownload(this.localWorkbook);
            if (!resourcesToDownload.isEmpty()) {
                SeawindSyncer.this.markWorkbookAsDownloading(this.workbookId);
                this.jobManager.schedule(new DownloadResources(resourcesToDownload, this.localWorkbook.getId()), this.workbookId);
                this.jobManager.schedule(finishSync, this.workbookId);
                return;
            }
            try {
                finishSync.run(null);
            }
            catch (InterruptedException interruptedException) {}
        }

        private JSONObject syncWorkbookMetaInfo() {
            boolean shouldUploadSheetOrder;
            boolean shouldUploadTitle;
            JSONObject changes = new JSONObject();
            boolean bl = shouldUploadTitle = !SeawindSyncer.objectEquals(this.baseWorkbook.getTitle(), this.localWorkbook.getTitle());
            if (shouldUploadTitle) {
                changes.put("title", (Object)this.localWorkbook.getTitle());
            }
            List newSheetOrder = this.localWorkbook.getSheetOrder();
            List baseSheetOrder = this.baseWorkbook.getSheetOrder();
            boolean bl2 = shouldUploadSheetOrder = !SeawindSyncer.objectEquals(baseSheetOrder, newSheetOrder);
            if (shouldUploadSheetOrder) {
                JSONArray sheetOrderArray = new JSONArray();
                for (String sheetId : newSheetOrder) {
                    sheetOrderArray.put((Object)sheetId);
                }
                changes.put("sheetOrder", (Object)sheetOrderArray);
            }
            SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            String changedExtensionsHash = this.localWorkbook.getExtensionsRevAsContentHash();
            String baseExtensionsRev = this.baseWorkbook.getExtensionsRev();
            if (changedExtensionsHash != null) {
                String remoteExtensionsRev = this.remoteWorkbook.getExtensionsRev();
                if (baseExtensionsRev != null && !baseExtensionsRev.equals(remoteExtensionsRev)) {
                    if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                        return changes;
                    }
                    if (SeawindSyncer.this.lastModifiedByCurrentClient(this.remoteWorkbook)) {
                        SeawindWorkbook baseWorkbook = this.baseWorkingSet.findWorkbook(this.remoteWorkbook.getId());
                        if (baseWorkbook != null) {
                            this.baseWorkingSet.removeWorkbook(baseWorkbook);
                        }
                        this.baseWorkingSet.addWorkbook(this.remoteWorkbook);
                        try {
                            this.baseWorkingSet.save(null);
                        }
                        catch (IOException | InterruptedException e) {
                            SeawindUIPlugin.log(e, e.getMessage());
                        }
                        SyncConstraint.SyncState syncState = new SyncConstraint.SyncState(new JSONObject());
                        syncState.covering = true;
                        SeawindSyncer.this.syncConstraint.register(this.localWorkbook.getId(), syncState);
                    } else {
                        this.jobManager.schedule(new HandleSheetConflicting(this.localWorkingSet, this.baseWorkingSet, this.remoteWorkingSet, this.remoteWorkbook), this.workbookId);
                    }
                }
            }
            if ((syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId)) != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return changes;
            }
            if (changes.length() > 0 || changedExtensionsHash != null) {
                this.jobManager.schedule(new ModifyRemoteWorkbook(changes, this.remoteWorkbook, this.localWorkbook, this.baseWorkbook, changedExtensionsHash, baseExtensionsRev, this.localWorkingSet, this.baseWorkingSet, this.remoteWorkingSet, this.jobManager, this.conflictedWorkbookIds), this.workbookId);
            }
            if (!shouldUploadTitle) {
                this.baseWorkbook.setTitle(this.remoteWorkbook.getTitle());
                this.localWorkbook.setTitle(this.remoteWorkbook.getTitle());
            }
            if (changedExtensionsHash == null && this.remoteWorkbook.getExtensionsRev() != null) {
                IStorage extensionsStorage = this.localWorkbook.getStorage();
                IInputSource extensionsSource = extensionsStorage.getInputSource();
                this.baseWorkbook.setExtensionsRev(this.remoteWorkbook.getExtensionsRev());
                this.localWorkbook.setExtensionsRev(this.remoteWorkbook.getExtensionsRev());
                String extensionsPath = EncodingUtils.format((String)"revs/%s/extensions.json", (Object[])new Object[]{this.localWorkbook.getExtensionsRev()});
                if (!extensionsSource.hasEntry(extensionsPath)) {
                    this.jobManager.schedule(new DownloadExtensions(this.workbookId, extensionsPath, extensionsStorage, this.remoteWorkbook.getExtensionsHash()), this.workbookId);
                }
            }
            return changes;
        }

        private void loopRemoteSheets() throws IOException {
            int index = 0;
            Iterator<SeawindSheet> remoteSheetIt = this.remoteSheets.iterator();
            while (remoteSheetIt.hasNext()) {
                SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
                if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                    return;
                }
                this.remoteSheet = remoteSheetIt.next();
                this.sheetId = this.remoteSheet.getId();
                this.localSheet = this.localWorkbook.findSheet(this.sheetId);
                this.baseSheet = this.baseWorkbook.findSheet(this.sheetId);
                if (this.localSheet == null) {
                    if (this.baseSheet != null) {
                        this.jobManager.schedule(new RemoveSheetFromRemote(this.baseWorkbook, this.baseSheet), this.workbookId);
                        continue;
                    }
                    this.baseSheet = new SeawindSheet(this.remoteSheet.toJSON());
                    this.baseWorkbook.addSheet(this.baseSheet);
                    this.baseWorkbook.moveSheet(this.baseSheet, index);
                    this.localSheet = new SeawindSheet(this.remoteSheet.toJSON());
                    this.localWorkbook.addSheet(this.localSheet);
                    this.localWorkbook.moveSheet(this.localSheet, index);
                    this.syncSheet();
                    ++index;
                    continue;
                }
                if (this.baseSheet == null) {
                    this.baseSheet = new SeawindSheet(this.remoteSheet.toJSON());
                    this.baseWorkbook.addSheet(this.baseSheet);
                    this.baseWorkbook.moveSheet(this.baseSheet, index);
                }
                this.baseWorkbook.moveSheet(this.baseSheet, index);
                this.baseSheets.remove(this.baseSheet);
                this.localWorkbook.moveSheet(this.localSheet, index);
                this.localSheets.remove(this.localSheet);
                this.syncSheet();
                ++index;
            }
        }

        private void loopBaseSheets() {
            for (SeawindSheet baseSheet : this.baseSheets) {
                SeawindSheet localSheet = this.localWorkbook.findSheet(baseSheet.getId());
                if (localSheet == null) {
                    this.baseWorkbook.removeSheet(baseSheet);
                    continue;
                }
                if (!localSheet.isSameWith(baseSheet)) {
                    this.jobManager.schedule(new AddSheetToRemote(localSheet, this.baseWorkbook), this.workbookId);
                } else {
                    this.localWorkbook.removeSheet(localSheet);
                }
                this.localSheets.remove(localSheet);
            }
        }

        private void loopLocalSheets() {
            for (SeawindSheet localSheet : this.localSheets) {
                this.jobManager.schedule(new AddSheetToRemote(localSheet, this.baseWorkbook), this.workbookId);
            }
        }

        private void syncSheet() throws IOException {
            boolean shouldUploadTitle;
            SeawindSyncer.ensureSheetStorage(this.localSheet);
            SyncConstraint.SyncState syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            String changedContentHash = this.localSheet.getRevAsContentHash();
            String baseRev = this.baseSheet.getRev();
            if (changedContentHash != null) {
                String remoteRev = this.remoteSheet.getRev();
                if (baseRev != null && !baseRev.equals(remoteRev)) {
                    if (SeawindSyncer.this.lastModifiedByCurrentClient(this.remoteWorkbook)) {
                        SeawindWorkbook baseWorkbook = this.baseWorkingSet.findWorkbook(this.remoteWorkbook.getId());
                        if (baseWorkbook != null) {
                            this.baseWorkingSet.removeWorkbook(baseWorkbook);
                        }
                        this.baseWorkingSet.addWorkbook(this.remoteWorkbook);
                        try {
                            this.baseWorkingSet.save(null);
                        }
                        catch (IOException | InterruptedException e) {
                            SeawindUIPlugin.log(e, e.getMessage());
                        }
                        SyncConstraint.SyncState syncState = new SyncConstraint.SyncState(new JSONObject());
                        syncState.covering = true;
                        SeawindSyncer.this.syncConstraint.register(this.localWorkbook.getId(), syncState);
                    } else {
                        if (syncStateOfConflicting != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                            return;
                        }
                        this.jobManager.schedule(new HandleSheetConflicting(this.localWorkingSet, this.baseWorkingSet, this.remoteWorkingSet, this.remoteWorkbook), this.workbookId);
                    }
                }
            }
            if ((syncStateOfConflicting = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId)) != null && (syncStateOfConflicting.conflicting || syncStateOfConflicting.covering)) {
                return;
            }
            boolean bl = shouldUploadTitle = !SeawindSyncer.objectEquals(this.baseSheet.getTitle(), this.localSheet.getTitle());
            if (shouldUploadTitle || changedContentHash != null) {
                this.jobManager.schedule(new ModifyRemoteSheet(this.remoteWorkbook, this.localSheet, this.baseSheet, shouldUploadTitle, changedContentHash, baseRev, this.localSheet.getStorage(), this.localWorkingSet, this.baseWorkingSet, this.remoteWorkingSet, this.jobManager, this.conflictedWorkbookIds), this.workbookId);
            }
            if (!shouldUploadTitle) {
                this.baseSheet.setTitle(this.remoteSheet.getTitle());
                this.localSheet.setTitle(this.remoteSheet.getTitle());
            }
            IStorage sheetStorage = this.localSheet.getStorage();
            IInputSource source = sheetStorage.getInputSource();
            if (changedContentHash == null) {
                String thumbnailPath;
                String previewPath;
                String contentPath = EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{this.remoteSheet.getRev()});
                if (!source.hasEntry(contentPath)) {
                    this.jobManager.schedule(new DownloadSheetContent(this.workbookId, this.remoteSheet, this.baseSheet, this.localSheet, contentPath, this.localSheet.getStorage()), this.workbookId);
                }
                if (!source.hasEntry(previewPath = EncodingUtils.format((String)"revs/%s/preview.png", (Object[])new Object[]{this.remoteSheet.getRev()}))) {
                    this.jobManager.schedule(new DownloadSheetPreviewImage(this.workbookId, this.localSheet, previewPath, this.localSheet.getStorage()), this.workbookId);
                }
                if (!source.hasEntry(thumbnailPath = EncodingUtils.format((String)"revs/%s/thumbnail.png", (Object[])new Object[]{this.remoteSheet.getRev()}))) {
                    this.jobManager.schedule(new DownloadSheetThumbnailImage(this.workbookId, this.localSheet, thumbnailPath, this.localSheet.getStorage()), this.workbookId);
                }
            }
        }
    }

    private class UploadResources
    implements ISyncRunnable {
        private final Set<String> resources;
        private String workbookId;

        public UploadResources(Set<String> resources, String workbookId) {
            this.resources = resources;
            this.workbookId = workbookId;
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(workbookId);
            if (syncState == null) {
                syncState = new SyncConstraint.SyncState(new JSONObject());
                SeawindSyncer.this.syncConstraint.register(workbookId, syncState);
            }
            syncState.newFileDownloadUnfinished = true;
        }

        @Override
        public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
            HashSet<String> hashes = new HashSet<String>();
            for (String hash : this.resources) {
                if (SeawindSyncer.this.library.isResourceUploaded(hash)) continue;
                hashes.add(hash);
            }
            monitor.subTask(SeawindMessages.SyncStatus_UploadingAttachments);
            try {
                SeawindSyncer.this.client.uploadResources(monitor, hashes, SeawindSyncer.this.library.getSharedResourceStorage().getInputSource());
            }
            catch (SeawindHttpException e) {
                if (e.getCode() == 403 && e.getSubCode() == 4301) {
                    throw new SeawindSyncException(SeawindMessages.SyncError_StorageFull, e);
                }
                throw e;
            }
            catch (SeawindClient.MissingFileException e) {
                throw new IOException(NLS.bind((String)SeawindMessages.SyncError_UnexpectedError_withErrorCode, (Object)SeawindErrorCodes.parse(e)), e);
            }
            SyncConstraint.SyncState syncState = SeawindSyncer.this.syncConstraint.getSyncState(this.workbookId);
            if (syncState != null && syncState.resourceUploadUnfinished) {
                syncState.resourceUploadUnfinished = false;
                if (syncState.isNone()) {
                    SeawindSyncer.this.syncConstraint.unregister(this.workbookId);
                }
            }
            for (String hash : hashes) {
                SeawindSyncer.this.library.setResourceUploaded(hash);
            }
        }

        @Override
        public boolean hasUploads() {
            return false;
        }
    }
}

