/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPointPairBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecisionLine
extends PrecisionPointPairBase
implements Cloneable,
Serializable {
    public static final double DEFAULT_TOLERANCE = 1.0E-4;
    private static final long serialVersionUID = 8018247328242867430L;
    private LineType lineType;
    private static final double BIGSLOPE = 999999.99999;

    public static boolean contains(PrecisionPoint origin, PrecisionPoint terminus, PrecisionPoint p, double tolerance) {
        return origin.getDistance(p) + p.getDistance(terminus) <= origin.getDistance(terminus) + tolerance;
    }

    public static double[] getLineEquation(double x1, double y1, double x2, double y2) {
        double[] equation = new double[3];
        int i = 0;
        while (i < 3) {
            equation[i] = 0.0;
            ++i;
        }
        if (x1 == x2 && y1 == y2) {
            return equation;
        }
        if (x1 == x2) {
            equation[0] = 1.0;
            equation[1] = 0.0;
            equation[2] = x1;
            return equation;
        }
        equation[0] = (y1 - y2) / (x2 - x1);
        equation[1] = 1.0;
        equation[2] = y2 + equation[0] * x2;
        return equation;
    }

    public PrecisionLine(PrecisionPoint origin, PrecisionPoint terminus) {
        this(origin, terminus, LineType.LineSegment);
    }

    public PrecisionLine(PrecisionPoint origin, PrecisionPoint terminus, LineType lineType) {
        super(origin, terminus);
        this.lineType = lineType;
    }

    public PrecisionLine(double x1, double y1, double x2, double y2) {
        this(x1, y1, x2, y2, LineType.LineSegment);
    }

    public PrecisionLine(double x1, double y1, double x2, double y2, LineType lineType) {
        super(x1, y1, x2, y2);
        this.lineType = lineType;
    }

    public boolean contains(PrecisionPoint p, double tolerance) {
        boolean b = PrecisionLine.contains(this.point1, this.point2, p, tolerance);
        if (this.lineType == LineType.Line || this.lineType == LineType.Ray) {
            b |= PrecisionLine.contains(this.point1, p, this.point2, tolerance);
            if (this.lineType == LineType.Line) {
                b |= PrecisionLine.contains(this.point2, p, this.point1, tolerance);
            }
        }
        return b;
    }

    public boolean contains(PrecisionPoint p) {
        return this.contains(p, 1.0E-4);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrecisionLine)) {
            return false;
        }
        PrecisionLine ls = (PrecisionLine)obj;
        return this.point1.equals(ls.point1) && this.point2.equals(ls.point2) && this.lineType == ls.lineType;
    }

    @Override
    public PrecisionLine getCopy() {
        return new PrecisionLine(this.point1, this.point2, this.lineType);
    }

    public double[] getEquation() {
        return PrecisionLine.getLineEquation(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
    }

    public List<PrecisionPoint> getLinesIntersections(PrecisionLine line) {
        ArrayList<PrecisionPoint> intersections = new ArrayList<PrecisionPoint>();
        double[] temp = this.getEquation();
        double a1 = temp[0];
        double b1 = temp[1];
        double c1 = temp[2];
        temp = line.getEquation();
        double a2 = temp[0];
        double b2 = temp[1];
        double c2 = temp[2];
        double det = a1 * b2 - b1 * a2;
        if (det == 0.0) {
            if (a1 == a2 && b1 == b2 && c1 == c2) {
                intersections.add(line.getOrigin().getCopy());
                intersections.add(line.getTerminus().getCopy());
            }
        } else {
            intersections.add(new PrecisionPoint((c1 * b2 - b1 * c2) / det, (a1 * c2 - c1 * a2) / det));
        }
        return intersections;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public PrecisionPoint getOrigin() {
        return this.point1;
    }

    public PrecisionPoint getTerminus() {
        return this.point2;
    }

    public PrecisionPoint intersect(PrecisionLine line) {
        return this.intersect(line, 1.0E-4);
    }

    public PrecisionPoint intersect(PrecisionLine line, double nTolerance) {
        List<PrecisionPoint> intersections = this.getLinesIntersections(line);
        if (intersections.size() > 1) {
            intersections.add(this.point1.getCopy());
            intersections.add(this.point2.getCopy());
        }
        int i = 0;
        while (i < intersections.size()) {
            PrecisionPoint result = intersections.get(i).getCopy();
            if (this.contains(result, nTolerance) && line.contains(result, nTolerance)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public double length() {
        return this.point1.getDistance(this.point2);
    }

    public void setLineType(LineType lineType) {
        this.lineType = lineType;
    }

    public void setOrigin(PrecisionPoint origin) {
        this.point1.setLocation(origin);
    }

    public void setTerminus(PrecisionPoint terminus) {
        this.point2.setLocation(terminus);
    }

    @Override
    public PrecisionLine swap() {
        return (PrecisionLine)super.swap();
    }

    public final double slope() {
        if (this.isVertical()) {
            return 999999.99999;
        }
        return (this.point2.y - this.point1.y) / (this.point2.x - this.point1.x);
    }

    public final boolean isVertical() {
        return this.point1.x == this.point2.x;
    }

    public double getAngle() {
        return this.getTerminus().getAngle(this.point1);
    }

    public double getRelativeAngle(PrecisionLine another) {
        return this.getAngle() - another.getAngle();
    }

    public Side getSide(PrecisionPoint p) {
        if (this.point1.equals(p) || this.point2.equals(p)) {
            return Side.OnLine;
        }
        double v = (p.x - this.point1.x) * (this.point2.y - this.point1.y) - (p.y - this.point1.y) * (this.point2.x - this.point1.x);
        if (Math.abs(v) < 1.0E-4) {
            return Side.OnLine;
        }
        return v > 0.0 ? Side.Left : Side.Right;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.lineType) + "[" + this.point1 + ", " + this.point2 + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineType {
        LineSegment,
        Ray,
        Line;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        Left,
        Right,
        OnLine;

    }
}

