/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.Arrays;
import java.util.Set;
import org.xmind.core.ICloneData;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.CreateSheetCommand;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.style.StyleUtils;

public class CreateSheetFromTopicCommandBuilder
extends CommandBuilder {
    private ITopic sourceTopic;

    public CreateSheetFromTopicCommandBuilder(IViewer viewer, ICommandStack commandStack, ITopic sourceTopic) {
        super(viewer, commandStack);
        this.sourceTopic = sourceTopic;
    }

    public void run() {
        Set sourceRelationships;
        IWorkbook workbook = this.sourceTopic.getOwnedWorkbook();
        CreateSheetCommand createCommand = new CreateSheetCommand(workbook, this.sourceTopic);
        this.add((Command)createCommand, true);
        ISheet newSheet = (ISheet)createCommand.getSource();
        if (newSheet == null) {
            return;
        }
        ITopic newCentralTopic = newSheet.getRootTopic();
        String newHyperlink = newCentralTopic.getHyperlink();
        if (newHyperlink == null) {
            this.add((Command)new ModifyTopicHyperlinkCommand(newCentralTopic, HyperlinkUtils.toInternalURL((Object)this.sourceTopic)), false);
        }
        this.add((Command)new ModifyTopicHyperlinkCommand(this.sourceTopic, HyperlinkUtils.toInternalURL((Object)newCentralTopic)), false);
        ISheet sourceSheet = this.sourceTopic.getOwnedSheet();
        if (sourceSheet != null) {
            IStyle theme;
            String themeId = sourceSheet.getThemeId();
            IStyle iStyle = theme = themeId == null ? null : sourceSheet.getOwnedWorkbook().getStyleSheet().findStyle(themeId);
            if (theme == null) {
                theme = MindMapUI.getResourceManager().getDefaultTheme();
            }
            StyleUtils.setTheme(newSheet, theme);
        }
        ICloneData cloneData = createCommand.getCloneData();
        newSheet.setTitleText(this.sourceTopic.getTitleText());
        String newStructure = this.newStructure(this.sourceTopic);
        if (newStructure != null) {
            newCentralTopic.setStructureClass(newStructure);
        }
        if ((sourceRelationships = sourceSheet.getRelationships()).size() > 0) {
            this.cloneRelationships(workbook, newSheet, cloneData, sourceRelationships);
        }
    }

    private void cloneRelationships(IWorkbook workbook, ISheet newSheet, ICloneData cloneData, Set<IRelationship> sourceRelationships) {
        for (IRelationship r : sourceRelationships) {
            this.cloneRelationship(workbook, newSheet, cloneData, r);
        }
    }

    private void cloneRelationship(IWorkbook workbook, ISheet newSheet, ICloneData cloneData, IRelationship sourceRelationship) {
        ICloneData cloned;
        IRelationship newRelationship;
        String target2Id;
        String source1Id = sourceRelationship.getEnd1Id();
        String source2Id = sourceRelationship.getEnd2Id();
        String target1Id = source1Id == null ? null : cloneData.getString("workbookComponents", source1Id);
        String string = target2Id = source2Id == null ? null : cloneData.getString("workbookComponents", source2Id);
        if (target1Id == null || target2Id == null) {
            return;
        }
        Object target1 = workbook.getElementById(target1Id);
        Object target2 = workbook.getElementById(target2Id);
        if (target1 instanceof IRelationshipEnd && target2 instanceof IRelationshipEnd && (newRelationship = (IRelationship)(cloned = WorkbookUtilsImpl.clone((IWorkbook)workbook, Arrays.asList(sourceRelationship), (ICloneData)cloneData)).get((Object)sourceRelationship)) != null) {
            newSheet.addRelationship(newRelationship);
        }
    }

    private String newStructure(ITopic topic) {
        String structure = topic.getStructureClass();
        if (structure != null) {
            if ("org.xmind.ui.map.floating".equals(structure)) {
                structure = "org.xmind.ui.map.unbalanced";
            } else if ("org.xmind.ui.map.floating.clockwise".equals(structure)) {
                structure = "org.xmind.ui.map.clockwise";
            } else if ("org.xmind.ui.map.floating.anticlockwise".equals(structure)) {
                structure = "org.xmind.ui.map.anticlockwise";
            }
        }
        return structure;
    }
}

