/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.List;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.internal.spreadsheet.structures.RowOrder;

public class ModifyRowOrderCommand
extends ModifyCommand {
    public ModifyRowOrderCommand(ITopic topic, RowOrder newRowOrder) {
        super((Object)topic, (Object)newRowOrder);
    }

    protected Object getValue(Object source) {
        if (source instanceof ITopic) {
            return RowOrder.createFromTopic((ITopic)source);
        }
        return null;
    }

    protected void setValue(Object source, Object value) {
        if (source instanceof ITopic) {
            ITopic topic = (ITopic)source;
            if (value == null || value instanceof RowOrder) {
                RowOrder order = (RowOrder)value;
                if (order == null || order.isEmpty()) {
                    this.deleteRowOrder(topic);
                } else {
                    this.setRowOrder(topic, order);
                }
            }
        }
    }

    private void deleteRowOrder(ITopic topic) {
        topic.deleteExtension("org.xmind.ui.spreadsheet");
        this.fireEvent(topic);
    }

    private void setRowOrder(ITopic topic, RowOrder order) {
        ITopicExtension extension = topic.createExtension("org.xmind.ui.spreadsheet");
        ITopicExtensionElement content = extension.getContent();
        List oldValues = content.getChildren("rows");
        Object[] objectArray = oldValues.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            content.deleteChild((IExtensionElement)((ITopicExtensionElement)o));
            ++n2;
        }
        ITopicExtensionElement rowsEle = (ITopicExtensionElement)content.createChild("rows");
        for (RowHead head : order.getHeads()) {
            ITopicExtensionElement row = (ITopicExtensionElement)rowsEle.createChild("row");
            row.setTextContent(head.toString());
        }
        this.fireEvent(topic);
    }

    private void fireEvent(ITopic topic) {
        if (topic instanceof ICoreEventSource) {
            ICoreEventSource source = (ICoreEventSource)topic;
            source.getCoreEventSupport().dispatchTargetChange(source, "org.xmind.ui.spreadsheet.coreEvent.modifyRowOrder", null);
        }
    }
}

