/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Properties;
import org.json.JSONObject;
import org.xmind.core.io.IStorage;
import org.xmind.seawind.internal.core.SElement;
import org.xmind.seawind.internal.core.SSerializable;
import org.xmind.seawind.internal.core.STitled;
import org.xmind.seawind.internal.core.SeawindWorkbook;

public class SeawindSheet
implements SElement<SeawindWorkbook>,
STitled,
SSerializable {
    public static final String PREFIX_HASH = "__HASH__";
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private String id;
    private String title;
    private String rev;
    private String hash;
    private long creationTime;
    private long modificationTime;
    private SeawindWorkbook parent = null;
    private IStorage storage = null;

    public SeawindSheet(String id) {
        this(new JSONObject().put("id", (Object)id));
    }

    public SeawindSheet(JSONObject json) {
        this.id = json.getString("id");
        this.title = json.optString("title", null);
        this.rev = json.optString("rev", null);
        this.hash = json.optString("hash", null);
        this.creationTime = json.has("creationTime") ? json.getLong("creationTime") : System.currentTimeMillis();
        this.modificationTime = json.has("modificationTime") ? json.getLong("modificationTime") : 0L;
    }

    private Properties captureProperties() {
        Properties properties = new Properties();
        if (this.title != null) {
            properties.put("title", this.title);
        }
        if (this.rev != null) {
            properties.put("rev", this.rev);
        }
        properties.put("modificationTime", (Object)this.modificationTime);
        return properties;
    }

    private void notifyPropertyChanges(Properties oldProperties, boolean updateModificationTime) {
        Properties newProperties = this.captureProperties();
        if (updateModificationTime && !newProperties.equals(oldProperties)) {
            this.modificationTime = System.currentTimeMillis();
            newProperties.put("modificationTime", (Object)this.modificationTime);
        }
        for (String propertyName : Arrays.asList("title", "rev", "modificationTime", "contentPath", "previewPath")) {
            this.propertySupport.firePropertyChange(propertyName, oldProperties.get(propertyName), newProperties.get(propertyName));
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject object = new JSONObject().put("id", (Object)this.id);
        if (this.title != null) {
            object.put("title", (Object)this.title);
        }
        if (this.rev != null) {
            object.put("rev", (Object)this.rev);
        }
        object.put("creationTime", this.creationTime);
        object.put("modificationTime", this.modificationTime);
        return object;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public void setModificationTime(long modificationTime) {
        Properties oldProperties = this.captureProperties();
        this.modificationTime = modificationTime;
        this.notifyPropertyChanges(oldProperties, false);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        Properties oldProperties = this.captureProperties();
        this.title = title;
        this.notifyPropertyChanges(oldProperties, true);
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        Properties oldProperties = this.captureProperties();
        this.rev = rev;
        this.notifyPropertyChanges(oldProperties, true);
    }

    public String getRevAsContentHash() {
        if (this.rev != null && this.rev.startsWith(PREFIX_HASH)) {
            return this.rev.substring(PREFIX_HASH.length());
        }
        return null;
    }

    public void setRevAsContentHash(String hash) {
        this.setRev(PREFIX_HASH + hash);
    }

    @Override
    public SeawindWorkbook getParent() {
        return this.parent;
    }

    public void setParent(SeawindWorkbook parent) {
        this.parent = parent;
    }

    public PropertyChangeSupport getPropertySupport() {
        return this.propertySupport;
    }

    public boolean isSameWith(SeawindSheet that) {
        if (!(this.id == that.id || this.id != null && this.id.equals(that.id))) {
            return false;
        }
        if (!(this.title == that.title || this.title != null && this.title.equals(that.title))) {
            return false;
        }
        return this.rev == that.rev || this.rev != null && this.rev.equals(that.rev);
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public String getHash() {
        return this.hash;
    }

    public String toString() {
        return this.toJSON().toString(4);
    }
}

