/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xmind.core.ILegend;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.marker.IMarker;
import org.xmind.core.plain.Sheet;
import org.xmind.core.util.Point;

public class Legend
implements ILegend,
ICoreEventSource {
    private final Sheet ownerSheet;
    private Point position;
    private boolean visible;
    private final Map<String, String> markerDescriptionMap;

    public Legend(Sheet ownerSheet) {
        this.ownerSheet = ownerSheet;
        this.position = null;
        this.visible = false;
        this.markerDescriptionMap = new HashMap<String, String>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        return null;
    }

    public ISheet getOwnedSheet() {
        return this.ownerSheet;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerSheet.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.ownerSheet.isOrphan();
    }

    public void setPosition(int x, int y) {
        Point newPosition = new Point(x, y);
        Point oldPosition = this.copyPosition(this.position);
        if (newPosition.equals((Object)oldPosition)) {
            return;
        }
        this.position = newPosition;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "position", (Object)oldPosition, (Object)newPosition);
    }

    private Point copyPosition(Point p) {
        return p == null ? null : new Point(p.x, p.y);
    }

    public Point getPosition() {
        return this.copyPosition(this.position);
    }

    public void setPosition(Point position) {
        Point newPosition;
        Point oldPosition = this.copyPosition(this.position);
        if (oldPosition == (newPosition = this.copyPosition(position)) || oldPosition != null && oldPosition.equals((Object)newPosition)) {
            return;
        }
        this.position = newPosition;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "position", (Object)oldPosition, (Object)newPosition);
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public boolean isEmpty() {
        return this.markerDescriptionMap.isEmpty();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        if (visible == oldVisible) {
            return;
        }
        this.visible = visible;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "visibility", (Object)oldVisible, (Object)visible);
    }

    public String getMarkerDescription(String markerId) {
        String description = this.markerDescriptionMap.get(markerId);
        if (description != null) {
            return description;
        }
        IMarker marker = this.getOwnedWorkbook().getMarkerSheet().findMarker(markerId);
        if (marker != null) {
            return marker.getName();
        }
        return "";
    }

    public void setMarkerDescription(String markerId, String description) {
        if (markerId == null) {
            throw new IllegalArgumentException();
        }
        String oldDescription = this.markerDescriptionMap.get(markerId);
        if (description == oldDescription || description != null && description.equals(oldDescription)) {
            return;
        }
        if (description == null) {
            this.markerDescriptionMap.remove(markerId);
        } else {
            this.markerDescriptionMap.put(markerId, description);
        }
        this.getCoreEventSupport().dispatchTargetValueChange((ICoreEventSource)this, "markerDescription", (Object)markerId, (Object)oldDescription, (Object)description);
    }

    public Set<String> getMarkerIds() {
        return this.markerDescriptionMap.keySet();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerSheet.getCoreEventSupport();
    }
}

