/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.net.IDataStore;

public class JSONStore
implements IDataStore {
    private JSONObject json;

    public JSONStore(JSONObject json) {
        this.json = json;
    }

    public JSONObject getJson() {
        return this.json;
    }

    @Override
    public boolean has(String key) {
        return this.json.has(key);
    }

    @Override
    public long getLong(String key) {
        return this.json.optLong(key, 0L);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.json.optBoolean(key, false);
    }

    @Override
    public int getInt(String key) {
        return this.json.optInt(key, 0);
    }

    @Override
    public double getDouble(String key) {
        return this.json.optDouble(key, 0.0);
    }

    @Override
    public String getString(String key) {
        Object o = this.json.opt(key);
        return o == null || JSONObject.NULL.equals(o) ? null : o.toString();
    }

    @Override
    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Iterator keys = this.json.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            map.put(key, this.json.opt((String)key));
        }
        return map;
    }

    @Override
    public List<IDataStore> getChildren(String key) {
        JSONArray array = this.json.optJSONArray(key);
        if (array != null) {
            ArrayList<IDataStore> children = new ArrayList<IDataStore>(array.length());
            int i = 0;
            while (i < array.length()) {
                JSONObject child = array.optJSONObject(i);
                children.add(new JSONStore(child));
                ++i;
            }
            return children;
        }
        return EMPTY.getChildren(key);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof JSONStore)) {
            return false;
        }
        JSONStore that = (JSONStore)obj;
        return this.json.equals(that.json);
    }

    public int hashCode() {
        return this.json.hashCode();
    }

    public String toString() {
        return this.json.toString();
    }
}

