/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.ui.gantt2.gefext.AbstractTracker;
import org.xmind.ui.gantt2.gefext.GraphicalEditPart;
import org.xmind.ui.gantt2.gefext.ITracker;
import org.xmind.ui.gantt2.viewer.DateRange;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.IHasOffset;
import org.xmind.ui.gantt2.viewer.IHasOffset2;
import org.xmind.ui.gantt2.viewer.OffsetFigure;
import org.xmind.ui.gantt2.viewer.TimelineModel;

public class TimelinePart
extends GraphicalEditPart
implements PropertyChangeListener {
    private static final Rectangle AREA = new Rectangle();
    private static final Rectangle RECT = new Rectangle();
    private ITracker scrollTracker = null;
    private Calendar cachedStartDate = null;

    public TimelinePart(Object model) {
        this.setModel(model);
        this.setFigure(this.createFigure());
    }

    private RangeModel getRangeModel() {
        return ((IGraphicalViewer)this.getModel()).getCanvas().getViewport().getHorizontalRangeModel();
    }

    protected IFigure createFigure() {
        OffsetFigure layer = new OffsetFigure();
        layer.setLayoutManager((LayoutManager)new TimelineLayout());
        layer.setCursor(Cursors.HAND);
        layer.setMinimumSize(new Dimension());
        return layer;
    }

    public TimelineModel getTimeline() {
        return ((GanttEditDomain)this.getSite().getDomain()).getTimelineModel();
    }

    public IPart findAt(Point position) {
        return this;
    }

    protected void updateView(Object property) {
        super.updateView(property);
        ((IHasOffset2)this.getFigure()).setOffsetValue(-this.getRangeModel().getValue());
    }

    /*
     * Unable to fully structure code
     */
    protected Object[] getModelChildren(Object model) {
        block9: {
            timeline = this.getTimeline();
            origin = timeline.getOriginDate();
            if (timeline.getPrecision() == 3323.0) {
                origin2 = Calendar.getInstance();
                origin2.setTimeInMillis(origin.getTimeInMillis());
                origin2.set(7, origin2.getFirstDayOfWeek());
                origin = origin2;
            }
            rangeModel = this.getRangeModel();
            minModel = rangeModel.getValue();
            maxModel = minModel + rangeModel.getExtent();
            section = this.getSectionField(timeline);
            this.cachedStartDate = origin;
            min = timeline.getPixelsFromMillis(this.cachedStartDate.getTimeInMillis() - origin.getTimeInMillis());
            start = this.cachedStartDate;
            if (minModel < min) {
                while (timeline.getPixelsFromMillis((start = DateRange.rollDate(start, section[0], -section[1])).getTimeInMillis() - origin.getTimeInMillis()) > minModel) {
                }
            } else if (minModel > min) {
                nextStart = DateRange.rollDate(start, section[0], section[1]);
                while (timeline.getPixelsFromMillis(nextStart.getTimeInMillis() - origin.getTimeInMillis()) < minModel) {
                    start = nextStart;
                    nextStart = DateRange.rollDate(start, section[0], section[1]);
                }
            }
            this.cachedStartDate = start;
            dateRanges = new ArrayList<DateRange>();
            rangeNext = null;
            origin = this.getTimeline().getOriginDate();
            max = timeline.getPixelsFromMillis(start.getTimeInMillis() - origin.getTimeInMillis());
            if (timeline.getPrecision() != 15120.0) ** GOTO lbl50
            count = 0;
            while (max < maxModel) {
                rangeNext = DateRange.rangeStartedFrom(rangeNext == null ? start : rangeNext.end, section[0], section[1]);
                rangeNext1 = new DateRange(DateRange.copyDate(rangeNext.start), DateRange.copyDate(rangeNext.end));
                end = rangeNext1.end;
                end.add(3, 1);
                end.set(7, end.getFirstDayOfWeek());
                if (count == 0) {
                    rangeNext1.setFirst(true);
                }
                dateRanges.add(rangeNext1);
                max = timeline.getPixelsFromMillis(rangeNext.end.getTimeInMillis() - origin.getTimeInMillis());
                ++count;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                rangeNext = DateRange.rangeStartedFrom(rangeNext == null ? start : rangeNext.end, section[0], section[1]);
                dateRanges.add(rangeNext);
                max = timeline.getPixelsFromMillis(rangeNext.end.getTimeInMillis() - origin.getTimeInMillis());
lbl50:
                // 2 sources

                ** while (max < maxModel)
            }
        }
        return dateRanges.toArray();
    }

    private int[] getSectionField(TimelineModel timeline) {
        double p = timeline.getPrecision();
        if (p <= 0.08333333333333333) {
            return new int[]{12, 1};
        }
        if (p <= 5.0) {
            return new int[]{10, 1};
        }
        if (p <= 144.0) {
            return new int[]{5, 1};
        }
        if (p <= 3323.0) {
            return new int[]{4, 1};
        }
        if (p <= 3456.0) {
            return new int[]{2, 1};
        }
        if (p <= 15120.0) {
            return new int[]{2, 1};
        }
        return new int[]{1, 1};
    }

    protected void installModelListeners() {
        super.installModelListeners();
        this.getRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
        this.getTimeline().getPropertyChangeSupport().addPropertyChangeListener("precision", this);
    }

    protected void uninstallModelListeners() {
        this.getRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
        this.getTimeline().getPropertyChangeSupport().removePropertyChangeListener("precision", this);
        super.uninstallModelListeners();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public ITracker findTracker(Point cursorLocation) {
        if (this.scrollTracker == null) {
            this.scrollTracker = new ScrollTracker();
        }
        return this.scrollTracker;
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
    }

    private class ScrollTracker
    extends AbstractTracker {
        private int startingValue;

        private ScrollTracker() {
        }

        public boolean handleMouseDown(MouseEvent me, IViewer viewer) {
            this.startingValue = TimelinePart.this.getRangeModel().getValue();
            return true;
        }

        public boolean handleMouseDrag(MouseDragEvent me, IViewer viewer) {
            int delta = me.getSWTDisplacement().width;
            TimelinePart.this.getRangeModel().setValue(this.startingValue - delta);
            return true;
        }
    }

    private class TimelineLayout
    extends AbstractLayout {
        private TimelineLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return new Dimension();
        }

        public void layout(IFigure container) {
            int offset = ((IHasOffset)container).getOffset();
            Rectangle clientArea = container.getClientArea(AREA);
            List children = container.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (child instanceof IHasOffset) {
                    Dimension childSize = child.getPreferredSize();
                    Rectangle r = RECT;
                    r.x = offset + ((IHasOffset)child).getOffset();
                    r.y = clientArea.y;
                    r.width = childSize.width;
                    r.height = childSize.height;
                    child.setBounds(r);
                }
                ++i;
            }
        }
    }
}

