/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderIdeaGroupsCommand
extends SourceCommand {
    private ITopic rootTopic;
    private List<ITopicExtensionElement> groupElements;
    private ITopicExtensionElement parent;
    private List<ITopicExtensionElement> oldGroupElements;

    public ReorderIdeaGroupsCommand(ITopic rootTopic, List<ITopicExtensionElement> groupElements) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.groupElements = new ArrayList<ITopicExtensionElement>(groupElements);
        this.setLabel(IdeaFactoryMessages.ReorderIdeaGroupsCommand_Reorder_Idea_Group);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        if (this.parent == null) {
            ITopicExtension ext = this.rootTopic.createExtension("org.xmind.ui.ideafactory");
            ITopicExtensionElement content = ext.getContent();
            this.parent = (ITopicExtensionElement)content.getCreatedChild("groups");
        }
        if (this.oldGroupElements == null) {
            this.oldGroupElements = this.parent.getChildren("group");
        }
        this.parent.deleteChildren();
        for (ITopicExtensionElement groupElement : this.groupElements) {
            this.parent.addChild((IExtensionElement)groupElement, -1);
        }
        this.fireCoreEvent(this.rootTopic, "ideaGroupReorder");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.parent.deleteChildren();
        for (ITopicExtensionElement groupElement : this.oldGroupElements) {
            this.parent.addChild((IExtensionElement)groupElement, -1);
        }
        this.fireCoreEvent(this.rootTopic, "ideaGroupReorder");
        super.undo();
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchTargetChange((ICoreEventSource)topic, eventType, (Object)this.parent);
        }
    }
}

