/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.datepicker.ArrowFigure;
import org.xmind.ui.datepicker.BaseFigure;
import org.xmind.ui.datepicker.CalendarAnimation;
import org.xmind.ui.datepicker.ConstraintStackLayout;
import org.xmind.ui.datepicker.DateLabelProvider;
import org.xmind.ui.datepicker.DatePanelLayout;
import org.xmind.ui.datepicker.DateSelection;
import org.xmind.ui.datepicker.DayFigure;
import org.xmind.ui.datepicker.HorizontalLine;
import org.xmind.ui.datepicker.IAnimationAdvisor;
import org.xmind.ui.datepicker.LastMonthAnimation;
import org.xmind.ui.datepicker.LastYearAnimation;
import org.xmind.ui.datepicker.Messages;
import org.xmind.ui.datepicker.MonthFigure;
import org.xmind.ui.datepicker.NextMonthAnimation;
import org.xmind.ui.datepicker.NextYearAnimation;
import org.xmind.ui.datepicker.TextLayer;
import org.xmind.ui.datepicker.YearFigure;
import org.xmind.ui.dialogs.PopupDialog;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.SWTUtils;

public class DatePicker2
extends Viewer {
    private static final String[] MONTHS = new String[]{Messages.January, Messages.Feburary, Messages.March, Messages.April, Messages.May, Messages.June, Messages.July, Messages.August, Messages.September, Messages.October, Messages.November, Messages.December};
    private static final String[] WEEK_SYMBOLS = new String[]{Messages.Sunday, Messages.Monday, Messages.Tuesday, Messages.Wednesday, Messages.Thursday, Messages.Friday, Messages.Saturday};
    private static final int FUTURE_YEARS = 7;
    private static final int PASSED_YEARS = 3;
    private static final String COLOR_TEXT = "#000000";
    private static final String COLOR_WEEKEND = "#EE0000";
    private static final String COLOR_SEPARATOR = "#C0C0C0";
    private static final String COLOR_TODAY = "#ff9900";
    private static final String COLOR_WEEK_SYMBOL = "#808080";
    private static final String COLOR_ARROW_BORDER = "#808080";
    private static final String COLOR_ARROW_FILL = "#C0C0C0";
    private static final String COLOR_CANCEL = "#D80000";
    private static final int NORMAL_ALPHA = 255;
    private static final int SIBLING_MONTH_ALPHA = 32;
    private static final int DURATION = 200;
    private static final int TOTAL_DAYS = 42;
    private static Color validColor = ColorUtils.getColor((String)"#ffffff");
    private static Color invalidColor = ColorUtils.getColor((String)"#f0f0f0");
    private int style;
    private Control control;
    private FigureCanvas datePicker;
    private Composite placeholder;
    private Text yearText;
    private Text monthText;
    private Text dayText;
    private Button showDatePickerButton;
    private Label slash1;
    private Label slash2;
    private ILabelProvider dateLabelProvider;
    private DropdownDatePicker dropdownDatePicker;
    private Calendar today;
    private int currentMonth;
    private int currentYear;
    private Calendar selection;
    private IFigure dateLayer;
    private IFigure datePanel;
    private MonthFigure monthFigure;
    private YearFigure yearFigure;
    private BaseFigure todayFigure;
    private BaseFigure cancelFigure;
    private EventHandler eventHandler;
    private MenuManager monthMenu;
    private MonthAction[] monthActions;
    private MenuManager yearMenu;
    private YearAction[] yearActions;
    private ArrowFigure lastYear;
    private ArrowFigure nextYear;
    private ArrowFigure lastMonth;
    private ArrowFigure nextMonth;
    private boolean firingSelectionChange = false;
    private boolean animating = false;
    private IAnimationAdvisor animationAdvisor = new AnimationAdvisor();
    private String oldValue = "";
    private Calendar minTime;
    private Calendar maxTime;

    public DatePicker2(Composite parent, int style) {
        this(parent, style, Calendar.getInstance());
    }

    public DatePicker2(Composite parent, int style, Calendar today) {
        this.today = today;
        this.currentMonth = today.get(2);
        this.currentYear = today.get(1);
        this.style = style;
        if ((style & 4) != 0) {
            this.createPlaceholder(parent);
            this.control = this.placeholder;
            this.initPlaceholder();
        } else {
            this.createDatePicker(parent);
            this.control = this.datePicker;
            this.initDatePicker();
        }
        this.update();
    }

    private void createPlaceholder(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(6, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setBackground(validColor);
        this.dayText = new Text(composite, 4);
        org.eclipse.swt.layout.GridData dateData = new org.eclipse.swt.layout.GridData(131072, 0x1000000, false, false);
        this.dayText.setLayoutData((Object)dateData);
        this.dayText.setTextLimit(2);
        this.dayText.setBackground(this.dayText.getParent().getBackground());
        this.slash1 = new Label(composite, 0);
        this.slash1.setLayoutData((Object)new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false));
        this.slash1.setBackground(this.slash1.getParent().getBackground());
        this.slash1.setText("/");
        this.monthText = new Text(composite, 4);
        org.eclipse.swt.layout.GridData monthData = new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false);
        this.monthText.setLayoutData((Object)monthData);
        this.monthText.setTextLimit(2);
        this.monthText.setBackground(this.monthText.getParent().getBackground());
        this.slash2 = new Label(composite, 0);
        this.slash2.setLayoutData((Object)new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false));
        this.slash2.setBackground(this.slash2.getParent().getBackground());
        this.slash2.setText("/");
        this.yearText = new Text(composite, 4);
        org.eclipse.swt.layout.GridData yearData = new org.eclipse.swt.layout.GridData(16384, 0x1000000, false, false);
        this.yearText.setLayoutData((Object)yearData);
        this.yearText.setTextLimit(4);
        this.yearText.setBackground(this.yearText.getParent().getBackground());
        this.showDatePickerButton = new Button(composite, 1028);
        this.showDatePickerButton.setLayoutData((Object)new org.eclipse.swt.layout.GridData(16384, 0x1000000, false, false));
        this.filterInput();
        this.placeholder = composite;
    }

    private void filterInput() {
        this.checkInput(this.dayText);
        this.checkInput(this.monthText);
        this.checkInput(this.yearText);
    }

    private void checkInput(final Text field) {
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\u001b': {
                        field.setText(DatePicker2.this.oldValue);
                        field.getParent().forceFocus();
                        break;
                    }
                    case '\r': {
                        field.getParent().forceFocus();
                    }
                }
            }
        };
        FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                DatePicker2.this.editField(field, DatePicker2.this.oldValue);
                DatePicker2.this.oldValue = "";
            }

            public void focusGained(FocusEvent e) {
                DatePicker2.this.oldValue = field.getText();
                field.selectAll();
            }
        };
        field.addKeyListener((KeyListener)keyListener);
        field.addFocusListener(focusListener);
    }

    private void editField(Text field, String oldValue) {
        int calendarField;
        String text = field.getText();
        if (text.equals(oldValue)) {
            return;
        }
        if ("".equals(text)) {
            field.setText(oldValue);
            return;
        }
        int value = 0;
        text = text.trim();
        Pattern re = Pattern.compile("^\\d+$");
        Matcher m = re.matcher(text);
        if (!m.matches()) {
            field.setText(oldValue);
            return;
        }
        value = this.parseInt(m.group());
        int n = field == this.yearText ? 1 : (calendarField = field == this.monthText ? 2 : 5);
        if (calendarField == 2) {
            --value;
        }
        Calendar newTime = Calendar.getInstance();
        newTime.setTimeInMillis(this.getSelectedDate().getTimeInMillis());
        newTime.set(calendarField, value);
        newTime = this.checkTime(newTime);
        this.changeDate(newTime);
        this.refresh();
    }

    private int parseInt(String s) {
        if (s != null && !"".equals(s)) {
            try {
                return Integer.parseInt(s, 10);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    private Calendar checkTime(Calendar newTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(newTime.getTimeInMillis());
        if (calendar.before(this.minTime)) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.TimeCheckInvalid_label, (String)Messages.TimeCheckInvalidSmall_message);
            calendar.setTimeInMillis(this.minTime.getTimeInMillis());
        } else if (calendar.after(this.maxTime)) {
            MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.TimeCheckInvalid_label, (String)Messages.TimeCheckInvalidBig_message);
            calendar.setTimeInMillis(this.maxTime.getTimeInMillis());
        }
        return calendar;
    }

    private void createDatePicker(Composite parent) {
        this.datePicker = new FigureCanvas(parent);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.dateLabelProvider = labelProvider;
        this.update();
    }

    public ILabelProvider getLabelProvider() {
        if (this.dateLabelProvider == null) {
            this.dateLabelProvider = new DateLabelProvider();
        }
        return this.dateLabelProvider;
    }

    public Control getControl() {
        return this.control;
    }

    public FigureCanvas getDatePicker() {
        return this.datePicker;
    }

    public void setBackground(Color color) {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBackground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.placeholder != null) {
            this.placeholder.setEnabled(enabled);
            this.placeholder.setBackground(enabled ? validColor : invalidColor);
            this.yearText.setEnabled(enabled);
            this.yearText.setBackground(enabled ? validColor : invalidColor);
            this.monthText.setEnabled(enabled);
            this.monthText.setBackground(enabled ? validColor : invalidColor);
            this.dayText.setEnabled(enabled);
            this.dayText.setBackground(enabled ? validColor : invalidColor);
            this.slash1.setEnabled(enabled);
            this.slash1.setBackground(enabled ? validColor : invalidColor);
            this.slash2.setEnabled(enabled);
            this.slash2.setBackground(enabled ? validColor : invalidColor);
            this.showDatePickerButton.setEnabled(enabled);
        }
    }

    public Composite getPlaceholder() {
        return this.placeholder;
    }

    public ISelection getSelection() {
        return new DateSelection(this.selection);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        Object sel;
        if (selection instanceof DateSelection) {
            this.setDateSelection(((DateSelection)selection).getDate(), reveal);
        } else if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof Calendar) {
            this.setDateSelection((Calendar)sel, reveal);
        }
    }

    public void setDateSelection(Calendar date, boolean reveal) {
        this.changeDate(date);
        if (reveal && date != null) {
            this.changeCalendar(date.get(1), date.get(2));
        }
        this.update();
    }

    private void initPlaceholder() {
        this.showDatePickerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatePicker2.this.dropdownDatePicker == null || DatePicker2.this.dropdownDatePicker.getShell() == null || DatePicker2.this.dropdownDatePicker.getShell().isDisposed() || !DatePicker2.this.dropdownDatePicker.isClosing()) {
                    DatePicker2.this.showDropdown();
                }
            }
        });
    }

    private void showDropdown() {
        this.placeholder.forceFocus();
        this.createDropdownDatePicker();
        this.dropdownDatePicker.open();
        Shell shell = this.dropdownDatePicker.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    if (DatePicker2.this.placeholder != null && !DatePicker2.this.placeholder.isDisposed()) {
                        DatePicker2.this.placeholder.forceFocus();
                    }
                }
            });
        }
    }

    public void open() {
        this.showDropdown();
    }

    private void createDropdownDatePicker() {
        if (this.dropdownDatePicker != null) {
            return;
        }
        this.dropdownDatePicker = new DropdownDatePicker(this.control.getShell());
    }

    private void initDatePicker() {
        this.datePicker.setScrollBarVisibility(FigureCanvas.NEVER);
        this.eventHandler = new EventHandler();
        this.eventHandler.install((Control)this.datePicker);
        this.datePicker.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DatePicker2.this.eventHandler.uninstall((Control)DatePicker2.this.datePicker);
            }
        });
        Viewport viewport = new Viewport(true);
        viewport.setContentsTracksHeight(true);
        viewport.setContentsTracksWidth(true);
        this.datePicker.setViewport(viewport);
        Layer container = new Layer();
        this.datePicker.setContents((IFigure)container);
        org.eclipse.draw2d.GridLayout containerLayout = new org.eclipse.draw2d.GridLayout(1, true);
        containerLayout.horizontalSpacing = 3;
        containerLayout.verticalSpacing = 3;
        containerLayout.marginHeight = 3;
        containerLayout.marginWidth = 3;
        container.setLayoutManager((LayoutManager)containerLayout);
        this.createTopPanel((IFigure)container);
        this.createSeparator((IFigure)container);
        this.createWeekPanel((IFigure)container);
        this.createDaysPanel((IFigure)container);
        this.createSeparator((IFigure)container);
        this.createBottomPanel((IFigure)container);
    }

    private void createTopPanel(IFigure parent) {
        Layer panel = new Layer();
        GridData panelConstraint = new GridData(4, 4, true, false);
        parent.add((IFigure)panel, (Object)panelConstraint);
        org.eclipse.draw2d.GridLayout panelLayout = new org.eclipse.draw2d.GridLayout(12, true);
        panelLayout.horizontalSpacing = 0;
        panelLayout.verticalSpacing = 0;
        panelLayout.marginHeight = 0;
        panelLayout.marginWidth = 0;
        panel.setLayoutManager((LayoutManager)panelLayout);
        this.lastMonth = this.createArrowFigure((IFigure)panel, 8);
        this.monthFigure = this.createMonthFigure((IFigure)panel);
        this.nextMonth = this.createArrowFigure((IFigure)panel, 32);
        this.lastYear = this.createArrowFigure((IFigure)panel, 1);
        this.yearFigure = this.createYearFigure((IFigure)panel);
        this.nextYear = this.createArrowFigure((IFigure)panel, 4);
    }

    private MonthFigure createMonthFigure(IFigure parent) {
        MonthFigure figure = new MonthFigure();
        figure.setTextCandidates(MONTHS);
        GridData constraint = new GridData(4, 4, true, true);
        constraint.horizontalSpan = 5;
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private YearFigure createYearFigure(IFigure parent) {
        YearFigure figure = new YearFigure();
        figure.setTextCandidates(new String[]{"0000"});
        GridData constraint = new GridData(4, 4, true, true);
        constraint.horizontalSpan = 3;
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private ArrowFigure createArrowFigure(IFigure parent, int orientation) {
        ArrowFigure arrow = new ArrowFigure();
        arrow.setOrientation(orientation);
        arrow.setForegroundColor(ColorUtils.getColor((String)"#808080"));
        arrow.setBackgroundColor(ColorUtils.getColor((String)"#C0C0C0"));
        arrow.getContent().setVisible(false);
        GridData constraint = new GridData(4, 4, true, true);
        parent.add((IFigure)arrow, (Object)constraint);
        this.eventHandler.attach((IFigure)arrow);
        return arrow;
    }

    private void createSeparator(IFigure parent) {
        HorizontalLine line = new HorizontalLine();
        line.setMargin(3);
        line.setForegroundColor(ColorUtils.getColor((String)"#C0C0C0"));
        GridData constraint = new GridData(4, 4, true, false);
        constraint.heightHint = 3;
        parent.add((IFigure)line, (Object)constraint);
    }

    private void createWeekPanel(IFigure parent) {
        Layer panel = new Layer();
        GridData panelConstraint = new GridData(4, 4, true, false);
        parent.add((IFigure)panel, (Object)panelConstraint);
        org.eclipse.draw2d.GridLayout panelLayout = new org.eclipse.draw2d.GridLayout(7, true);
        panelLayout.horizontalSpacing = 0;
        panelLayout.verticalSpacing = 0;
        panelLayout.marginHeight = 0;
        panelLayout.marginWidth = 0;
        panel.setLayoutManager((LayoutManager)panelLayout);
        Font symbolFont = FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2);
        int i = 0;
        while (i < 7) {
            TextLayer symbol = new TextLayer();
            symbol.setFont(symbolFont);
            symbol.setText(WEEK_SYMBOLS[i]);
            if (i == 0 || i == 6) {
                symbol.setForegroundColor(ColorUtils.getColor((String)COLOR_WEEKEND));
            } else {
                symbol.setForegroundColor(ColorUtils.getColor((String)"#808080"));
            }
            GridData symbolConstraint = new GridData(4, 4, true, true);
            panel.add((IFigure)symbol, (Object)symbolConstraint);
            ++i;
        }
    }

    private void createDaysPanel(IFigure parent) {
        this.dateLayer = new Layer();
        GridData layerConstraint = new GridData(4, 4, true, true);
        parent.add(this.dateLayer, (Object)layerConstraint);
        this.dateLayer.setLayoutManager((LayoutManager)new ConstraintStackLayout());
        this.datePanel = new Layer();
        this.dateLayer.add(this.datePanel, null);
        this.datePanel.setLayoutManager((LayoutManager)new DatePanelLayout());
        int i = 0;
        while (i < 42) {
            DayFigure dayFigure = new DayFigure();
            this.eventHandler.attach((IFigure)dayFigure);
            this.datePanel.add((IFigure)dayFigure);
            ++i;
        }
    }

    private void createBottomPanel(IFigure parent) {
        boolean hasCancel = (this.style & 0x100) != 0;
        Layer panel = new Layer();
        GridData panelConstraint = new GridData(4, 4, true, false);
        parent.add((IFigure)panel, (Object)panelConstraint);
        org.eclipse.draw2d.GridLayout panelLayout = new org.eclipse.draw2d.GridLayout(hasCancel ? 2 : 1, false);
        panelLayout.horizontalSpacing = 0;
        panelLayout.verticalSpacing = 0;
        panelLayout.marginHeight = 0;
        panelLayout.marginWidth = 0;
        panel.setLayoutManager((LayoutManager)panelLayout);
        this.todayFigure = this.createTodayFigure((IFigure)panel);
        if (hasCancel) {
            this.cancelFigure = this.createCancelFigure((IFigure)panel);
        }
    }

    private BaseFigure createTodayFigure(IFigure parent) {
        BaseFigure figure = new BaseFigure();
        figure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        figure.setForegroundColor(ColorUtils.getColor((String)COLOR_TODAY));
        GridData constraint = new GridData(4, 4, true, true);
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private BaseFigure createCancelFigure(IFigure parent) {
        BaseFigure figure = new BaseFigure();
        figure.setText(" X ");
        figure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        figure.setForegroundColor(ColorUtils.getColor((String)COLOR_CANCEL));
        GridData constraint = new GridData(4, 4, false, true);
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private Calendar getSelectedDate() {
        return this.selection;
    }

    private void changeCalendar(int newYear, int newMonth) {
        this.changeCalendar(newYear, newMonth, false);
    }

    private void changeCalendar(int newYear, int newMonth, boolean smooth) {
        boolean calendarChanged;
        boolean bl = calendarChanged = newMonth != this.currentMonth || newYear != this.currentYear;
        if (!calendarChanged) {
            return;
        }
        if (smooth) {
            if (this.datePicker != null) {
                int months = (newYear - this.currentYear) * 12 + newMonth - this.currentMonth;
                this.animationAdvisor.addYearsToRoll(months / 12);
                this.animationAdvisor.addMonthsToRoll(months % 12);
                this.performRollCalendarAnimation(this.currentYear, this.currentMonth);
            }
            this.currentYear = newYear;
            this.currentMonth = newMonth;
        } else {
            this.currentYear = newYear;
            this.currentMonth = newMonth;
            if (this.datePicker != null) {
                this.updateCalendar();
            }
            this.updateSelection();
        }
    }

    private void updateCalendar() {
        this.today = Calendar.getInstance();
        this.updateDayFigures(this.datePanel.getChildren(), this.currentYear, this.currentMonth);
        this.monthFigure.setMonth(this.currentMonth);
        this.yearFigure.setYear(this.currentYear);
        this.todayFigure.setText(Messages.TodayPattern);
    }

    private void updateDayFigures(List dayFigures, int year, int month) {
        Calendar date = DatePicker2.getCalendarStart(this.today, year, month);
        int i = 0;
        while (i < dayFigures.size()) {
            DayFigure dayFigure = (DayFigure)((Object)dayFigures.get(i));
            date = (Calendar)date.clone();
            if (i > 0) {
                date.add(5, 1);
            }
            dayFigure.setDate(date);
            this.updateDayFigure(dayFigure, year, month);
            ++i;
        }
    }

    private void updateDayFigure(DayFigure figure, int year, int month) {
        figure.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
        Calendar date = figure.getDate();
        if (DatePicker2.isSameDay(date, this.today)) {
            figure.setForegroundColor(ColorUtils.getColor((String)COLOR_TODAY));
        } else if (DatePicker2.isWeekend(date)) {
            figure.setForegroundColor(ColorUtils.getColor((String)COLOR_WEEKEND));
        } else {
            figure.setForegroundColor(ColorUtils.getColor((String)COLOR_TEXT));
        }
        if (date.get(2) == month && date.get(1) == year) {
            figure.setTextAlpha(255);
        } else {
            figure.setTextAlpha(32);
        }
    }

    private void updateSelection() {
        if (this.datePicker != null) {
            for (Object figure : this.datePanel.getChildren()) {
                DayFigure dayFigure = (DayFigure)((Object)figure);
                dayFigure.setSelected(DatePicker2.isSameDay(dayFigure.getDate(), this.getSelectedDate()));
            }
        }
        if (this.placeholder != null && this.selection != null) {
            String day = String.format("%1$td", this.selection);
            String month = String.format("%1$tm", this.selection);
            String year = String.format("%1$tY", this.selection);
            this.dayText.setText(day);
            this.monthText.setText(month);
            this.yearText.setText(year);
        }
        this.placeholder.layout();
    }

    private void update() {
        if (this.datePicker != null) {
            this.updateCalendar();
        }
        this.updateSelection();
    }

    private void performRollCalendarAnimation(int oldYear, int oldMonth) {
        CalendarAnimation animation;
        int newMonth;
        int newYear;
        if (this.animating) {
            return;
        }
        this.animating = true;
        if (this.animationAdvisor.getYearsToRoll() != 0) {
            if (this.animationAdvisor.getYearsToRoll() < 0) {
                newYear = oldYear - 1;
                newMonth = oldMonth;
                animation = new LastYearAnimation(this.animationAdvisor);
            } else {
                newYear = oldYear + 1;
                newMonth = oldMonth;
                animation = new NextYearAnimation(this.animationAdvisor);
            }
        } else if (this.animationAdvisor.getMonthsToRoll() != 0) {
            if (this.animationAdvisor.getMonthsToRoll() < 0) {
                newYear = oldMonth <= 0 ? oldYear - 1 : oldYear;
                newMonth = oldMonth <= 0 ? 11 : oldMonth - 1;
                animation = new LastMonthAnimation(this.animationAdvisor);
            } else {
                newYear = oldMonth >= 11 ? oldYear + 1 : oldYear;
                newMonth = oldMonth >= 11 ? 0 : oldMonth + 1;
                animation = new NextMonthAnimation(this.animationAdvisor);
            }
        } else {
            newYear = oldYear;
            newMonth = oldMonth;
            animation = null;
        }
        this.monthFigure.setMonth(newMonth);
        this.yearFigure.setYear(newYear);
        if (animation != null) {
            this.animationAdvisor.setStartMonth(oldYear, oldMonth);
            this.animationAdvisor.setEndMonth(newYear, newMonth);
            animation.callback(new Runnable(){

                @Override
                public void run() {
                    DatePicker2.this.datePanel = animation.getNewPanel();
                    if (DatePicker2.this.animationAdvisor.isDone()) {
                        DatePicker2.this.animating = false;
                    } else {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DatePicker2.this.animating = false;
                                DatePicker2.this.performRollCalendarAnimation(newYear, newMonth);
                            }
                        });
                    }
                }
            }).start();
        }
    }

    private void selected(BaseFigure target) {
        if (target instanceof MonthFigure) {
            target.setSelected(true);
            this.showMonthPopup();
        } else if (target instanceof YearFigure) {
            target.setSelected(true);
            this.showYearPopup();
        } else if (target == this.todayFigure) {
            this.todaySelected();
        } else if (target == this.lastMonth) {
            this.lastMonthSelected(true);
        } else if (target == this.nextMonth) {
            this.nextMonthSelected(true);
        } else if (target == this.lastYear) {
            this.lastYearSelected(true);
        } else if (target == this.nextYear) {
            this.nextYearSelected(true);
        } else if (target == this.cancelFigure) {
            this.cancelSelected();
        }
    }

    private void showMonthPopup() {
        this.createMonthMenu();
        int month = 0;
        while (month < this.monthActions.length) {
            MonthAction action = this.monthActions[month];
            action.setChecked(month == this.currentMonth);
            ++month;
        }
        Rectangle b = this.monthFigure.getBounds();
        Point loc = this.control.toDisplay(b.x, b.y + b.height);
        Menu menu = this.monthMenu.createContextMenu(this.control);
        menu.setLocation(loc.x + 10, loc.y + 1);
        menu.setVisible(true);
    }

    private void createMonthMenu() {
        if (this.monthMenu != null) {
            return;
        }
        this.monthMenu = new MenuManager();
        this.monthMenu.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager manager) {
            }

            public void menuAboutToHide(IMenuManager manager) {
                DatePicker2.this.monthFigure.setSelected(false);
            }
        });
        this.monthActions = new MonthAction[12];
        int month = 0;
        while (month < 12) {
            MonthAction action = new MonthAction(month);
            this.monthMenu.add((IAction)action);
            this.monthActions[month] = action;
            ++month;
        }
    }

    private void showYearPopup() {
        this.createYearMenu();
        int start = this.currentYear - 3;
        int year = 0;
        while (year < this.yearActions.length) {
            YearAction action = this.yearActions[year];
            action.setYear(start + year);
            action.setChecked(action.getYear() == this.currentYear);
            ++year;
        }
        Rectangle b = this.yearFigure.getBounds();
        Point loc = this.control.toDisplay(b.x, b.y + b.height);
        Menu menu = this.yearMenu.createContextMenu(this.control);
        menu.setLocation(loc.x, loc.y + 1);
        menu.setVisible(true);
    }

    private void createYearMenu() {
        if (this.yearMenu != null) {
            return;
        }
        this.yearMenu = new MenuManager();
        this.yearMenu.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager manager) {
            }

            public void menuAboutToHide(IMenuManager manager) {
                DatePicker2.this.yearFigure.setSelected(false);
            }
        });
        this.yearActions = new YearAction[11];
        int year = 0;
        while (year < this.yearActions.length) {
            YearAction action = new YearAction();
            this.yearMenu.add((IAction)action);
            this.yearActions[year] = action;
            ++year;
        }
    }

    private void monthSelected(int month) {
        this.changeCalendar(this.currentYear, month);
    }

    private void yearSelected(int year) {
        this.changeCalendar(year, this.currentMonth);
    }

    private void daySelected(DayFigure day) {
        Calendar date = day.getDate();
        this.changeDate(date);
        if (date != null && date.get(2) != this.currentMonth) {
            this.changeCalendar(date.get(1), date.get(2), true);
        }
    }

    private void todaySelected() {
        this.changeDate(this.today);
        this.changeCalendar(this.today.get(1), this.today.get(2));
    }

    private void lastMonthSelected(boolean smooth) {
        if (this.currentMonth <= 0) {
            this.changeCalendar(this.currentYear - 1, 11, smooth);
        } else {
            this.changeCalendar(this.currentYear, this.currentMonth - 1, smooth);
        }
    }

    private void nextMonthSelected(boolean smooth) {
        if (this.currentMonth >= 11) {
            this.changeCalendar(this.currentYear + 1, 0, smooth);
        } else {
            this.changeCalendar(this.currentYear, this.currentMonth + 1, smooth);
        }
    }

    private void lastYearSelected(boolean smooth) {
        this.changeCalendar(this.currentYear - 1, this.currentMonth, smooth);
    }

    private void nextYearSelected(boolean smooth) {
        this.changeCalendar(this.currentYear + 1, this.currentMonth, smooth);
    }

    private void cancelSelected() {
        this.changeDate(null);
    }

    private void rollMonth(int count) {
        Calendar temp = (Calendar)this.today.clone();
        temp.set(1, this.currentYear);
        temp.set(2, this.currentMonth);
        temp.add(2, count);
        this.changeCalendar(temp.get(1), temp.get(2), true);
    }

    private void changeDate(Calendar date) {
        if (date != null) {
            date.set(14, 0);
        }
        this.selection = date;
        this.updateSelection();
        if (this.firingSelectionChange) {
            return;
        }
        this.firingSelectionChange = true;
        if (this.dropdownDatePicker != null) {
            this.control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DatePicker2.this.dropdownDatePicker.close();
                }
            });
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        this.firingSelectionChange = false;
    }

    public Object getInput() {
        return this.today;
    }

    public void refresh() {
        this.update();
    }

    public void setInput(Object input) {
        if (input instanceof Calendar) {
            Calendar oldInput = this.today;
            this.today = (Calendar)input;
            this.inputChanged(input, oldInput);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.update();
    }

    public void setMinTime(Calendar minTime) {
        if (minTime != null) {
            minTime.set(14, 0);
            this.minTime = minTime;
        }
    }

    public Calendar getMinTime() {
        return this.minTime;
    }

    public void setMaxTime(Calendar maxTime) {
        if (maxTime != null) {
            maxTime.set(14, 0);
            this.maxTime = maxTime;
        }
    }

    public Calendar getMaxTime() {
        return this.maxTime;
    }

    private static boolean isWeekend(Calendar date) {
        int dow = date.get(7);
        return dow == 1 || dow == 7;
    }

    private static Calendar getCalendarStart(Calendar date, int year, int month) {
        date = (Calendar)date.clone();
        date.set(year, month, 1);
        while (date.get(7) != 1) {
            date.add(5, -1);
        }
        return date;
    }

    private static boolean isSameDay(Calendar date1, Calendar date2) {
        if (date1 == null) {
            return date2 == null;
        }
        if (date2 == null) {
            return false;
        }
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    private class AnimationAdvisor
    implements IAnimationAdvisor {
        private int monthsToRoll = 0;
        private int yearsToRoll = 0;
        private int duration = -1;
        private int oldYear;
        private int oldMonth;
        private int newYear;
        private int newMonth;

        private AnimationAdvisor() {
        }

        @Override
        public void addMonthsToRoll(int count) {
            this.monthsToRoll += count;
            this.duration = -1;
        }

        @Override
        public void addYearsToRoll(int count) {
            this.yearsToRoll += count;
            this.duration = -1;
        }

        @Override
        public int getDuration() {
            if (this.duration < 0) {
                int steps = Math.abs(this.monthsToRoll) + Math.abs(this.yearsToRoll);
                this.duration = steps == 0 ? 0 : 200 / steps;
            }
            return this.duration;
        }

        @Override
        public IFigure getLayer() {
            return DatePicker2.this.dateLayer;
        }

        @Override
        public int getMonthsToRoll() {
            return this.monthsToRoll;
        }

        @Override
        public int getNewMonth() {
            return this.newMonth;
        }

        @Override
        public int getNewYear() {
            return this.newYear;
        }

        @Override
        public int getOldMonth() {
            return this.oldMonth;
        }

        @Override
        public int getOldYear() {
            return this.oldYear;
        }

        @Override
        public IFigure getPanel() {
            return DatePicker2.this.datePanel;
        }

        @Override
        public int getYearsToRoll() {
            return this.yearsToRoll;
        }

        @Override
        public void initNewDay(DayFigure figure) {
            DatePicker2.this.updateDayFigure(figure, this.oldYear, this.oldMonth);
        }

        @Override
        public void initOldDay(DayFigure figure) {
            figure.setPreselected(false);
            figure.setSelected(DatePicker2.isSameDay(figure.getDate(), DatePicker2.this.getSelectedDate()));
            DatePicker2.this.eventHandler.detach((IFigure)figure);
        }

        @Override
        public boolean isDone() {
            return this.monthsToRoll == 0 && this.yearsToRoll == 0;
        }

        @Override
        public void setEndMonth(int newYear, int newMonth) {
            this.newYear = newYear;
            this.newMonth = newMonth;
        }

        @Override
        public void setStartMonth(int oldYear, int oldMonth) {
            this.oldYear = oldYear;
            this.oldMonth = oldMonth;
        }

        @Override
        public void updateNewDay(DayFigure figure) {
            figure.setPreselected(false);
            figure.setSelected(DatePicker2.isSameDay(figure.getDate(), DatePicker2.this.getSelectedDate()));
            DatePicker2.this.eventHandler.attach((IFigure)figure);
            DatePicker2.this.updateDayFigure(figure, this.newYear, this.newMonth);
        }
    }

    private class DropdownDatePicker
    extends PopupDialog {
        public DropdownDatePicker(Shell parent) {
            super(parent, 8, true, false, false, false, false, null, null);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            DatePicker2.this.createDatePicker(composite);
            DatePicker2.this.datePicker.setLayoutData((Object)new org.eclipse.swt.layout.GridData(4, 4, true, true));
            DatePicker2.this.initDatePicker();
            DatePicker2.this.update();
            return composite;
        }

        public boolean close() {
            boolean closed = super.close();
            if (closed) {
                DatePicker2.this.datePicker = null;
            }
            return closed;
        }

        protected Point getInitialLocation(Point initialSize) {
            Control c = DatePicker2.this.getControl();
            org.eclipse.swt.graphics.Rectangle r = c.getBounds();
            return c.toDisplay(-2, r.height - 1);
        }
    }

    private class EventHandler
    implements MouseListener,
    MouseMotionListener,
    Listener {
        private boolean dayPressed = false;
        private BaseFigure target = null;

        private EventHandler() {
        }

        public void attach(IFigure figure) {
            figure.addMouseListener((MouseListener)this);
            figure.addMouseMotionListener((MouseMotionListener)this);
        }

        public void detach(IFigure figure) {
            figure.removeMouseListener((MouseListener)this);
            figure.removeMouseMotionListener((MouseMotionListener)this);
        }

        public void install(Control control) {
            control.addListener(4, (Listener)this);
            control.addListener(37, (Listener)this);
            control.addListener(1, (Listener)this);
        }

        public void uninstall(Control control) {
            control.removeListener(4, (Listener)this);
            control.removeListener(37, (Listener)this);
            control.removeListener(1, (Listener)this);
        }

        public void handleEvent(Event event) {
            if (event.type == 4) {
                this.dayPressed = false;
                if (this.target != null) {
                    BaseFigure eventTarget = this.target;
                    this.target.setPressed(false);
                    this.target = null;
                    DatePicker2.this.selected(eventTarget);
                }
            } else if (event.type == 37) {
                if (event.count == 0) {
                    return;
                }
                DatePicker2.this.rollMonth(event.count > 0 ? -1 : 1);
            } else if (event.type == 1) {
                this.handleKeyPress(event.keyCode, event.stateMask);
            }
        }

        private void handleKeyPress(int key, int mask) {
            if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000001)) {
                DatePicker2.this.lastMonthSelected(true);
            } else if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000002)) {
                DatePicker2.this.nextMonthSelected(true);
            } else if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000003)) {
                DatePicker2.this.lastYearSelected(true);
            } else if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000004)) {
                DatePicker2.this.nextYearSelected(true);
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
            if (this.target == null) {
                BaseFigure source = (BaseFigure)((Object)me.getSource());
                if (source instanceof DayFigure && this.dayPressed) {
                    source.setPressed(true);
                    source.setPreselected(false);
                } else {
                    if (source == DatePicker2.this.monthFigure || source == DatePicker2.this.lastMonth || source == DatePicker2.this.nextMonth) {
                        DatePicker2.this.monthFigure.setPreselected(true);
                        DatePicker2.this.lastMonth.getContent().setVisible(true);
                        DatePicker2.this.nextMonth.getContent().setVisible(true);
                    } else if (source == DatePicker2.this.yearFigure || source == DatePicker2.this.lastYear || source == DatePicker2.this.nextYear) {
                        DatePicker2.this.yearFigure.setPreselected(true);
                        DatePicker2.this.lastYear.getContent().setVisible(true);
                        DatePicker2.this.nextYear.getContent().setVisible(true);
                    }
                    source.setPreselected(true);
                }
            }
        }

        public void mouseExited(MouseEvent me) {
            if (this.target == null) {
                BaseFigure source = (BaseFigure)((Object)me.getSource());
                if (source instanceof DayFigure) {
                    source.setPreselected(false);
                    if (this.dayPressed) {
                        source.setPressed(false);
                    }
                } else {
                    if (source == DatePicker2.this.monthFigure || source == DatePicker2.this.lastMonth || source == DatePicker2.this.nextMonth) {
                        DatePicker2.this.monthFigure.setPreselected(false);
                        DatePicker2.this.lastMonth.getContent().setVisible(false);
                        DatePicker2.this.nextMonth.getContent().setVisible(false);
                    } else if (source == DatePicker2.this.yearFigure || source == DatePicker2.this.lastYear || source == DatePicker2.this.nextYear) {
                        DatePicker2.this.yearFigure.setPreselected(false);
                        DatePicker2.this.lastYear.getContent().setVisible(false);
                        DatePicker2.this.nextYear.getContent().setVisible(false);
                    }
                    source.setPreselected(false);
                }
            }
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            BaseFigure source = (BaseFigure)((Object)me.getSource());
            source.setPressed(true);
            source.setPreselected(false);
            if (source instanceof DayFigure) {
                this.dayPressed = true;
            } else {
                this.target = source;
            }
        }

        public void mouseReleased(MouseEvent me) {
            BaseFigure source = (BaseFigure)((Object)me.getSource());
            source.setPressed(false);
            if (source instanceof DayFigure) {
                if (this.dayPressed) {
                    DatePicker2.this.daySelected((DayFigure)((Object)me.getSource()));
                }
                source.setPreselected(true);
            } else if (!source.isSelected()) {
                source.setPreselected(true);
            }
        }
    }

    private class MonthAction
    extends Action {
        private int month;

        public MonthAction(int month) {
            super(MONTHS[month]);
            this.month = month;
        }

        public void run() {
            DatePicker2.this.monthSelected(this.month);
        }
    }

    private class YearAction
    extends Action {
        private int year;

        private YearAction() {
        }

        public void setYear(int year) {
            this.year = year;
            this.setText("" + year);
        }

        public int getYear() {
            return this.year;
        }

        public void run() {
            DatePicker2.this.yearSelected(this.year);
        }
    }
}

