/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.jhotdraw.app.Application;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractDrawingEditorAction;
import org.jhotdraw.draw.action.EditCanvasPanel;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class EditCanvasAction
extends AbstractDrawingEditorAction {
    public static final String ID = "view.editCanvas";
    private JFrame frame;
    private EditCanvasPanel settingsPanel;
    private PropertyChangeListener propertyChangeHandler;
    private Application app;

    public EditCanvasAction(Application app, DrawingEditor editor) {
        super(editor);
        this.app = app;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getFrame().setVisible(true);
    }

    @Override
    protected void updateViewState() {
        if (this.getView() != null && this.settingsPanel != null) {
            this.settingsPanel.setDrawing(this.getView().getDrawing());
        }
    }

    protected Application getApplication() {
        return this.app;
    }

    protected JFrame getFrame() {
        if (this.frame == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            this.frame = new JFrame();
            this.frame.setTitle(labels.getString("window.editCanvas.title"));
            this.frame.setResizable(false);
            this.settingsPanel = new EditCanvasPanel();
            this.frame.add(this.settingsPanel);
            this.frame.pack();
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            PreferencesUtil.installFramePrefsHandler(prefs, "canvasSettings", this.frame);
            this.getApplication().addWindow(this.frame, null);
        }
        this.settingsPanel.setDrawing(this.getView().getDrawing());
        return this.frame;
    }
}

