/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.normalization;

import com.ibm.icu.text.Normalizer;
import java.text.Normalizer;

public class Normalizer {
    private static final String JDK_NORMALIZER_CLASS_NAME = "java.text.Normalizer";
    private static Boolean useJdkNormalizer = null;

    public static String normalizeToNfc(String message) {
        if (useJdkNormalizer == null) {
            try {
                Class.forName(JDK_NORMALIZER_CLASS_NAME);
                useJdkNormalizer = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                useJdkNormalizer = Boolean.FALSE;
            }
        }
        if (useJdkNormalizer.booleanValue()) {
            return java.text.Normalizer.normalize(message, Normalizer.Form.NFC);
        }
        return com.ibm.icu.text.Normalizer.normalize((String)message, (Normalizer.Mode)com.ibm.icu.text.Normalizer.NFC);
    }

    private Normalizer() {
    }
}

