/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.google.api.client.auth.oauth2.Credential;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.file.ThreadSafeFileLock;
import org.yccheok.jstock.file.UserDataDirectory;
import org.yccheok.jstock.file.UserDataFile;
import org.yccheok.jstock.gui.Icons;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.MemoryLogJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.portfolio.Broker;
import org.yccheok.jstock.portfolio.BrokingFirm;
import org.yccheok.jstock.portfolio.ClearingFee;
import org.yccheok.jstock.portfolio.SimpleBroker;
import org.yccheok.jstock.portfolio.SimpleClearingFee;
import org.yccheok.jstock.portfolio.SimpleStampDuty;
import org.yccheok.jstock.portfolio.StampDuty;

public class LoadFromCloudJDialog
extends JDialog {
    private final Pair<Credential, String> credentialEx;
    private volatile SwingWorker<JStockOptions, Status> loadFromCloudTask = null;
    private final List<String> memoryLog = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(LoadFromCloudJDialog.class);
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JXHeader jXHeader1;

    public LoadFromCloudJDialog(Frame parent, boolean modal, Pair<Credential, String> credentialEx, boolean credentialFromDisk) {
        super(parent, modal);
        this.initComponents();
        this.pack();
        Dimension dimension = JStock.instance().getUIOptions().getDimension("LOAD_FROM_CLOUD_JDIALOG");
        if (dimension != null) {
            this.setSize(dimension);
        } else {
            this.setSize(new Dimension(487, 313));
        }
        this.setLocationRelativeTo(null);
        this.credentialEx = credentialEx;
        this.jLabel1.setText((String)credentialEx.second);
        this.jLabel4.setVisible(false);
        this.jLabel5.setVisible(false);
        if (!credentialFromDisk) {
            this.jButton1.doClick();
        }
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jXHeader1 = new JXHeader();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("LoadFromCloudJDialog_Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                LoadFromCloudJDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.jPanel6, "West");
        this.getContentPane().add((Component)this.jPanel5, "East");
        this.jXHeader1.setDescription(bundle.getString("LoadFromCloudJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/download_from_cloud.png")));
        this.jXHeader1.setTitle(bundle.getString("LoadFromCloudJDialog_Title"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("LoadFromCloudJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadFromCloudJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("LoadFromCloudJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadFromCloudJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel3, "Last");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel5.setText(bundle.getString("WizardDownloadlIndicatorJPanel_ViewLog"));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LoadFromCloudJDialog.this.jLabel5MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                LoadFromCloudJDialog.this.jLabel5MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                LoadFromCloudJDialog.this.jLabel5MouseExited(evt);
            }
        });
        this.jPanel4.add(this.jLabel5);
        this.jLabel3.setForeground(new Color(255, 0, 0));
        this.jLabel3.setText(bundle.getString("LoadFromCloudJDialog_WarningAllYourDataWillBeOverwriteByCloudData"));
        this.jPanel4.add(this.jLabel3);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jPanel4.add(this.jLabel4);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("LoadFromCloudJDialog_GoogleAccount")));
        this.jLabel1.setBackground(new Color(140, 196, 116));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 1));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("username@email.com");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jLabel1.setOpaque(true);
        this.jPanel2.add(this.jLabel1);
        this.jButton3.setText(bundle.getString("LoadFromCloudJDialog_SignOut"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadFromCloudJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton3);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.setSize(new Dimension(487, 313));
        this.setLocationRelativeTo(null);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.cancel();
        JStock.instance().getUIOptions().setDimension("LOAD_FROM_CLOUD_JDIALOG", this.getSize());
    }

    private void cancel() {
        if (this.loadFromCloudTask != null) {
            this.loadFromCloudTask.cancel(true);
            this.loadFromCloudTask = null;
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        MemoryLogJDialog memoryLogJDialog = new MemoryLogJDialog((Frame)JStock.instance(), true);
        memoryLogJDialog.setLocationRelativeTo(this);
        memoryLogJDialog.setLog(this.memoryLog);
        memoryLogJDialog.setVisible(true);
    }

    private void jLabel5MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel5MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jButton1.setEnabled(false);
        this.jButton3.setEnabled(false);
        this.jLabel3.setText(GUIBundle.getString("LoadFromCloudJDialog_LoadingFromCloud..."));
        this.jLabel4.setIcon(Icons.BUSY);
        this.jLabel3.setVisible(true);
        this.jLabel4.setVisible(true);
        this.loadFromCloudTask = this.getLoadFromCloudTask();
        this.loadFromCloudTask.execute();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        org.yccheok.jstock.google.Utils.logoutDrive();
        this.setVisible(false);
        this.dispose();
        JStock.instance().loadFromCloud();
    }

    private SwingWorker<JStockOptions, Status> getLoadFromCloudTask() {
        SwingWorker<JStockOptions, Status> worker = new SwingWorker<JStockOptions, Status>(){

            @Override
            protected void done() {
                JStockOptions result = null;
                if (!this.isCancelled()) {
                    try {
                        result = (JStockOptions)this.get();
                    }
                    catch (InterruptedException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (CancellationException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                LoadFromCloudJDialog.this.jButton1.setEnabled(true);
                LoadFromCloudJDialog.this.jButton3.setEnabled(true);
                if (result != null) {
                    JStock.instance().reloadAfterDownloadFromCloud(result);
                    JOptionPane.showMessageDialog(LoadFromCloudJDialog.this, GUIBundle.getString("LoadFromCloudJDialog_Success"));
                    LoadFromCloudJDialog.this.setVisible(false);
                    LoadFromCloudJDialog.this.dispose();
                }
            }

            @Override
            protected void process(List<Status> statuses) {
                for (Status status : statuses) {
                    LoadFromCloudJDialog.this.writeToMemoryLog(status.message);
                    LoadFromCloudJDialog.this.jLabel3.setText(status.message);
                    LoadFromCloudJDialog.this.jLabel4.setIcon(status.icon);
                    LoadFromCloudJDialog.this.jLabel3.setVisible(true);
                    LoadFromCloudJDialog.this.jLabel4.setVisible(true);
                    if (status.icon == Icons.ERROR || status.icon == Icons.WARNING) {
                        LoadFromCloudJDialog.this.jLabel3.setForeground(Color.RED);
                        LoadFromCloudJDialog.this.jLabel5.setVisible(true);
                        continue;
                    }
                    LoadFromCloudJDialog.this.jLabel3.setForeground(Color.BLUE);
                    LoadFromCloudJDialog.this.jLabel5.setVisible(false);
                }
            }

            @Override
            protected JStockOptions doInBackground() {
                String message;
                if (this.isCancelled()) {
                    return null;
                }
                LoadFromCloudJDialog.this.memoryLog.clear();
                this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_LoadingFromCloud..."), Icons.BUSY));
                Utils.CloudFile cloudFile = Utils.loadFromGoogleDrive((Credential)((LoadFromCloudJDialog)LoadFromCloudJDialog.this).credentialEx.first);
                if (cloudFile == null) {
                    this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_LoadingFromCloudFail"), Icons.ERROR));
                    return null;
                }
                if (cloudFile.checksum != org.yccheok.jstock.analysis.Utils.getChecksum(cloudFile.file)) {
                    this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_CheckingCheckSumFail"), Icons.ERROR));
                    return null;
                }
                long today = new Date().getTime();
                long milli_seconds_in_a_day = 86400000L;
                if (today / 86400000L != cloudFile.date / 86400000L) {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    message = MessageFormat.format(MessagesBundle.getString("question_message_overwrite_your_data_by_cloud_data_at_template"), dateFormat.format(cloudFile.date));
                    int result = JOptionPane.showConfirmDialog(LoadFromCloudJDialog.this, message, MessagesBundle.getString("question_title_overwrite_your_data_by_cloud_data_at"), 0);
                    if (result != 0) {
                        this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_UserRefuseToOverwriteWithOldData"), Icons.ERROR));
                        return null;
                    }
                }
                if (!Utils.isCloudFileCompatible(cloudFile.version)) {
                    String message2 = MessageFormat.format(GUIBundle.getString("LoadFromCloudJDialog_VersionNotCompatible_template"), cloudFile.version);
                    this.publish(Status.newInstance(message2, Icons.ERROR));
                    return null;
                }
                if (this.isCancelled()) {
                    return null;
                }
                JStock.instance().commitBeforeLoadFromCloud();
                this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_ExtractingData..."), Icons.BUSY));
                boolean status = Utils.extractZipFile(cloudFile.file, true);
                if (this.isCancelled()) {
                    return null;
                }
                if (!status) {
                    message = MessageFormat.format(GUIBundle.getString("LoadFromCloudJDialog_ExtractingDataFail_template"), cloudFile.file);
                    this.publish(Status.newInstance(message, Icons.ERROR));
                    return null;
                }
                File f = new File(UserDataDirectory.Config.get() + UserDataFile.OptionsXml.get());
                JStockOptions jStockOptions = Utils.fromXML(JStockOptions.class, f);
                if (jStockOptions == null) {
                    String message3 = MessageFormat.format(GUIBundle.getString("LoadFromCloudJDialog_ExtractingDataFail_template"), f);
                    this.publish(Status.newInstance(message3, Icons.ERROR));
                    return null;
                }
                LoadFromCloudJDialog.this.loadBrokingFirmsFromJson(jStockOptions);
                this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_Success"), Icons.OK));
                return jStockOptions;
            }
        };
        return worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadBrokingFirmsFromJson(JStockOptions jStockOptions) {
        File brokingFirmsFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "brokingfirms.json");
        if (!brokingFirmsFile.isFile()) {
            return false;
        }
        List brokingFirms = null;
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.registerTypeAdapter(Broker.class, (Object)new SimpleBrokerDeserializer()).registerTypeAdapter(ClearingFee.class, (Object)new SimpleClearingFeeDeserializer()).registerTypeAdapter(StampDuty.class, (Object)new SimpleStampDutyDeserializer()).create();
        ThreadSafeFileLock.Lock lock = ThreadSafeFileLock.getLock(brokingFirmsFile);
        if (lock == null) {
            return false;
        }
        ThreadSafeFileLock.lockRead(lock);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(brokingFirmsFile), "UTF-8"));){
            brokingFirms = (List)gson.fromJson((Reader)reader, new TypeToken<List<BrokingFirm>>(){}.getType());
            if (brokingFirms == null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (JsonSyntaxException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        finally {
            ThreadSafeFileLock.unlockRead(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        if (brokingFirms == null) {
            return false;
        }
        jStockOptions.clearBrokingFirms();
        for (BrokingFirm brokingFirm : brokingFirms) {
            jStockOptions.addBrokingFirm(brokingFirm);
        }
        return true;
    }

    private void writeToMemoryLog(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
        String s = dateFormat.format(new Date()) + "\n" + message;
        this.memoryLog.add(s);
    }

    private static class SimpleStampDutyDeserializer
    implements JsonDeserializer<SimpleStampDuty> {
        private SimpleStampDutyDeserializer() {
        }

        public SimpleStampDuty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            double maximumRate = jsonObject.get("maximumRate").getAsDouble();
            double fraction = jsonObject.get("fraction").getAsDouble();
            double rate = jsonObject.get("rate").getAsDouble();
            return new SimpleStampDuty(maximumRate, fraction, rate);
        }
    }

    private static class SimpleClearingFeeDeserializer
    implements JsonDeserializer<SimpleClearingFee> {
        private SimpleClearingFeeDeserializer() {
        }

        public SimpleClearingFee deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            double maximumRate = jsonObject.get("maximumRate").getAsDouble();
            double minimumRate = jsonObject.get("minimumRate").getAsDouble();
            double rate = jsonObject.get("rate").getAsDouble();
            return new SimpleClearingFee(maximumRate, minimumRate, rate);
        }
    }

    private static class SimpleBrokerDeserializer
    implements JsonDeserializer<SimpleBroker> {
        private SimpleBrokerDeserializer() {
        }

        public SimpleBroker deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            double maximumRate = jsonObject.get("maximumRate").getAsDouble();
            double minimumRate = jsonObject.get("minimumRate").getAsDouble();
            double rate = jsonObject.get("rate").getAsDouble();
            return new SimpleBroker(maximumRate, minimumRate, rate);
        }
    }

    private static class Status {
        public final String message;
        public final Icon icon;

        private Status(String message, Icon icon) {
            if (message == null || icon == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.message = message;
            this.icon = icon;
        }

        public static Status newInstance(String message, Icon icon) {
            return new Status(message, icon);
        }
    }
}

