/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import au.com.bytecode.opencsv.CSVReader;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.OkHttpClient;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.BrazilYahooStockServerFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.CodeBucketLists;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.DispType;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Factories;
import org.yccheok.jstock.engine.GoogleCodeSQLiteOpenHelper;
import org.yccheok.jstock.engine.GoogleStockServerFactory;
import org.yccheok.jstock.engine.IEXApi;
import org.yccheok.jstock.engine.IEXStockInfoSQLiteOpenHelper;
import org.yccheok.jstock.engine.IEXStockServerFactory;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.engine.Period;
import org.yccheok.jstock.engine.PriceSource;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockNameDatabase;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.UnitedStatesGoogleFormatCodeLookup;
import org.yccheok.jstock.engine.YahooFinanceApi;
import org.yccheok.jstock.engine.YahooFinanceApiV8;
import org.yccheok.jstock.engine.YahooStockServerFactory;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.network.Utils;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Utils {
    private static final Map<Country, List<Index>> country2Indices;
    private static final String iexEncryptedToken = "jEdhEIilpOrTRQjzd8HQ6CjShokM6t7vJ6gsJMIMFuHvT7vhSmPOxdX56A3fXliu";
    private static String cachedIEXToken;
    private static final String obfuscatedIEXToken_android = "=gDO1gTOyITM0MDO1MzN4EmZwcDNkNmNkJjMmVjNzUjZftGc";
    private static String cachedIEXToken_android;
    private static final Map<String, Country> countries;
    private static final Map<String, Country> indices;
    private static final Map<String, String> toGoogleIndex;
    private static final Map<Country, PriceSource> defaultPriceSources;
    private static final Map<Class<? extends StockServerFactory>, PriceSource> classToPriceSourceMap;
    private static final Map<String, Integer> googleUnitedStatesStockExchanges;
    private static final Map<String, String> oneLetterSuffixes;
    private static final Map<String, String> twoLetterSuffixes;
    private static final List<String> googleSupportedExchs;
    private static final Map<String, String> googleExchToYahooSuffix;
    private static final Map<Country, TimeZone> betterLocalTimeZones;
    private static final Map<Country, TimeZone> localTimeZones;
    private static final double EPSILON = 1.0E-8;
    private static final int IEX_US_CLASS_SHARE_CACHE_OPTIMAL_SIZE = 512;
    private static final Map<String, Boolean> iexUSClassShareCache;
    private static final int GOOGLE_CODE_DATABASE_CACHE_OPTIMAL_SIZE = 128;
    private static final Map<String, String> googleCodeDatabaseCache;
    private static final Gson gson;
    private static final Log log;

    private Utils() {
    }

    public static boolean essentiallyEqual(double a, double b) {
        return Math.abs(a - b) <= (Math.abs(a) > Math.abs(b) ? Math.abs(b) : Math.abs(a)) * 1.0E-8;
    }

    public static YahooFinanceApi getYahooFinanceApi() {
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(org.yccheok.jstock.network.Utils.getURL(Utils.Type.YAHOO_FINANCE_API)).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        String proxyServer = jStockOptions.getProxyServer();
        int proxyPort = jStockOptions.getProxyPort();
        if (!org.yccheok.jstock.gui.Utils.isNullOrEmpty(proxyServer) && Utils.isValidPortNumber(proxyPort)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyServer, proxyPort));
            OkHttpClient client = new OkHttpClient.Builder().proxy(proxy).build();
            builder.client(client);
        }
        Retrofit retrofit = builder.build();
        YahooFinanceApi yahooFinanceApi = (YahooFinanceApi)retrofit.create(YahooFinanceApi.class);
        return yahooFinanceApi;
    }

    public static YahooFinanceApiV8 getYahooFinanceChartApiV8() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(org.yccheok.jstock.network.Utils.getURL(Utils.Type.YAHOO_FINANCE_CHART_API_V8)).client(builder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        YahooFinanceApiV8 yahooFinanceApiV8 = (YahooFinanceApiV8)retrofit.create(YahooFinanceApiV8.class);
        return yahooFinanceApiV8;
    }

    public static IEXApi getIEXApi() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(org.yccheok.jstock.network.Utils.getURL(Utils.Type.IEX_API)).client(builder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        IEXApi iexApi = (IEXApi)retrofit.create(IEXApi.class);
        return iexApi;
    }

    public static Stock getEmptyStock(StockInfo stockInfo) {
        return Utils.getEmptyStock(stockInfo.code, stockInfo.symbol);
    }

    public static Stock getEmptyStock(Code code, Symbol symbol) {
        return new Stock(code, symbol, "", null, Board.Unknown, Industry.Unknown, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0.0, 0.0, 0, 0.0, 0, 0.0, 0, System.currentTimeMillis());
    }

    public static Stock getStock(Code code) {
        ArrayList<Code> codes = new ArrayList<Code>();
        codes.add(code);
        List<Stock> stocks = Utils.getStocks(codes, new GetStocksCallback(){

            @Override
            public void update(List<Stock> stocks) {
            }
        });
        if (stocks.size() == 1) {
            return stocks.get(0);
        }
        return null;
    }

    public static List<Code> getZeroPriceCodes(List<Code> inputs, List<Stock> outputs, List<Stock> nonZeroPriceStocks, Set<Code> nonZeroPriceCodes) {
        assert (inputs != null);
        assert (outputs != null);
        assert (nonZeroPriceStocks != null);
        assert (nonZeroPriceCodes != null);
        for (Stock stock : outputs) {
            if (nonZeroPriceCodes.contains(stock.code) || !(stock.getLastPrice() > 0.0) && !(stock.getOpenPrice() > 0.0)) continue;
            nonZeroPriceCodes.add(stock.code);
            nonZeroPriceStocks.add(stock);
        }
        ArrayList<Code> zeroPriceCodes = new ArrayList<Code>();
        for (Code input : inputs) {
            if (nonZeroPriceCodes.contains(input)) continue;
            zeroPriceCodes.add(input);
        }
        return zeroPriceCodes;
    }

    public static List<Stock> getStocks(List<Code> codes, GetStocksCallback getStockCallback) {
        ArrayList<Stock> s = new ArrayList<Stock>();
        HashSet<Code> nonZeroPriceCodes = new HashSet<Code>();
        CodeBucketLists codeBucketLists = new CodeBucketLists(20);
        for (Code code : codes) {
            codeBucketLists.add(code);
        }
        int size = codeBucketLists.size();
        for (int i = 0; i < size; ++i) {
            List<Stock> tmpStocks;
            StockServerFactory factory;
            StockServer stockServer;
            List<Code> _codes;
            List<Code> zeroPriceCodes = _codes = codeBucketLists.get(i);
            ArrayList<Stock> stocks = new ArrayList<Stock>();
            List<StockServerFactory> stockServerFactories = Factories.INSTANCE.getStockServerFactories(zeroPriceCodes.get(0));
            int stockServerFactorySize = stockServerFactories.size();
            for (int stockServerFactoryIndex = 0; !(stockServerFactoryIndex >= stockServerFactorySize || (stockServer = (factory = stockServerFactories.get(stockServerFactoryIndex)).getStockServer()) != null && (zeroPriceCodes = Utils.getZeroPriceCodes(zeroPriceCodes, tmpStocks = stockServer.getStocks(zeroPriceCodes), stocks, nonZeroPriceCodes)).isEmpty()); ++stockServerFactoryIndex) {
            }
            if (stocks.isEmpty()) continue;
            if (getStockCallback != null) {
                getStockCallback.update(stocks);
            }
            s.addAll(stocks);
        }
        if (s.isEmpty() && getStockCallback != null) {
            getStockCallback.update(s);
        }
        return s;
    }

    public static Country toCountry(Code code) {
        assert (countries.keySet().size() == 51);
        String string = code.toString();
        int index = string.lastIndexOf(".");
        if (index == -1) {
            if (Utils.isYahooIndexSubset(code) || Utils.isGoogleIndexSubset(code)) {
                Country country = indices.get(string.toUpperCase());
                if (country == null) {
                    return Country.UnitedState;
                }
                return country;
            }
            return Country.UnitedState;
        }
        String key = string.substring(index + 1, string.length());
        Country country = countries.get(key.toUpperCase());
        if (country == null) {
            return Country.UnitedState;
        }
        return country;
    }

    public static DispType rectifyDisp(DispType result) {
        String symbolStr = result.getDispCode();
        String nameStr = result.getDispName();
        if (symbolStr == null) {
            return null;
        }
        if (symbolStr.trim().isEmpty()) {
            return null;
        }
        symbolStr = symbolStr.trim().toUpperCase();
        if (nameStr == null) {
            nameStr = symbolStr;
        }
        if (nameStr.trim().isEmpty()) {
            nameStr = symbolStr;
        }
        nameStr = nameStr.trim();
        return new ResultType(symbolStr, nameStr);
    }

    public static void setHttpClientProxyFromSystemProperties(HttpClient httpClient) {
        String httpproxyHost = System.getProperties().getProperty("http.proxyHost");
        String httpproxyPort = System.getProperties().getProperty("http.proxyPort");
        if (null == httpproxyHost || null == httpproxyPort) {
            HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
            hostConfiguration.setProxyHost(null);
        } else {
            int port = -1;
            try {
                port = Integer.parseInt(httpproxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (Utils.isValidPortNumber(port)) {
                HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
                hostConfiguration.setProxy(httpproxyHost, port);
            } else {
                HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
                hostConfiguration.setProxyHost(null);
            }
        }
    }

    public static long getDifferenceInDays(long timeInMillis0, long timeInMillis1) {
        long diffMillis = Math.abs(timeInMillis0 - timeInMillis1);
        long diffDays = diffMillis / 86400000L;
        return diffDays;
    }

    public static long getDifferenceInDays(Date date0, Date date1) {
        return Utils.getDifferenceInDays(date0.getTime(), date1.getTime());
    }

    public static long getDifferenceInDays(Calendar calendar0, Calendar calendar1) {
        return Utils.getDifferenceInDays(calendar0.getTimeInMillis(), calendar1.getTimeInMillis());
    }

    public static void resetCalendarTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static boolean isValidPortNumber(int portNumber) {
        return portNumber >= 0 && portNumber <= 65534;
    }

    public static boolean isValidPortNumber(String portNumber) {
        int port = -1;
        try {
            port = Integer.parseInt(portNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Utils.isValidPortNumber(port);
    }

    public static String getStockInfoDatabaseFileDirectory(Country country) {
        return org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator;
    }

    public static File getStockInfoDatabaseFile(Country country) {
        return new File(Utils.getStockInfoDatabaseFileDirectory(country) + "stock-info-database.csv");
    }

    public static String getStocksCSVZipFileLocation(Country country) {
        return org.yccheok.jstock.network.Utils.getJStockStaticServer() + "stocks_information/" + country.toString().toLowerCase() + "/stocks.zip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Stock> getStocksFromCSVFile(File file) {
        CSVReader csvreader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        ArrayList<Stock> stocks;
        block40: {
            block41: {
                ArrayList<Stock> index2;
                block38: {
                    block39: {
                        ArrayList<Stock> arrayList;
                        block36: {
                            block37: {
                                stocks = new ArrayList<Stock>();
                                fileInputStream = null;
                                inputStreamReader = null;
                                csvreader = null;
                                try {
                                    String[] nextLine;
                                    fileInputStream = new FileInputStream(file);
                                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
                                    csvreader = new CSVReader((Reader)inputStreamReader);
                                    String[] types = csvreader.readNext();
                                    if (types == null) {
                                        arrayList = stocks;
                                        if (csvreader == null) break block36;
                                        break block37;
                                    }
                                    int code_index = -1;
                                    int symbol_index = -1;
                                    int name_index = -1;
                                    int board_index = -1;
                                    int industry_index = -1;
                                    boolean success_index = false;
                                    for (int index2 = 0; index2 < types.length; ++index2) {
                                        String type = types[index2];
                                        if (0 == type.compareToIgnoreCase("code")) {
                                            code_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("symbol")) {
                                            symbol_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("name")) {
                                            name_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("board")) {
                                            board_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("industry")) {
                                            industry_index = index2;
                                        }
                                        if (code_index != -1 && symbol_index != -1 && name_index != -1 && board_index != -1 && industry_index != -1) break;
                                    }
                                    boolean bl = success_index = code_index != -1 && symbol_index != -1;
                                    if (!success_index) {
                                        index2 = stocks;
                                        if (csvreader == null) break block38;
                                        break block39;
                                    }
                                    while ((nextLine = csvreader.readNext()) != null) {
                                        Industry industry;
                                        Board board;
                                        if (nextLine.length != types.length) {
                                            log.error((Object)("Incorrect CSV format. There should be exactly " + types.length + " item(s)"));
                                            continue;
                                        }
                                        String code = nextLine[code_index];
                                        String symbol = nextLine[symbol_index];
                                        String name = name_index == -1 ? "" : nextLine[name_index];
                                        String _board = board_index == -1 ? "Unknown" : nextLine[board_index];
                                        String _industry = industry_index == -1 ? "Unknown" : nextLine[industry_index];
                                        try {
                                            board = Board.valueOf(_board);
                                        }
                                        catch (IllegalArgumentException exp) {
                                            log.error(null, (Throwable)exp);
                                            board = Board.Unknown;
                                        }
                                        try {
                                            industry = Industry.valueOf(_industry);
                                        }
                                        catch (IllegalArgumentException exp) {
                                            log.error(null, (Throwable)exp);
                                            industry = Industry.Unknown;
                                        }
                                        Stock stock = Stock.builder(Code.newInstance(code), Symbol.newInstance(symbol)).name(name).board(board).industry(industry).build();
                                        stocks.add(stock);
                                    }
                                    if (csvreader == null) break block40;
                                    break block41;
                                }
                                catch (IOException ex) {
                                    log.error(null, (Throwable)ex);
                                    return stocks;
                                }
                            }
                            try {
                                csvreader.close();
                            }
                            catch (IOException ex) {
                                log.error(null, (Throwable)ex);
                            }
                        }
                        org.yccheok.jstock.file.Utils.close(inputStreamReader);
                        org.yccheok.jstock.file.Utils.close(fileInputStream);
                        return arrayList;
                    }
                    try {
                        csvreader.close();
                    }
                    catch (IOException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                org.yccheok.jstock.file.Utils.close(inputStreamReader);
                org.yccheok.jstock.file.Utils.close(fileInputStream);
                return index2;
            }
            try {
                csvreader.close();
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        org.yccheok.jstock.file.Utils.close(inputStreamReader);
        org.yccheok.jstock.file.Utils.close(fileInputStream);
        return stocks;
        finally {
            if (csvreader != null) {
                try {
                    csvreader.close();
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            org.yccheok.jstock.file.Utils.close(inputStreamReader);
            org.yccheok.jstock.file.Utils.close(fileInputStream);
        }
    }

    public static Pair<StockInfoDatabase, StockNameDatabase> toStockDatabase(List<Stock> stocks, Country country) {
        assert (!stocks.isEmpty());
        StockInfoDatabase tmp_stock_info_database = new StockInfoDatabase(stocks);
        StockNameDatabase tmp_name_database = null;
        if (Utils.isNameImmutable(country)) {
            tmp_name_database = new StockNameDatabase(stocks);
        }
        return Pair.create(tmp_stock_info_database, tmp_name_database);
    }

    public static boolean migrateXMLToCSVDatabases(String srcBaseDirectory, String destBaseDirectory) {
        boolean result = true;
        for (Country country : Country.values()) {
            File userDefinedDatabaseXMLFile = new File(srcBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.xml");
            File userDefinedDatabaseCSVFile = new File(destBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
            List pairs = org.yccheok.jstock.gui.Utils.fromXML(List.class, userDefinedDatabaseXMLFile);
            if (pairs != null && !pairs.isEmpty()) {
                Statements statements = Statements.newInstanceFromUserDefinedDatabase(pairs);
                boolean r = statements.saveAsCSVFile(userDefinedDatabaseCSVFile);
                if (r) {
                    userDefinedDatabaseXMLFile.delete();
                }
                result = r & result;
            } else {
                userDefinedDatabaseXMLFile.delete();
            }
            new File(srcBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.xml").delete();
            new File(destBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-info-database.xml").delete();
            new File(destBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "stockcodeandsymboldatabase.xml").delete();
        }
        return result;
    }

    public static String toUniversalFormat(String string) {
        if (string.endsWith(".NS")) {
            return string.substring(0, string.length() - 1);
        }
        if (string.endsWith(".BO")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static Code toYahooFormatCode(Code code) {
        return Code.newInstance(Utils.toYahooFormat(code));
    }

    private static boolean isIEXUSClassShare(Code code) {
        String codeString = code.toString();
        int beginIndex = codeString.length() - 2;
        if (beginIndex < 0) {
            return false;
        }
        String replacedCodeSubString = codeString.substring(beginIndex).replaceAll("-", ".");
        if (!(replacedCodeSubString.equals(".A") || replacedCodeSubString.equals(".B") || replacedCodeSubString.equals(".C"))) {
            return false;
        }
        String replacedCodeString = codeString.replaceAll("-", ".");
        Boolean result = iexUSClassShareCache.get(replacedCodeString);
        if (result != null) {
            return result;
        }
        result = IEXStockInfoSQLiteOpenHelper.INSTANCE.find(replacedCodeString);
        if (result == null) {
            return false;
        }
        if (iexUSClassShareCache.size() < 512) {
            iexUSClassShareCache.put(replacedCodeString, result);
        }
        return result;
    }

    public static String toYahooFormat(Code code) {
        String codeString = code.toString();
        if (codeString.endsWith(".N")) {
            return codeString + "S";
        }
        if (codeString.endsWith(".B")) {
            if (Character.isDigit(codeString.charAt(0))) {
                return codeString + "O";
            }
            if (Utils.isIEXUSClassShare(code)) {
                return codeString.replaceAll("\\.", "-");
            }
            return codeString + "O";
        }
        if (Utils.isIEXUSClassShare(code)) {
            return codeString.replaceAll("\\.", "-");
        }
        if (codeString.endsWith("*")) {
            codeString = codeString.substring(0, codeString.length() - 1);
        }
        return codeString.replaceAll("(\\S+-)(\\S?$)", "$1P$2");
    }

    public static Code toIEXFormatCode(Code code) {
        return Code.newInstance(Utils.toIEXFormat(code));
    }

    public static String toIEXFormat(Code code) {
        String originalCodeString = code.toString();
        String replacedCodeString = originalCodeString.replaceAll("(\\S+-)P(\\S?$)", "$1$2");
        if (!replacedCodeString.equals(originalCodeString)) {
            return replacedCodeString;
        }
        if (Utils.isIEXUSClassShare(code)) {
            return originalCodeString.replaceAll("-", ".");
        }
        return originalCodeString;
    }

    public static boolean needToResolveUnderlyingCode(Code code) {
        String string = code.toString();
        return string.endsWith(".B") & Character.isDigit(string.charAt(0));
    }

    public static String toGoogleFormat(Code code) {
        String googleFormat;
        String suffix;
        String prefix;
        String googleFormat2;
        String s = Utils.toGoogleIndex(code);
        if (s != null) {
            return s;
        }
        if (Utils.isYahooCurrency(code)) {
            return Utils.toGoogleCurrency(code);
        }
        String string = code.toString().trim().toUpperCase();
        Country country = Utils.toCountry(code);
        if (Utils.isGoogleCodeDatabaseRequired(country)) {
            googleFormat2 = googleCodeDatabaseCache.get(string);
            if (googleFormat2 == null) {
                Long l = JStock.instance().getJStockOptions().getGoogleCodeDatabaseMetaTimestamp(country);
                if (l != null && l > 0L && (googleFormat2 = GoogleCodeSQLiteOpenHelper.INSTANCE.find(country, string)) != null) {
                    if (googleCodeDatabaseCache.size() < 128) {
                        googleCodeDatabaseCache.put(string, googleFormat2);
                    }
                    return googleFormat2;
                }
            } else {
                return googleFormat2;
            }
        }
        if (country == Country.UnitedState) {
            googleFormat2 = UnitedStatesGoogleFormatCodeLookup.INSTANCE.get(code);
            if (googleFormat2 != null) {
                return googleFormat2;
            }
            return string.replaceAll("-", ".");
        }
        int string_length = string.length();
        if (string_length > 3 && (prefix = twoLetterSuffixes.get(suffix = string.substring(string_length - 3, string_length))) != null) {
            return prefix + string.substring(0, string_length - 3);
        }
        if (string_length > 2 && (prefix = oneLetterSuffixes.get(suffix = string.substring(string_length - 2, string_length))) != null) {
            return prefix + string.substring(0, string_length - 2);
        }
        if (string_length > ".NS".length() && string.endsWith(".NS") && (googleFormat = Utils.toGoogleFormatThroughAutoComplete(string = string.substring(0, string_length - ".NS".length()), "NSE")) != null) {
            return "NSE:" + googleFormat;
        }
        return string;
    }

    private static boolean isGoogleIndexSubset(Code code) {
        String string = code.toString();
        int index = string.indexOf(58);
        return index > 0 && index < string.length() - 1;
    }

    private static boolean isYahooIndexSubset(Code code) {
        return code.toString().startsWith("^");
    }

    public static boolean isUSStock(Code code) {
        return Utils.toCountry(code) == Country.UnitedState && !Utils.isYahooCurrency(code) && !Utils.isYahooIndexSubset(code) && !Utils.isGoogleIndexSubset(code);
    }

    public static boolean isYahooCurrency(Code code) {
        return code.toString().toUpperCase().endsWith("=X");
    }

    private static String toGoogleIndex(Code code) {
        String string = code.toString().trim().toUpperCase();
        String googleIndex = toGoogleIndex.get(string);
        if (googleIndex != null) {
            return googleIndex;
        }
        return null;
    }

    private static String toGoogleCurrency(Code code) {
        String string = code.toString().trim().toUpperCase();
        int index = string.indexOf("=X");
        if (index > 0) {
            return "CURRENCY:" + string.substring(0, index);
        }
        return string;
    }

    public static String toGoogleFormatThroughAutoComplete(String code, String exchange) {
        StringBuilder builder = new StringBuilder("https://www.google.com/finance/match?matchtype=matchall&q=");
        try {
            builder.append(URLEncoder.encode(code, "UTF-8"));
            String location = builder.toString();
            String _respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
            if (_respond == null) {
                return null;
            }
            String respond = Utils.GoogleRespondToJSON(_respond);
            List jsonArray = (List)gson.fromJson(respond, List.class);
            if (jsonArray == null) {
                return null;
            }
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                Map jsonObject = (Map)jsonArray.get(i);
                if (!jsonObject.containsKey("e") || !((String)jsonObject.get("e")).equalsIgnoreCase(exchange) || !jsonObject.containsKey("t")) continue;
                return (String)jsonObject.get("t");
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        return null;
    }

    public static boolean isGoogleCodeDatabaseRequired(Country country) {
        return country == Country.Malaysia;
    }

    public static boolean isPinyinTSTSearchEngineRequiredForSymbol() {
        Country country = JStock.instance().getJStockOptions().getCountry();
        return country == Country.China || country == Country.Taiwan;
    }

    public static boolean isSymbolImmutable() {
        Country country = JStock.instance().getJStockOptions().getCountry();
        return country == Country.China || country == Country.Taiwan;
    }

    public static boolean isNameImmutable() {
        Country country = JStock.instance().getJStockOptions().getCountry();
        return Utils.isNameImmutable(country);
    }

    private static boolean isNameImmutable(Country country) {
        return country == Country.China || country == Country.Taiwan;
    }

    public static boolean isFallBelowAndRiseAboveColorReverse() {
        Country country = JStock.instance().getJStockOptions().getCountry();
        return country == Country.China || country == Country.Taiwan;
    }

    public static List<Index> getStockIndices(Country country) {
        List<Index> indices = country2Indices.get((Object)country);
        if (indices != null) {
            return Collections.unmodifiableList(indices);
        }
        return Collections.emptyList();
    }

    public static String GoogleRespondToJSON(String respond) {
        int beginIndex = respond.indexOf("[");
        int endIndex = respond.lastIndexOf("]");
        if (beginIndex < 0) {
            return "";
        }
        if (beginIndex > endIndex) {
            return "";
        }
        String string = respond.substring(beginIndex, endIndex + 1);
        string = string.replaceAll("%", "%25");
        try {
            string = URLDecoder.decode(string.replace("\\x", "%"), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
        }
        return string;
    }

    public static String YahooRespondToJSON(String respond) {
        int beginIndex = respond.indexOf("{");
        int endIndex = respond.lastIndexOf("}");
        if (beginIndex < 0) {
            return "";
        }
        if (beginIndex > endIndex) {
            return "";
        }
        return respond.substring(beginIndex, endIndex + 1);
    }

    public static double parseDouble(String value) {
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value.replace(",", "").replace("%", ""));
        }
        catch (NumberFormatException ex) {
            log.error(null, (Throwable)ex);
            return 0.0;
        }
    }

    public static long parseLong(String value) {
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value.replace(",", "").replace("%", ""));
        }
        catch (NumberFormatException ex) {
            log.error(null, (Throwable)ex);
            return 0L;
        }
    }

    public static int getGoogleUnitedStatesStockExchangePriority(String e) {
        Integer priority = googleUnitedStatesStockExchanges.get(e);
        if (priority == null) {
            return Integer.MAX_VALUE;
        }
        return priority;
    }

    public static String toCompleteUnitedStatesGoogleFormat(Code code) {
        if (!Utils.isUSStock(code)) {
            return null;
        }
        String googleFormat = Utils.toGoogleFormat(code);
        if (googleFormat.contains(":")) {
            return googleFormat;
        }
        String[] exchanges = new String[]{"NYSE:", "NASDAQ:", "NYSEARCA:", "NYSEMKT:", "OPRA:", "OTCBB:", "OTCMKTS:"};
        StringBuilder builder = new StringBuilder("https://www.google.com/finance/info?infotype=infoquoteall&q=");
        try {
            builder.append(URLEncoder.encode(exchanges[0] + code, "UTF-8"));
            int ei = exchanges.length;
            for (int i = 1; i < ei; ++i) {
                builder.append(",");
                builder.append(URLEncoder.encode(exchanges[i] + code, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        String location = builder.toString();
        String _respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
        if (_respond == null) {
            return null;
        }
        String respond = Utils.GoogleRespondToJSON(_respond);
        List jsonArray = null;
        try {
            jsonArray = (List)gson.fromJson(respond, List.class);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (Map jsonObject : jsonArray) {
            try {
                String ticker = ((String)jsonObject.get("t")).toUpperCase();
                String exchange = ((String)jsonObject.get("e")).toUpperCase();
                pairs.add(Pair.create(ticker, exchange));
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if (pairs.isEmpty()) {
            return null;
        }
        Collections.sort(pairs, new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> o0, Pair<String, String> o1) {
                String e0 = (String)o0.second;
                String e1 = (String)o1.second;
                return Integer.compare(Utils.getGoogleUnitedStatesStockExchangePriority(e0), Utils.getGoogleUnitedStatesStockExchangePriority(e1));
            }
        });
        Pair pair = (Pair)pairs.get(0);
        String result = (String)pair.second + ":" + (String)pair.first;
        UnitedStatesGoogleFormatCodeLookup.INSTANCE.put(code, result);
        return result;
    }

    public static boolean isGoogleUnitedStatesStockExchange(String e) {
        return googleUnitedStatesStockExchanges.containsKey(e);
    }

    public static PriceSource getDefaultPriceSource(Country country) {
        assert (defaultPriceSources.containsKey((Object)country));
        return defaultPriceSources.get((Object)country);
    }

    public static Set<PriceSource> getSupportedPriceSources(Country country) {
        List<StockServerFactory> stockServerFactories = Factories.INSTANCE.getStockServerFactories(country);
        EnumSet<PriceSource> set = EnumSet.noneOf(PriceSource.class);
        for (StockServerFactory stockServerFactory : stockServerFactories) {
            PriceSource priceSource = classToPriceSourceMap.get(stockServerFactory.getClass());
            if (priceSource == null) continue;
            set.add(priceSource);
        }
        return set;
    }

    public static String toYahooSuffix(String googleExch) {
        return googleExchToYahooSuffix.get(googleExch);
    }

    public static List<String> getGoogleSupportedExchs() {
        return Collections.unmodifiableList(googleSupportedExchs);
    }

    public static void clearGoogleCodeDatabaseCache() {
        googleCodeDatabaseCache.clear();
    }

    public static void clearAllIEXStockInfoDatabaseCaches() {
        iexUSClassShareCache.clear();
    }

    public static TimeZone getTimeZone(Country country) {
        TimeZone betterTimeZone = betterLocalTimeZones.get((Object)country);
        assert (betterTimeZone != null);
        if (betterTimeZone.getRawOffset() == 0) {
            TimeZone timeZone = localTimeZones.get((Object)country);
            if (betterTimeZone.getRawOffset() == timeZone.getRawOffset()) {
                return betterTimeZone;
            }
            HashSet<String> set = new HashSet<String>(Arrays.asList(TimeZone.getAvailableIDs()));
            if (set.contains(betterTimeZone.getID())) {
                return betterTimeZone;
            }
            return timeZone;
        }
        return betterTimeZone;
    }

    public static Period toBestPeriod(Duration duration, TimeZone timeZone) {
        SimpleDate startDate = duration.getStartDate();
        Period[] periods = Period.values();
        for (int i = 0; i < periods.length; ++i) {
            Period period = periods[i];
            Calendar calendar = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
            calendar.add(period.calendar, -period.count);
            Utils.resetCalendarTime(calendar);
            long startTimestamp = timeZone != null ? startDate.getCalendar(timeZone).getTimeInMillis() : startDate.getCalendar().getTimeInMillis();
            if (calendar.getTimeInMillis() > startTimestamp) continue;
            if (i == periods.length - 1) {
                return period;
            }
            return periods[i + 1];
        }
        return Period.Years10;
    }

    public static String getIEXToken() {
        if (!org.yccheok.jstock.gui.Utils.isNullOrEmpty(cachedIEXToken)) {
            return cachedIEXToken;
        }
        cachedIEXToken = org.yccheok.jstock.gui.Utils.decrypt_android(iexEncryptedToken);
        return cachedIEXToken;
    }

    public static String getIEXToken_android() {
        if (!org.yccheok.jstock.gui.Utils.isNullOrEmpty(cachedIEXToken_android)) {
            return cachedIEXToken_android;
        }
        cachedIEXToken_android = Utils.deobfuscate(obfuscatedIEXToken_android);
        return cachedIEXToken_android;
    }

    public static String deobfuscate(String reverse) {
        if (reverse == null) {
            return null;
        }
        if (reverse.equals("")) {
            return "";
        }
        String encoded = new StringBuffer(reverse).reverse().toString();
        if (!org.yccheok.jstock.org.apache.commons.codec.binary.Base64.isBase64(encoded)) {
            return null;
        }
        try {
            byte[] input = Base64.getDecoder().decode(encoded);
            if (input == null || input.length == 0) {
                return null;
            }
            return new String(input, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            log.error(null, (Throwable)e);
            return null;
        }
    }

    static {
        String value;
        country2Indices = new EnumMap<Country, List<Index>>(Country.class);
        for (Index index : Index.values()) {
            List<Index> indices = country2Indices.get((Object)index.country);
            if (indices == null) {
                indices = new ArrayList<Index>();
                country2Indices.put(index.country, indices);
            }
            indices.add(index);
        }
        countries = new HashMap<String, Country>();
        indices = new HashMap<String, Country>();
        toGoogleIndex = new HashMap<String, String>();
        defaultPriceSources = new EnumMap<Country, PriceSource>(Country.class);
        classToPriceSourceMap = new HashMap<Class<? extends StockServerFactory>, PriceSource>();
        googleUnitedStatesStockExchanges = new HashMap<String, Integer>();
        oneLetterSuffixes = new HashMap<String, String>();
        twoLetterSuffixes = new HashMap<String, String>();
        googleSupportedExchs = new ArrayList<String>();
        googleExchToYahooSuffix = new HashMap<String, String>();
        betterLocalTimeZones = new EnumMap<Country, TimeZone>(Country.class);
        localTimeZones = new EnumMap<Country, TimeZone>(Country.class);
        oneLetterSuffixes.put(".F", "FRA:");
        oneLetterSuffixes.put(".N", "NSE:");
        oneLetterSuffixes.put(".B", "BOM:");
        oneLetterSuffixes.put(".L", "LON:");
        oneLetterSuffixes.put(".T", "TYO:");
        oneLetterSuffixes.put(".V", "CVE:");
        oneLetterSuffixes.put(".S", "TADAWUL:");
        twoLetterSuffixes.put(".DE", "ETR:");
        twoLetterSuffixes.put(".SS", "SHA:");
        twoLetterSuffixes.put(".SZ", "SHE:");
        twoLetterSuffixes.put(".SA", "BVMF:");
        twoLetterSuffixes.put(".VI", "VIE:");
        twoLetterSuffixes.put(".SI", "SGX:");
        twoLetterSuffixes.put(".TW", "TPE:");
        twoLetterSuffixes.put(".NZ", "NZE:");
        twoLetterSuffixes.put(".ST", "STO:");
        twoLetterSuffixes.put(".AX", "ASX:");
        twoLetterSuffixes.put(".BR", "EBR:");
        twoLetterSuffixes.put(".AS", "AMS:");
        twoLetterSuffixes.put(".CO", "CPH:");
        twoLetterSuffixes.put(".HK", "HKG:");
        twoLetterSuffixes.put(".CN", "CNSX:");
        twoLetterSuffixes.put(".TO", "TSE:");
        twoLetterSuffixes.put(".PA", "EPA:");
        twoLetterSuffixes.put(".TA", "TLV:");
        twoLetterSuffixes.put(".MI", "BIT:");
        twoLetterSuffixes.put(".KQ", "KOSDAQ:");
        twoLetterSuffixes.put(".KX", "KRX:");
        twoLetterSuffixes.put(".LS", "ELI:");
        twoLetterSuffixes.put(".BA", "BCBA:");
        twoLetterSuffixes.put(".HE", "HEL:");
        twoLetterSuffixes.put(".ME", "MCX:");
        twoLetterSuffixes.put(".ZA", "JSE:");
        twoLetterSuffixes.put(".TH", "BKK:");
        twoLetterSuffixes.put(".TR", "IST:");
        twoLetterSuffixes.put(".ES", "BME:");
        twoLetterSuffixes.put(".PL", "WSE:");
        twoLetterSuffixes.put(".JK", "IDX:");
        twoLetterSuffixes.put(".SW", "SWX:");
        twoLetterSuffixes.put(".VX", "VTX:");
        countries.put("BA", Country.Argentina);
        countries.put("AX", Country.Australia);
        countries.put("VI", Country.Austria);
        countries.put("BR", Country.Belgium);
        countries.put("SA", Country.Brazil);
        countries.put("CN", Country.Canada);
        countries.put("TO", Country.Canada);
        countries.put("V", Country.Canada);
        countries.put("SS", Country.China);
        countries.put("SZ", Country.China);
        countries.put("CO", Country.Denmark);
        countries.put("PA", Country.France);
        countries.put("HE", Country.Finland);
        countries.put("BE", Country.Germany);
        countries.put("DE", Country.Germany);
        countries.put("DU", Country.Germany);
        countries.put("EX", Country.Germany);
        countries.put("F", Country.Germany);
        countries.put("HA", Country.Germany);
        countries.put("HM", Country.Germany);
        countries.put("MU", Country.Germany);
        countries.put("SG", Country.Germany);
        countries.put("HK", Country.HongKong);
        countries.put("NS", Country.India);
        countries.put("N", Country.India);
        countries.put("B", Country.India);
        countries.put("JK", Country.Indonesia);
        countries.put("TA", Country.Israel);
        countries.put("MI", Country.Italy);
        countries.put("T", Country.Japan);
        countries.put("KQ", Country.Korea);
        countries.put("KS", Country.Korea);
        countries.put("KL", Country.Malaysia);
        countries.put("AS", Country.Netherlands);
        countries.put("NZ", Country.NewZealand);
        countries.put("OL", Country.Norway);
        countries.put("PL", Country.Poland);
        countries.put("LS", Country.Portugal);
        countries.put("ME", Country.Russia);
        countries.put("S", Country.SaudiArabia);
        countries.put("SI", Country.Singapore);
        countries.put("ZA", Country.SouthAfrica);
        countries.put("ES", Country.Spain);
        countries.put("ST", Country.Sweden);
        countries.put("SW", Country.Switzerland);
        countries.put("VX", Country.Switzerland);
        countries.put("TW", Country.Taiwan);
        countries.put("TWO", Country.Taiwan);
        countries.put("TH", Country.Thailand);
        countries.put("TR", Country.Turkey);
        countries.put("L", Country.UnitedKingdom);
        for (Index index : Index.values()) {
            indices.put(index.code.toString(), index.country);
        }
        toGoogleIndex.put("^DJI", "INDEXDJX:.DJI");
        toGoogleIndex.put("^IXIC", "INDEXNASDAQ:.IXIC");
        toGoogleIndex.put("^GSPC", "INDEXSP:.INX");
        toGoogleIndex.put("^BSESN", "INDEXBOM:SENSEX");
        toGoogleIndex.put("^NSEI", "NSE:NIFTY");
        toGoogleIndex.put("^NSEBANK", "NSE:BANKNIFTY");
        toGoogleIndex.put("^BVSP", "INDEXBVMF:IBOV");
        toGoogleIndex.put("^ATX", "INDEXVIE:ATX");
        toGoogleIndex.put("^FTSE", "INDEXFTSE:UKX");
        toGoogleIndex.put("^TWII", "TPE:TAIEX");
        toGoogleIndex.put("^NZ50", "NZE:NZ50G");
        toGoogleIndex.put("^OMX", "INDEXNASDAQ:OMXS30");
        toGoogleIndex.put("^AXJO", "INDEXASX:XJO");
        toGoogleIndex.put("^AORD", "INDEXASX:XAO");
        toGoogleIndex.put("^BFX", "INDEXEURO:BEL20");
        toGoogleIndex.put("^AEX", "INDEXEURO:AEX");
        toGoogleIndex.put("^OMXC20", "INDEXNASDAQ:OMXC20");
        toGoogleIndex.put("^N225", "INDEXNIKKEI:NI225");
        toGoogleIndex.put("^HSI", "INDEXHANGSENG:HSI");
        toGoogleIndex.put("^GSPTSE", "INDEXTSI:OSPTX");
        toGoogleIndex.put("^FCHI", "INDEXEURO:PX1");
        toGoogleIndex.put("^TA100", "TLV:TA100");
        toGoogleIndex.put("FTSEMIB.MI", "INDEXFTSE:FTSEMIB");
        toGoogleIndex.put("^KS11", "KRX:KOSPI");
        toGoogleIndex.put("PSI20.LS", "INDEXEURO:PSI20");
        toGoogleIndex.put("^MERV", "BCBA:IMV");
        toGoogleIndex.put("^OMXH25", "INDEXNASDAQ:OMXH25");
        toGoogleIndex.put("^MICEX", "MCX:MICEXINDEXCF");
        toGoogleIndex.put("^TASI", "TADAWUL:TASI");
        toGoogleIndex.put("^SET", "INDEXBKK:SET");
        toGoogleIndex.put("^XU100", "INDEXIST:XU100");
        toGoogleIndex.put("^IBEX", "INDEXBME:IB");
        toGoogleIndex.put("^JKSE", "IDX:COMPOSITE");
        toGoogleIndex.put("^SSMI", "INDEXSWX:SMI");
        defaultPriceSources.put(Country.Argentina, PriceSource.Google);
        defaultPriceSources.put(Country.Australia, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Austria, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Belgium, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Brazil, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Canada, PriceSource.Yahoo);
        defaultPriceSources.put(Country.China, PriceSource.Google);
        defaultPriceSources.put(Country.Czech, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Denmark, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Finland, PriceSource.Google);
        defaultPriceSources.put(Country.France, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Germany, PriceSource.Yahoo);
        defaultPriceSources.put(Country.HongKong, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Hungary, PriceSource.Yahoo);
        defaultPriceSources.put(Country.India, PriceSource.Google);
        defaultPriceSources.put(Country.Indonesia, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Israel, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Italy, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Japan, PriceSource.Google);
        defaultPriceSources.put(Country.Korea, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Malaysia, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Mexico, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Netherlands, PriceSource.Yahoo);
        defaultPriceSources.put(Country.NewZealand, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Norway, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Poland, PriceSource.Google);
        defaultPriceSources.put(Country.Portugal, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Russia, PriceSource.Google);
        defaultPriceSources.put(Country.SaudiArabia, PriceSource.Google);
        defaultPriceSources.put(Country.Singapore, PriceSource.Google);
        defaultPriceSources.put(Country.SouthAfrica, PriceSource.Google);
        defaultPriceSources.put(Country.Spain, PriceSource.Google);
        defaultPriceSources.put(Country.Sweden, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Switzerland, PriceSource.Yahoo);
        defaultPriceSources.put(Country.Taiwan, PriceSource.Google);
        defaultPriceSources.put(Country.Thailand, PriceSource.Google);
        defaultPriceSources.put(Country.Turkey, PriceSource.Google);
        defaultPriceSources.put(Country.UnitedKingdom, PriceSource.Google);
        defaultPriceSources.put(Country.UnitedState, PriceSource.Google);
        classToPriceSourceMap.put(GoogleStockServerFactory.class, PriceSource.Google);
        classToPriceSourceMap.put(YahooStockServerFactory.class, PriceSource.Yahoo);
        classToPriceSourceMap.put(BrazilYahooStockServerFactory.class, PriceSource.Yahoo);
        classToPriceSourceMap.put(IEXStockServerFactory.class, PriceSource.IEX);
        googleUnitedStatesStockExchanges.put("NYSE", 0);
        googleUnitedStatesStockExchanges.put("NASDAQ", 1);
        googleUnitedStatesStockExchanges.put("NYSEARCA", 2);
        googleUnitedStatesStockExchanges.put("NYSEMKT", 3);
        googleUnitedStatesStockExchanges.put("OPRA", 4);
        googleUnitedStatesStockExchanges.put("OTCBB", 5);
        googleUnitedStatesStockExchanges.put("OTCMKTS", 6);
        for (Map.Entry entry : oneLetterSuffixes.entrySet()) {
            String key = (String)entry.getKey();
            value = (String)entry.getValue();
            assert (key.startsWith("."));
            assert (value.endsWith(":"));
            key = key.substring(1, key.length());
            value = value.substring(0, value.length() - 1);
            assert (!googleExchToYahooSuffix.containsKey(value));
            assert (!googleExchToYahooSuffix.containsValue(key));
            assert (!googleSupportedExchs.contains(value));
            googleExchToYahooSuffix.put(value, key);
            googleSupportedExchs.add(value);
        }
        for (Map.Entry entry : twoLetterSuffixes.entrySet()) {
            String key = (String)entry.getKey();
            value = (String)entry.getValue();
            assert (key.startsWith("."));
            assert (value.endsWith(":"));
            key = key.substring(1, key.length());
            value = value.substring(0, value.length() - 1);
            assert (!googleExchToYahooSuffix.containsKey(value));
            assert (!googleExchToYahooSuffix.containsValue(key));
            assert (!googleSupportedExchs.contains(value));
            googleExchToYahooSuffix.put(value, key);
            googleSupportedExchs.add(value);
        }
        for (Map.Entry entry : googleUnitedStatesStockExchanges.entrySet()) {
            String key = (String)entry.getKey();
            assert (!googleSupportedExchs.contains(key));
            googleSupportedExchs.add(key);
        }
        betterLocalTimeZones.put(Country.Argentina, TimeZone.getTimeZone("America/Argentina/Buenos_Aires"));
        betterLocalTimeZones.put(Country.Australia, TimeZone.getTimeZone("Australia/Canberra"));
        betterLocalTimeZones.put(Country.Austria, TimeZone.getTimeZone("Europe/Vienna"));
        betterLocalTimeZones.put(Country.Belgium, TimeZone.getTimeZone("Europe/Brussels"));
        betterLocalTimeZones.put(Country.Brazil, TimeZone.getTimeZone("America/Sao_Paulo"));
        betterLocalTimeZones.put(Country.Canada, TimeZone.getTimeZone("America/Montreal"));
        betterLocalTimeZones.put(Country.China, TimeZone.getTimeZone("Asia/Shanghai"));
        betterLocalTimeZones.put(Country.Denmark, TimeZone.getTimeZone("Europe/Copenhagen"));
        betterLocalTimeZones.put(Country.Finland, TimeZone.getTimeZone("Europe/Helsinki"));
        betterLocalTimeZones.put(Country.France, TimeZone.getTimeZone("Europe/Paris"));
        betterLocalTimeZones.put(Country.Germany, TimeZone.getTimeZone("Europe/Berlin"));
        betterLocalTimeZones.put(Country.HongKong, TimeZone.getTimeZone("Asia/Hong_Kong"));
        betterLocalTimeZones.put(Country.India, TimeZone.getTimeZone("Asia/Calcutta"));
        betterLocalTimeZones.put(Country.Indonesia, TimeZone.getTimeZone("Asia/Jakarta"));
        betterLocalTimeZones.put(Country.Israel, TimeZone.getTimeZone("Asia/Jerusalem"));
        betterLocalTimeZones.put(Country.Italy, TimeZone.getTimeZone("Europe/Rome"));
        betterLocalTimeZones.put(Country.Japan, TimeZone.getTimeZone("Japan"));
        betterLocalTimeZones.put(Country.Korea, TimeZone.getTimeZone("Asia/Seoul"));
        betterLocalTimeZones.put(Country.Malaysia, TimeZone.getTimeZone("Asia/Kuala_Lumpur"));
        betterLocalTimeZones.put(Country.Netherlands, TimeZone.getTimeZone("Europe/Amsterdam"));
        betterLocalTimeZones.put(Country.NewZealand, TimeZone.getTimeZone("Pacific/Auckland"));
        betterLocalTimeZones.put(Country.Norway, TimeZone.getTimeZone("Europe/Oslo"));
        betterLocalTimeZones.put(Country.Poland, TimeZone.getTimeZone("Europe/Warsaw"));
        betterLocalTimeZones.put(Country.Portugal, TimeZone.getTimeZone("Europe/Lisbon"));
        betterLocalTimeZones.put(Country.Russia, TimeZone.getTimeZone("Europe/Moscow"));
        betterLocalTimeZones.put(Country.SaudiArabia, TimeZone.getTimeZone("Asia/Riyadh"));
        betterLocalTimeZones.put(Country.Singapore, TimeZone.getTimeZone("Asia/Singapore"));
        betterLocalTimeZones.put(Country.SouthAfrica, TimeZone.getTimeZone("Africa/Johannesburg"));
        betterLocalTimeZones.put(Country.Spain, TimeZone.getTimeZone("Europe/Madrid"));
        betterLocalTimeZones.put(Country.Sweden, TimeZone.getTimeZone("Europe/Stockholm"));
        betterLocalTimeZones.put(Country.Switzerland, TimeZone.getTimeZone("Europe/Zurich"));
        betterLocalTimeZones.put(Country.Taiwan, TimeZone.getTimeZone("Asia/Taipei"));
        betterLocalTimeZones.put(Country.Thailand, TimeZone.getTimeZone("Asia/Bangkok"));
        betterLocalTimeZones.put(Country.Turkey, TimeZone.getTimeZone("Turkey"));
        betterLocalTimeZones.put(Country.UnitedKingdom, TimeZone.getTimeZone("Europe/London"));
        betterLocalTimeZones.put(Country.UnitedState, TimeZone.getTimeZone("America/New_York"));
        localTimeZones.put(Country.Argentina, TimeZone.getTimeZone("GMT-3"));
        localTimeZones.put(Country.Australia, TimeZone.getTimeZone("GMT+10"));
        localTimeZones.put(Country.Austria, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Belgium, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Brazil, TimeZone.getTimeZone("GMT-3"));
        localTimeZones.put(Country.Canada, TimeZone.getTimeZone("GMT-5"));
        localTimeZones.put(Country.China, TimeZone.getTimeZone("GMT+8"));
        localTimeZones.put(Country.Denmark, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Finland, TimeZone.getTimeZone("GMT+2"));
        localTimeZones.put(Country.France, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Germany, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.HongKong, TimeZone.getTimeZone("GMT+8"));
        localTimeZones.put(Country.India, TimeZone.getTimeZone("GMT+5:30"));
        localTimeZones.put(Country.Indonesia, TimeZone.getTimeZone("GMT+7"));
        localTimeZones.put(Country.Israel, TimeZone.getTimeZone("GMT+2"));
        localTimeZones.put(Country.Italy, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Japan, TimeZone.getTimeZone("GMT+9"));
        localTimeZones.put(Country.Korea, TimeZone.getTimeZone("GMT+9"));
        localTimeZones.put(Country.Malaysia, TimeZone.getTimeZone("GMT+8"));
        localTimeZones.put(Country.Netherlands, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.NewZealand, TimeZone.getTimeZone("GMT+12"));
        localTimeZones.put(Country.Norway, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Poland, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Portugal, TimeZone.getTimeZone("GMT+0"));
        localTimeZones.put(Country.Russia, TimeZone.getTimeZone("GMT+3"));
        localTimeZones.put(Country.SaudiArabia, TimeZone.getTimeZone("GMT+3"));
        localTimeZones.put(Country.Singapore, TimeZone.getTimeZone("GMT+8"));
        localTimeZones.put(Country.SouthAfrica, TimeZone.getTimeZone("GMT+2"));
        localTimeZones.put(Country.Spain, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Sweden, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Switzerland, TimeZone.getTimeZone("GMT+1"));
        localTimeZones.put(Country.Taiwan, TimeZone.getTimeZone("GMT+8"));
        localTimeZones.put(Country.Thailand, TimeZone.getTimeZone("GMT+7"));
        localTimeZones.put(Country.Turkey, TimeZone.getTimeZone("GMT+2"));
        localTimeZones.put(Country.UnitedKingdom, TimeZone.getTimeZone("GMT+0"));
        localTimeZones.put(Country.UnitedState, TimeZone.getTimeZone("GMT-5"));
        assert (betterLocalTimeZones.size() == localTimeZones.size());
        iexUSClassShareCache = new ConcurrentHashMap<String, Boolean>();
        googleCodeDatabaseCache = new ConcurrentHashMap<String, String>();
        gson = new Gson();
        log = LogFactory.getLog(Utils.class);
    }

    public static interface GetStocksCallback {
        public void update(List<Stock> var1);
    }
}

