/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.IEXApi;
import org.yccheok.jstock.engine.IEXStockInfoSQLiteOpenHelper;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.iex.symbols.SymbolsResponse;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import retrofit2.Call;

public class IEXStockInfoDatabaseRunnable
implements Runnable {
    private static final long UPDATE_THRESHOLD = 86400000L;
    private static final String TAG = "IEXStockInfoDatabaseRun";
    private static final Log log = LogFactory.getLog(IEXStockInfoDatabaseRunnable.class);

    public static boolean needToBuild() {
        long latest = System.currentTimeMillis();
        long last = JStock.instance().getJStockOptions().getIEXStockInfoDBMeta();
        boolean needToBuild = false;
        needToBuild = last > latest ? true : (latest - last > 86400000L ? true : IEXStockInfoSQLiteOpenHelper.INSTANCE.isTableEmpty());
        return needToBuild;
    }

    @Override
    public void run() {
        boolean status;
        boolean needToBuild = IEXStockInfoDatabaseRunnable.needToBuild();
        if (needToBuild && (status = this.buildIEXStockInfoDatabase())) {
            JStockOptions jStockOptions = JStock.instance().getJStockOptions();
            long latest = System.currentTimeMillis();
            jStockOptions.setIEXStockInfoDBMeta(latest);
        }
    }

    private boolean buildIEXStockInfoDatabase() {
        List symbolsResponses = null;
        IEXApi api = Utils.getIEXApi();
        Call<List<SymbolsResponse>> symbolsCall = api.symbols(Utils.getIEXToken_android());
        try {
            symbolsResponses = (List)symbolsCall.execute().body();
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return false;
        }
        if (symbolsResponses == null || symbolsResponses.isEmpty()) {
            return false;
        }
        boolean result = IEXStockInfoSQLiteOpenHelper.INSTANCE.insert(symbolsResponses);
        if (result) {
            return IEXStockInfoSQLiteOpenHelper.INSTANCE.isTableExists();
        }
        return false;
    }
}

