/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.Utils;

public enum GoogleCodeSQLiteOpenHelper {
    INSTANCE;

    private Connection conn = null;
    private static final String COLUMN_YAHOO = "yahoo";
    private static final String COLUMN_GOOGLE = "google";
    private static final String UNIQUE_CONSTRAINT = "unique (yahoo) on conflict ignore";
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoogleCodeSQLiteOpenHelper() {
        try {
            String url = "jdbc:sqlite:" + Utils.getUserDataDirectory() + "stock_info.db";
            this.conn = DriverManager.getConnection(url);
        }
        catch (SQLException sQLException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    private String getTableName(Country country) {
        return "google_code_" + country.name().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists(Country country) {
        if (this.conn == null) {
            return false;
        }
        String sql = "select tbl_name from sqlite_master where tbl_name = ? limit 1";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement("select tbl_name from sqlite_master where tbl_name = ? limit 1");
            pstmt.setString(1, this.getTableName(country));
            rs = pstmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(Country country, List<Pair<String, String>> googleCodes) {
        if (this.conn == null) {
            return false;
        }
        String tableName = this.getTableName(country);
        Statement pstmt = null;
        try {
            this.conn.setAutoCommit(false);
            Statement stmt = this.conn.createStatement();
            stmt.execute("DROP TABLE IF EXISTS " + tableName);
            stmt.execute("create table if not exists " + tableName + "(" + COLUMN_YAHOO + " text not null, " + COLUMN_GOOGLE + " text not null, " + UNIQUE_CONSTRAINT + ");");
            stmt.execute("create index " + tableName + "_" + COLUMN_YAHOO + "_idx on " + tableName + "(" + COLUMN_YAHOO + ");");
            stmt.execute("create index " + tableName + "_" + COLUMN_GOOGLE + "_idx on " + tableName + "(" + COLUMN_GOOGLE + ");");
            for (Pair<String, String> googleCode : googleCodes) {
                pstmt = this.conn.prepareStatement("INSERT INTO " + tableName + "(" + COLUMN_YAHOO + ", " + COLUMN_GOOGLE + ") VALUES(?, ?);");
                pstmt.setString(1, (String)googleCode.first);
                pstmt.setString(2, (String)googleCode.second);
                long result = pstmt.executeUpdate();
                if (result == 1L) continue;
                boolean bl = false;
                return bl;
            }
            this.conn.commit();
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
            try {
                if (this.conn != null) {
                    this.conn.rollback();
                }
            }
            catch (SQLException e2) {
                log.error(null, (Throwable)e2);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String find(Country country, String yahoo) {
        if (this.conn == null) {
            return null;
        }
        String sql = "select google from " + this.getTableName(country) + " where yahoo = ? limit 1";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, yahoo);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String string = rs.getString(COLUMN_GOOGLE);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
            JStockOptions jStockOptions = JStock.instance().getJStockOptions();
            Long l = jStockOptions.getGoogleCodeDatabaseMetaTimestamp(country);
            if (l != null && l > 0L) {
                jStockOptions.setGoogleCodeDatabaseMetaTimestamp(country, 1L);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return null;
    }

    static {
        log = LogFactory.getLog(GoogleCodeSQLiteOpenHelper.class);
    }
}

