/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.yccheok.jstock.engine.BucketList;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Factories;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.engine.StockServerFactory;

public class CodeBucketLists {
    private final int maxBucketSize;
    private final Map<String, BucketList<Code>> bucketLists = new ConcurrentHashMap<String, BucketList<Code>>();
    private final List<String> bucketListsIndexMapping = new CopyOnWriteArrayList<String>();
    private final Map<String, Integer> basedIndexInfosIndexMapping = new ConcurrentHashMap<String, Integer>();
    private final List<Pair<String, Integer>> basedIndexInfos = new CopyOnWriteArrayList<Pair<String, Integer>>();
    private final ReadWriteLock readWriteLock;
    private final Lock readerLock;
    private final Lock writerLock;

    public CodeBucketLists(int maxBucketSize) {
        if (maxBucketSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxBucketSize = maxBucketSize;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readerLock = this.readWriteLock.readLock();
        this.writerLock = this.readWriteLock.writeLock();
    }

    public boolean isEmpty() {
        return this.bucketListsIndexMapping.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Code> get(int index) {
        this.readerLock.lock();
        try {
            int size = this.bucketListsIndexMapping.size();
            if (index >= size) {
                List<Code> list = Collections.emptyList();
                return list;
            }
            String id = this.bucketListsIndexMapping.get(index);
            Integer index2 = this.basedIndexInfosIndexMapping.get(id);
            Pair<String, Integer> info = this.basedIndexInfos.get(index2);
            BucketList<Code> bucketList = this.bucketLists.get(id);
            int basedIndex = (Integer)info.second;
            int i = index - basedIndex;
            List<Code> list = bucketList.get(i);
            return list;
        }
        finally {
            this.readerLock.unlock();
        }
    }

    public int size() {
        return this.bucketListsIndexMapping.size();
    }

    public synchronized boolean add(Code code) {
        int basedIndex;
        String id = this.getStockServerFactoriesId(code);
        BucketList<Code> bucketList = this.bucketLists.get(id);
        if (bucketList == null) {
            bucketList = new BucketList(this.maxBucketSize);
            this.bucketLists.put(id, bucketList);
        }
        int beforeSize = bucketList.size();
        boolean status = bucketList.add(code);
        if (!status) {
            return status;
        }
        int afterSize = bucketList.size();
        assert (afterSize >= 1);
        assert (afterSize >= beforeSize);
        if (afterSize == beforeSize) {
            return true;
        }
        Integer basedIndexInfosIndex = this.basedIndexInfosIndexMapping.get(id);
        if (basedIndexInfosIndex == null) {
            int basedIndexInfosSize = this.basedIndexInfos.size();
            this.basedIndexInfosIndexMapping.put(id, basedIndexInfosSize);
            if (basedIndexInfosSize == 0) {
                basedIndex = 0;
            } else {
                Pair<String, Integer> previousBasedIndexInfo = this.basedIndexInfos.get(basedIndexInfosSize - 1);
                BucketList<Code> previousBucketList = this.bucketLists.get(previousBasedIndexInfo.first);
                int previousBucketListSize = previousBucketList.size();
                basedIndex = (Integer)previousBasedIndexInfo.second + previousBucketListSize;
            }
            this.basedIndexInfos.add(Pair.create(id, basedIndex));
        } else {
            basedIndex = (Integer)this.basedIndexInfos.get((int)basedIndexInfosIndex.intValue()).second;
            int ei = this.basedIndexInfos.size();
            for (int i = basedIndexInfosIndex + 1; i < ei; ++i) {
                Pair<String, Integer> basedIndexInfo = this.basedIndexInfos.get(i);
                this.basedIndexInfos.set(i, Pair.create(basedIndexInfo.first, (Integer)basedIndexInfo.second + 1));
            }
        }
        this.bucketListsIndexMapping.add(basedIndex, id);
        return true;
    }

    public synchronized void clear() {
        this.writerLock.lock();
        try {
            this.bucketLists.clear();
            this.bucketListsIndexMapping.clear();
            this.basedIndexInfosIndexMapping.clear();
            this.basedIndexInfos.clear();
        }
        finally {
            this.writerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(Code code) {
        this.writerLock.lock();
        try {
            Pair<String, Integer> basedIndexInfo;
            int i;
            String id = this.getStockServerFactoriesId(code);
            BucketList<Code> bucketList = this.bucketLists.get(id);
            if (bucketList == null) {
                boolean bl = false;
                return bl;
            }
            int beforeSize = bucketList.size();
            boolean status = bucketList.remove(code);
            if (!status) {
                boolean bl = status;
                return bl;
            }
            int afterSize = bucketList.size();
            assert (afterSize >= 0);
            assert (afterSize <= beforeSize);
            if (afterSize == beforeSize) {
                boolean bl = true;
                return bl;
            }
            Integer basedIndexInfosIndex = this.basedIndexInfosIndexMapping.get(id);
            int basedIndex = (Integer)this.basedIndexInfos.get((int)basedIndexInfosIndex.intValue()).second;
            int ei = this.basedIndexInfos.size();
            for (i = basedIndexInfosIndex + 1; i < ei; ++i) {
                basedIndexInfo = this.basedIndexInfos.get(i);
                this.basedIndexInfos.set(i, Pair.create(basedIndexInfo.first, (Integer)basedIndexInfo.second - 1));
            }
            this.bucketListsIndexMapping.remove(basedIndex);
            if (afterSize == 0) {
                ei = this.basedIndexInfos.size();
                for (i = basedIndexInfosIndex + 1; i < ei; ++i) {
                    basedIndexInfo = this.basedIndexInfos.get(i);
                    String _id = (String)basedIndexInfo.first;
                    int index = this.basedIndexInfosIndexMapping.get(_id);
                    this.basedIndexInfosIndexMapping.put(_id, --index);
                }
                this.bucketLists.remove(id);
                int index = this.basedIndexInfosIndexMapping.remove(id);
                this.basedIndexInfos.remove(index);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writerLock.unlock();
        }
    }

    public synchronized void rebuild() {
        ArrayList<Code> codes = new ArrayList<Code>();
        int ei = this.size();
        for (int i = 0; i < ei; ++i) {
            codes.addAll(this.get(i));
        }
        this.clear();
        for (Code code : codes) {
            this.add(code);
        }
    }

    private String getStockServerFactoriesId(Code code) {
        List<StockServerFactory> stockServerFactories = Factories.INSTANCE.getStockServerFactories(code);
        StringBuilder stringBuilder = new StringBuilder();
        for (StockServerFactory stockServerFactory : stockServerFactories) {
            stringBuilder.append(stockServerFactory.getId());
        }
        return stringBuilder.toString();
    }
}

