/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.AbstractOperator;
import org.yccheok.jstock.analysis.DiodeOperator;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.analysis.Operator;
import org.yccheok.jstock.analysis.SinkOperator;
import org.yccheok.jstock.analysis.StockHistoryOperator;
import org.yccheok.jstock.analysis.StockOperator;
import org.yccheok.jstock.analysis.StockRelativeHistoryOperator;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockEx;
import org.yccheok.jstock.engine.StockHistoryServer;

public class OperatorIndicator
implements Indicator {
    private List<Operator> operators = new ArrayList<Operator>();
    private String name;
    private Stock stock;
    private volatile boolean stockHistoryCalculationDone = false;
    private long sharesIssued = -1L;
    private long marketCapital = -1L;
    private static final Log log = LogFactory.getLog(OperatorIndicator.class);

    public OperatorIndicator(String name) {
        this.name = name;
        this.stock = null;
    }

    public OperatorIndicator() {
        this("null");
    }

    public String toString() {
        return this.name;
    }

    public void add(Operator operator) {
        this.operators.add(operator);
        this.stockHistoryCalculationDone = false;
    }

    public Operator get(int index) {
        return this.operators.get(index);
    }

    public int size() {
        return this.operators.size();
    }

    @Override
    public Stock getStock() {
        return this.stock;
    }

    @Override
    public void setStock(Stock stock) {
        this.stock = this.sharesIssued == -1L || this.marketCapital == -1L ? stock : new StockEx(stock, this.marketCapital, this.sharesIssued);
        for (Operator operator : this.operators) {
            if (!(operator instanceof StockOperator)) continue;
            ((StockOperator)operator).setStock(stock);
        }
    }

    @Override
    public void setStockHistoryServer(StockHistoryServer stockHistoryServer) {
        for (Operator operator : this.operators) {
            if (operator instanceof StockHistoryOperator) {
                ((StockHistoryOperator)operator).calculate(stockHistoryServer);
                continue;
            }
            if (!(operator instanceof StockRelativeHistoryOperator)) continue;
            ((StockRelativeHistoryOperator)operator).calculate(stockHistoryServer);
        }
        this.stockHistoryCalculationDone = true;
        this.sharesIssued = stockHistoryServer.getSharesIssued();
        this.marketCapital = stockHistoryServer.getMarketCapital();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        int numOfSinkOperator = 0;
        AbstractOperator sinkOperator = null;
        for (Operator operator : this.operators) {
            if (!(operator instanceof SinkOperator)) continue;
            if (++numOfSinkOperator != 1) {
                return Type.InvalidIndicator;
            }
            sinkOperator = (SinkOperator)operator;
        }
        if (numOfSinkOperator == 1) {
            if (sinkOperator.getNumOfInputConnection() == 1 && sinkOperator.getNumOfOutputConnection() == 0) {
                return Type.AlertIndicator;
            }
            return Type.InvalidIndicator;
        }
        ArrayList<DiodeOperator> inputDiodeOperators = new ArrayList<DiodeOperator>();
        ArrayList<DiodeOperator> outputDiodeOperators = new ArrayList<DiodeOperator>();
        for (Operator operator : this.operators) {
            if (!(operator instanceof DiodeOperator)) continue;
            DiodeOperator diodeOperator = (DiodeOperator)operator;
            if (diodeOperator.getNumOfInputConnection() == 1 && diodeOperator.getNumOfOutputConnection() == 0) {
                outputDiodeOperators.add(diodeOperator);
                continue;
            }
            if (diodeOperator.getNumOfInputConnection() != 0 || diodeOperator.getNumOfOutputConnection() != 1) continue;
            inputDiodeOperators.add(diodeOperator);
        }
        if (inputDiodeOperators.size() >= 0 && outputDiodeOperators.size() == 1) {
            return Type.ModuleIndicator;
        }
        return Type.InvalidIndicator;
    }

    public void preCalculate() {
        for (Operator operator : this.operators) {
            operator.clear();
        }
        for (Operator operator : this.operators) {
            operator.pull();
        }
    }

    public boolean isStockNeeded() {
        for (Operator operator : this.operators) {
            if (!(operator instanceof StockOperator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStockHistoryServerNeeded() {
        for (Operator operator : this.operators) {
            if (!(operator instanceof StockHistoryOperator) && !(operator instanceof StockRelativeHistoryOperator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTriggered() {
        for (Operator operator : this.operators) {
            if (!(operator instanceof StockOperator)) continue;
            operator.pull();
        }
        for (Operator operator : this.operators) {
            if (!(operator instanceof SinkOperator)) continue;
            Object value = ((SinkOperator)operator).getValue();
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            log.error((Object)"Sink operator should return boolean result.");
        }
        return false;
    }

    @Override
    public Duration getNeededStockHistoryDuration() {
        if (!this.isStockHistoryServerNeeded()) {
            return Duration.getTodayDurationByDays(0);
        }
        Duration duration = Duration.getTodayDurationByDays(0);
        for (Operator operator : this.operators) {
            if (operator instanceof StockHistoryOperator) {
                StockHistoryOperator stockHistoryOperator = (StockHistoryOperator)operator;
                Date start = stockHistoryOperator.getStartDate();
                Date end = stockHistoryOperator.getEndDate();
                long d = new Duration(start, end).getDurationInDays();
                int days = stockHistoryOperator.getRequiredHistorySize((int)d);
                duration = duration.getUnionDuration(Duration.getDurationByDays(end, days));
                continue;
            }
            if (!(operator instanceof StockRelativeHistoryOperator)) continue;
            StockRelativeHistoryOperator stockRelativeHistoryOperator = (StockRelativeHistoryOperator)operator;
            int days = stockRelativeHistoryOperator.getRequiredHistorySize() + stockRelativeHistoryOperator.getSkipDay();
            duration = duration.getUnionDuration(Duration.getTodayDurationByDays(Math.max(3, days * 2)));
        }
        return duration.getUnionDuration(Duration.getTodayDurationByDays((int)duration.getDurationInDays() * 2));
    }

    @Override
    public boolean isStockHistoryCalculationDone() {
        if (!this.isStockHistoryServerNeeded()) {
            return true;
        }
        return this.stockHistoryCalculationDone;
    }

    public static enum Type {
        AlertIndicator,
        ModuleIndicator,
        InvalidIndicator;

    }
}

