/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui.timer;

import com.pomodorotechnique.client.ui.timer.TimerListener;
import com.pomodorotechnique.client.ui.timer.TimerState;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.UserType;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;

public class Timer {
    private TimerState state;
    private PomodoroType currentPomodoro;
    private Date stateEnterTime;
    private Date projectedFinishTime;
    private final UserType user;
    private final Set<TimerListener> listeners = new HashSet<TimerListener>();
    private java.util.Timer timer;
    private java.util.Timer tickTimer;
    public static final long TICK_PERIOD = 1000L;

    public Timer(UserType user) {
        this.user = user;
        this.toReadyState();
    }

    private synchronized void toReadyState() {
        if (this.tickTimer != null) {
            this.tickTimer.cancel();
            this.tickTimer = null;
        }
        this.state = TimerState.READY;
        this.stateEnterTime = new Date();
        this.timer = new java.util.Timer();
        this.tickTimer = new java.util.Timer();
        for (TimerListener l : this.listeners) {
            l.onReady();
        }
    }

    private synchronized void toRestState(boolean successfully) {
        this.state = TimerState.REST;
        this.stateEnterTime = new Date();
        this.projectedFinishTime = new Date(this.stateEnterTime.getTime() + (long)(this.user.getBreakLength() * 60 * 1000));
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UserType userType = Timer.this.user;
                synchronized (userType) {
                    Timer.this.toReadyState();
                }
            }
        }, this.projectedFinishTime);
        this.tickTimer.cancel();
        this.tickTimer = new java.util.Timer();
        this.tickTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UserType userType = Timer.this.user;
                synchronized (userType) {
                    Timer.this.tick();
                }
            }
        }, 0L, 1000L);
        for (TimerListener l : this.listeners) {
            l.onWorkCompleted(this.currentPomodoro, successfully);
        }
    }

    private synchronized void tick() {
        for (TimerListener l : this.listeners) {
            l.onTick();
        }
    }

    private synchronized void toBusyState(PomodoroType pomodoro) {
        this.state = TimerState.BUSY;
        this.stateEnterTime = new Date();
        this.currentPomodoro = pomodoro;
        this.projectedFinishTime = new Date(this.stateEnterTime.getTime() + (long)(this.user.getPomodoroLength() * 60 * 1000));
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UserType userType = Timer.this.user;
                synchronized (userType) {
                    Timer.this.toRestState(true);
                }
            }
        }, this.projectedFinishTime);
        this.tickTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UserType userType = Timer.this.user;
                synchronized (userType) {
                    Timer.this.tick();
                }
            }
        }, 0L, 1000L);
        for (TimerListener l : this.listeners) {
            l.onPomodoroStarted(pomodoro);
        }
    }

    public synchronized void voidCurrentPomodoro() {
        if (this.state != TimerState.BUSY) {
            throw new IllegalStateException("Must be in BUSY state to void Pomodoro");
        }
        this.timer.cancel();
        this.timer = null;
        this.tickTimer.cancel();
        this.tickTimer = null;
        this.toReadyState();
    }

    public synchronized void startPomodoro(PomodoroType pomodoro) {
        if (this.state != TimerState.READY) {
            throw new IllegalStateException("Must be in READY state to start Pomodoro");
        }
        this.toBusyState(pomodoro);
    }

    public synchronized boolean addListener(TimerListener listener) {
        return this.listeners.add(listener);
    }

    public synchronized boolean removeListener(TimerListener listener) {
        return this.listeners.remove(listener);
    }

    public synchronized TimerState getState() {
        return this.state;
    }

    public synchronized Date getStateEnterTime() {
        return this.stateEnterTime;
    }

    public synchronized UserType getUser() {
        return this.user;
    }

    public synchronized long getTimeLeft() {
        if (this.state != TimerState.READY) {
            return this.projectedFinishTime.getTime() - new Date().getTime();
        }
        throw new IllegalStateException("Timer must be started");
    }

    public synchronized Date getProjectedFinishTime() {
        if (this.state != TimerState.READY) {
            return this.projectedFinishTime;
        }
        throw new IllegalStateException("Timer must be started");
    }

    public synchronized PomodoroType getCurrentPomodoro() {
        if (this.state != TimerState.READY) {
            return this.currentPomodoro;
        }
        throw new IllegalStateException("Timer must be started");
    }
}

