/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.LoginWindow;
import com.pomodorotechnique.client.ui.PomodoroClientView;
import com.pomodorotechnique.server.api.OfflineServerImpl;
import java.awt.Frame;
import java.awt.SystemTray;
import java.awt.Window;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class PomodoroClientApp
extends SingleFrameApplication {
    private static String[] commandLine;

    private boolean startHidden() {
        return commandLine.length > 0 && commandLine[0].equals("-s");
    }

    protected void startup() {
        this.checkTray();
        LoginWindow login = new LoginWindow((Frame)this.getMainFrame(), true);
        try {
            final OfflineServerImpl server = new OfflineServerImpl();
            this.addExitListener(new Application.ExitListener(){

                public boolean canExit(EventObject event) {
                    return true;
                }

                public void willExit(EventObject event) {
                    System.out.println("Exiting now");
                    server.logout();
                }
            });
            PomodoroClientView pcv = new PomodoroClientView(this, server);
            this.show(pcv);
            if (this.startHidden()) {
                pcv.getFrame().setVisible(false);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PomodoroClientApp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void configureWindow(Window root) {
    }

    public static PomodoroClientApp getApplication() {
        return Application.getInstance(PomodoroClientApp.class);
    }

    public static void main(String[] args) {
        commandLine = args;
        PomodoroClientApp.launch(PomodoroClientApp.class, args);
    }

    private void checkTray() {
        if (!SystemTray.isSupported()) {
            Preferences prefs = Preferences.userRoot().node("pomodoroServer");
            prefs.put("timerWindowMode", "N");
        }
    }
}

