/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.tools.GeoProperty;

public class GeoPropertyIndex<T> {
    private final int maxLevel;
    private final GeoProperty<T> geoProp;
    private final GPLevel<T> root;
    private GPLevel<T> lastLevelUsed;
    private static final boolean DEBUG = false;

    public GeoPropertyIndex(GeoProperty<T> geoProperty, int n) {
        this.geoProp = geoProperty;
        this.maxLevel = n;
        this.root = new GPLevel(0, new BBox(-180.0, -90.0, 180.0, 90.0), null, this);
        this.lastLevelUsed = this.root;
    }

    public T get(LatLon latLon) {
        return this.lastLevelUsed.get(latLon);
    }

    public static int index(LatLon latLon, int n) {
        long l = 1L << n;
        long l2 = (long)((latLon.lon() + 180.0) * (double)l / 360.0) & 1L;
        long l3 = (long)((latLon.lat() + 90.0) * (double)l / 180.0) & 1L;
        return (int)(2L * l2 + l3);
    }

    public String toString() {
        return "GeoPropertyIndex [maxLevel=" + this.maxLevel + ", geoProp=" + this.geoProp + ", root=" + this.root + ", lastLevelUsed=" + this.lastLevelUsed + ']';
    }

    protected static class GPLevel<T> {
        private final T val;
        private final int level;
        private final BBox bbox;
        private final GPLevel<T> parent;
        private final GeoPropertyIndex<T> owner;
        private GPLevel<T>[] children;

        public GPLevel(int n, BBox bBox, GPLevel<T> gPLevel, GeoPropertyIndex<T> geoPropertyIndex) {
            this.level = n;
            this.bbox = bBox;
            this.parent = gPLevel;
            this.owner = geoPropertyIndex;
            this.val = ((GeoPropertyIndex)geoPropertyIndex).geoProp.get(bBox);
        }

        public T get(LatLon latLon) {
            if (this.isInside(latLon)) {
                return this.getBounded(latLon);
            }
            return this.parent.get(latLon);
        }

        private T getBounded(LatLon latLon) {
            int n;
            if (!this.isInside(latLon)) {
                throw new AssertionError((Object)("Point " + latLon + " should be inside " + this.bbox));
            }
            if (this.val != null) {
                ((GeoPropertyIndex)this.owner).lastLevelUsed = this;
                return this.val;
            }
            if (this.level >= ((GeoPropertyIndex)this.owner).maxLevel) {
                return ((GeoPropertyIndex)this.owner).geoProp.get(latLon);
            }
            if (this.children == null) {
                GPLevel[] gPLevelArray = new GPLevel[4];
                this.children = gPLevelArray;
            }
            if (this.children[n = GeoPropertyIndex.index(latLon, this.level + 1)] == null) {
                double d;
                double d2;
                switch (n) {
                    case 0: {
                        d2 = this.bbox.getTopLeftLon();
                        d = this.bbox.getBottomRightLat();
                        break;
                    }
                    case 1: {
                        d2 = this.bbox.getTopLeftLon();
                        d = this.bbox.getTopLeftLat();
                        break;
                    }
                    case 2: {
                        d2 = this.bbox.getBottomRightLon();
                        d = this.bbox.getBottomRightLat();
                        break;
                    }
                    case 3: {
                        d2 = this.bbox.getBottomRightLon();
                        d = this.bbox.getTopLeftLat();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                LatLon latLon2 = this.bbox.getCenter();
                BBox bBox = new BBox(d2, d, latLon2.lon(), latLon2.lat());
                this.children[n] = new GPLevel<T>(this.level + 1, bBox, this, this.owner);
            }
            return super.getBounded(latLon);
        }

        boolean isInside(LatLon latLon) {
            return this.bbox.getTopLeftLon() <= latLon.lon() && (latLon.lon() < this.bbox.getBottomRightLon() || latLon.lon() == 180.0 && this.bbox.getBottomRightLon() == 180.0) && this.bbox.getBottomRightLat() <= latLon.lat() && (latLon.lat() < this.bbox.getTopLeftLat() || latLon.lat() == 90.0 && this.bbox.getTopLeftLat() == 90.0);
        }

        public String toString() {
            return "GPLevel [val=" + this.val + ", level=" + this.level + ", bbox=" + this.bbox + ']';
        }
    }
}

