/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Adjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AdjustmentSynchronizer
implements AdjustmentListener {
    private final Set<Adjustable> synchronizedAdjustables = new HashSet<Adjustable>();
    private final Map<Adjustable, Boolean> enabledMap = new HashMap<Adjustable, Boolean>();
    private final ChangeNotifier observable = new ChangeNotifier();

    public void participateInSynchronizedScrolling(Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        if (this.synchronizedAdjustables.contains(adjustable)) {
            return;
        }
        this.synchronizedAdjustables.add(adjustable);
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        adjustable.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.enabledMap.get(adjustmentEvent.getAdjustable()).booleanValue()) {
            return;
        }
        for (Adjustable adjustable : this.synchronizedAdjustables) {
            if (adjustable == adjustmentEvent.getAdjustable() || !this.isParticipatingInSynchronizedScrolling(adjustable)) continue;
            adjustable.setValue(adjustmentEvent.getValue());
        }
    }

    protected void setParticipatingInSynchronizedScrolling(Adjustable adjustable, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(adjustable, "adjustable");
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet. Cannot set participation in synchronized adjustment.", adjustable));
        }
        this.enabledMap.put(adjustable, bl);
        this.observable.fireStateChanged();
    }

    protected boolean isParticipatingInSynchronizedScrolling(Adjustable adjustable) {
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet.", adjustable));
        }
        return this.enabledMap.get(adjustable);
    }

    public void adapt(JCheckBox jCheckBox, Adjustable adjustable) {
        CheckParameterUtil.ensureParameterNotNull(adjustable, "adjustable");
        CheckParameterUtil.ensureParameterNotNull(jCheckBox, "view");
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            this.participateInSynchronizedScrolling(adjustable);
        }
        jCheckBox.addItemListener(itemEvent -> {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    if (this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                    this.setParticipatingInSynchronizedScrolling(adjustable, true);
                    break;
                }
                case 2: {
                    if (!this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                    this.setParticipatingInSynchronizedScrolling(adjustable, false);
                    break;
                }
            }
        });
        this.observable.addChangeListener(changeEvent -> {
            boolean bl = this.isParticipatingInSynchronizedScrolling(adjustable);
            if (jCheckBox.isSelected() != bl) {
                jCheckBox.setSelected(bl);
            }
        });
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        jCheckBox.setSelected(true);
    }
}

