/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;

@FunctionalInterface
public interface LayerPositionStrategy {
    public static final LayerPositionStrategy IN_FRONT = layerManager -> 0;
    public static final LayerPositionStrategy AFTER_LAST_DATA_LAYER = LayerPositionStrategy.afterLast(layer -> layer instanceof OsmDataLayer || layer instanceof ValidatorLayer);
    public static final LayerPositionStrategy AFTER_LAST_VALIDATION_LAYER = LayerPositionStrategy.afterLast(layer -> layer instanceof ValidatorLayer);
    public static final LayerPositionStrategy BEFORE_FIRST_BACKGROUND_LAYER = LayerPositionStrategy.inFrontOfFirst(Layer::isBackgroundLayer);

    public static LayerPositionStrategy inFrontOf(Layer layer) {
        return LayerPositionStrategy.inFrontOfFirst(layer2 -> Objects.equals(layer2, layer));
    }

    public static LayerPositionStrategy inFrontOfFirst(Predicate<Layer> predicate) {
        return layerManager -> {
            if (layerManager != null) {
                List<Layer> list = layerManager.getLayers();
                for (int i = 0; i < list.size(); ++i) {
                    if (!predicate.test(list.get(i))) continue;
                    return i;
                }
                return list.size();
            }
            return 0;
        };
    }

    public static LayerPositionStrategy afterLast(Predicate<Layer> predicate) {
        return layerManager -> {
            if (layerManager != null) {
                List<Layer> list = layerManager.getLayers();
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (!predicate.test(list.get(i))) continue;
                    return i + 1;
                }
            }
            return 0;
        };
    }

    public int getPosition(LayerManager var1);
}

