/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.auxiliary.remote.server.RegistryKeepAliveRunner;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheServiceAdmin;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheServerFactory
implements IRemoteCacheConstants {
    private static final Log log = LogFactory.getLog(RemoteCacheServerFactory.class);
    private static RemoteCacheServer<?, ?> remoteCacheServer;
    private static String serviceName;
    private static ScheduledExecutorService keepAliveDaemon;
    private static Registry registry;

    private RemoteCacheServerFactory() {
    }

    public static <K, V> RemoteCacheServer<K, V> getRemoteCacheServer() {
        return remoteCacheServer;
    }

    @Deprecated
    public static void startup(String string, int n, String string2) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("ConfigFileName = [" + string2 + "]");
        }
        Properties properties = RemoteUtils.loadProps(string2);
        RemoteCacheServerFactory.startup(string, n, properties);
    }

    @Deprecated
    public static void startup(String string, int n, Properties properties, String string2) throws IOException {
        if (log.isWarnEnabled()) {
            log.warn("ConfigFileName = [" + string2 + "] ignored");
        }
        RemoteCacheServerFactory.startup(string, n, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String string, int n, Properties properties) throws IOException {
        if (remoteCacheServer != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (string == null) {
                string = "";
            }
            RemoteCacheServerAttributes remoteCacheServerAttributes = RemoteCacheServerFactory.configureRemoteCacheServerAttributes(properties);
            remoteCacheServerAttributes.setRemoteLocation(string, n);
            if (log.isInfoEnabled()) {
                log.info("Creating server with these attributes: " + remoteCacheServerAttributes);
            }
            RemoteCacheServerFactory.setServiceName(remoteCacheServerAttributes.getRemoteServiceName());
            RMISocketFactory rMISocketFactory = RemoteCacheServerFactory.configureObjectSpecificCustomFactory(properties);
            RemoteUtils.configureGlobalCustomSocketFactory(remoteCacheServerAttributes.getRmiSocketFactoryTimeoutMillis());
            ICacheEventLogger iCacheEventLogger = RemoteCacheServerFactory.configureCacheEventLogger(properties);
            remoteCacheServer = rMISocketFactory != null ? new RemoteCacheServer(remoteCacheServerAttributes, properties, rMISocketFactory) : new RemoteCacheServer((IRemoteCacheServerAttributes)remoteCacheServerAttributes, properties);
            remoteCacheServer.setCacheEventLogger(iCacheEventLogger);
            if (remoteCacheServerAttributes.isStartRegistry()) {
                registry = RemoteUtils.createRegistry(n);
            }
            RemoteCacheServerFactory.registerServer(RemoteUtils.getNamingURL(string, n, serviceName), remoteCacheServer);
            if (remoteCacheServerAttributes.isUseRegistryKeepAlive()) {
                if (keepAliveDaemon == null) {
                    keepAliveDaemon = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("JCS-RemoteCacheServerFactory-"));
                }
                RegistryKeepAliveRunner registryKeepAliveRunner = new RegistryKeepAliveRunner(string, n, serviceName);
                registryKeepAliveRunner.setCacheEventLogger(iCacheEventLogger);
                keepAliveDaemon.scheduleAtFixedRate(registryKeepAliveRunner, 0L, remoteCacheServerAttributes.getRegistryKeepAliveDelayMillis(), TimeUnit.MILLISECONDS);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected static ICacheEventLogger configureCacheEventLogger(Properties properties) {
        ICacheEventLogger iCacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(properties, "jcs.remotecache");
        if (iCacheEventLogger == null) {
            iCacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(properties, "remote");
        }
        return iCacheEventLogger;
    }

    protected static RMISocketFactory configureObjectSpecificCustomFactory(Properties properties) {
        RMISocketFactory rMISocketFactory = OptionConverter.instantiateByKey(properties, "jcs.remotecache.customrmisocketfactory", null);
        if (rMISocketFactory != null) {
            PropertySetter.setProperties(rMISocketFactory, properties, "jcs.remotecache.customrmisocketfactory.");
            if (log.isInfoEnabled()) {
                log.info("Will use server specific custom socket factory. " + rMISocketFactory);
            }
        } else if (log.isInfoEnabled()) {
            log.info("No server specific custom socket factory defined.");
        }
        return rMISocketFactory;
    }

    protected static void registerServer(String string, Remote remote) throws RemoteException {
        if (remote == null) {
            throw new RemoteException("Cannot register the server until it is created.");
        }
        if (log.isInfoEnabled()) {
            log.info("Binding server to " + string);
        }
        try {
            Naming.rebind(string, remote);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage() + "; url=" + string);
        }
    }

    protected static RemoteCacheServerAttributes configureRemoteCacheServerAttributes(Properties properties) {
        RemoteCacheServerAttributes remoteCacheServerAttributes = new RemoteCacheServerAttributes();
        PropertySetter.setProperties(remoteCacheServerAttributes, properties, "jcs.remotecache.serverattributes.");
        RemoteCacheServerFactory.configureManuallyIfValuesArePresent(properties, remoteCacheServerAttributes);
        return remoteCacheServerAttributes;
    }

    private static void configureManuallyIfValuesArePresent(Properties properties, RemoteCacheServerAttributes remoteCacheServerAttributes) {
        String string;
        String string2;
        String string3;
        String string4 = properties.getProperty("remote.cache.service.port");
        if (string4 != null) {
            try {
                int n = Integer.parseInt(string4);
                remoteCacheServerAttributes.setServicePort(n);
                log.debug("Remote cache service uses port number " + n + ".");
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Remote cache service port property remote.cache.service.port not specified.  An anonymous port will be used.");
            }
        }
        if ((string3 = properties.getProperty("remote.cache.rmiSocketFactoryTimeoutMillis")) != null) {
            try {
                int n = Integer.parseInt(string3);
                remoteCacheServerAttributes.setRmiSocketFactoryTimeoutMillis(n);
                log.debug("Remote cache socket timeout " + n + "ms.");
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Remote cache socket timeout property remote.cache.rmiSocketFactoryTimeoutMillis not specified.  The default will be used.");
            }
        }
        if ((string2 = properties.getProperty("remote.cluster.LocalClusterConsistency")) != null) {
            boolean bl = Boolean.parseBoolean(string2);
            remoteCacheServerAttributes.setLocalClusterConsistency(bl);
        }
        if ((string = properties.getProperty("remote.cluster.AllowClusterGet")) != null) {
            boolean bl = Boolean.parseBoolean(string2);
            remoteCacheServerAttributes.setAllowClusterGet(bl);
        }
        remoteCacheServerAttributes.setRemoteServiceName(properties.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownImpl(String string, int n) throws IOException {
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            log.info("Unbinding host=" + string + ", port=" + n + ", serviceName=" + RemoteCacheServerFactory.getServiceName());
            try {
                Naming.unbind(RemoteUtils.getNamingURL(string, n, RemoteCacheServerFactory.getServiceName()));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException(malformedURLException.getMessage() + "; host=" + string + ", port=" + n + ", serviceName=" + RemoteCacheServerFactory.getServiceName());
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
            remoteCacheServer.release();
            remoteCacheServer = null;
            if (keepAliveDaemon != null) {
                keepAliveDaemon.shutdownNow();
                keepAliveDaemon = null;
            }
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
                registry = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        Properties properties = stringArray.length > 0 ? RemoteUtils.loadProps(stringArray[stringArray.length - 1]) : new Properties();
        try {
            n = Integer.parseInt(properties.getProperty("registry.port"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 1099;
        }
        if (stringArray.length > 0 && stringArray[0].toLowerCase().indexOf("-shutdown") != -1) {
            try {
                object = RemoteCacheServerFactory.lookupCacheServiceAdmin(properties, n);
                object.shutdown();
            }
            catch (Exception exception) {
                log.error("Problem calling shutdown.", exception);
            }
            log.debug("done.");
            System.exit(0);
        }
        if (stringArray.length > 0 && stringArray[0].toLowerCase().indexOf("-stats") != -1) {
            log.debug("getting cache stats");
            try {
                object = RemoteCacheServerFactory.lookupCacheServiceAdmin(properties, n);
                try {
                    log.debug(object.getStats());
                }
                catch (IOException iOException) {
                    log.error(iOException);
                }
            }
            catch (Exception exception) {
                log.error("Problem getting stats.", exception);
            }
            log.debug("done.");
            System.exit(0);
        }
        if ((object = properties.getProperty("registry.host")) == null || ((String)object).trim().equals("") || ((String)object).trim().equals("localhost")) {
            log.debug("main> creating registry on the localhost");
            RemoteUtils.createRegistry(n);
        }
        log.debug("main> starting up RemoteCacheServer");
        RemoteCacheServerFactory.startup((String)object, n, properties);
        log.debug("main> done");
    }

    private static ICacheServiceAdmin lookupCacheServiceAdmin(Properties properties, int n) throws Exception {
        String string = properties.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim();
        String string2 = RemoteUtils.getNamingURL("", n, string);
        if (log.isDebugEnabled()) {
            log.debug("looking up server " + string2);
        }
        Remote remote = Naming.lookup(string2);
        if (log.isDebugEnabled()) {
            log.debug("server found");
        }
        return (ICacheServiceAdmin)((Object)remote);
    }

    protected static void setServiceName(String string) {
        serviceName = string;
    }

    protected static String getServiceName() {
        return serviceName;
    }

    static {
        serviceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
        registry = null;
    }
}

