/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import com.mimer.ws.validateSQL.ValidatorResult;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSession;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;

public class WebServiceValidator {
    private final WebServiceSession _webServiceSession;
    private final WebServiceSessionProperties _prefs;

    public WebServiceValidator(WebServiceSession webServiceSession, WebServiceSessionProperties prefs) {
        if (webServiceSession == null) {
            throw new IllegalArgumentException("WebServiceSession == null");
        }
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        this._webServiceSession = webServiceSession;
        this._prefs = prefs;
    }

    public ValidatorResult validate(String sql) throws ServiceException, RemoteException {
        Service l_service = new Service();
        Call l_call = (Call)l_service.createCall();
        l_call.setTargetEndpointAddress(this._webServiceSession.getTargetURL());
        l_call.setOperationName(new QName("SQL99Validator", "validateSQL"));
        l_call.addParameter("a_sessionId", XMLType.XSD_INT, ParameterMode.IN);
        l_call.addParameter("a_sessionKey", XMLType.XSD_INT, ParameterMode.IN);
        l_call.addParameter("a_sqlStatement", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_resultType", XMLType.XSD_STRING, ParameterMode.IN);
        QName l_qn = new QName("http://sqlvalidator.mimer.com/v1.0", "ValidatorResult");
        l_call.registerTypeMapping(ValidatorResult.class, l_qn, (SerializerFactory)new BeanSerializerFactory(ValidatorResult.class, l_qn), (DeserializerFactory)new BeanDeserializerFactory(ValidatorResult.class, l_qn));
        l_call.setReturnType(l_qn);
        Object[] parms = new Object[]{this._webServiceSession.getSessionID(), this._webServiceSession.getSessionKey(), sql, "text"};
        return (ValidatorResult)l_call.invoke(parms);
    }
}

