/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.lang.reflect.Constructor;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.rtextfilechooser.DetailsViewFileNameRenderer;
import org.fife.ui.rtextfilechooser.ListViewCellRenderer;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

class FileChooserViewRendererFactory {
    private FileChooserViewRendererFactory() {
    }

    public static TableCellRenderer createDefaultTableRenderer() {
        if (SubstanceUtils.isSubstanceInstalled()) {
            try {
                Class<?> clazz = Class.forName("org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer");
                return (TableCellRenderer)clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DefaultTableCellRenderer();
    }

    public static ListCellRenderer createListViewRenderer(RTextFileChooser chooser) {
        ListCellRenderer<Object> renderer = null;
        if (SubstanceUtils.isSubstanceInstalled()) {
            String clazzName = "org.fife.ui.rtextfilechooser.ListViewSubstanceCellRenderer";
            try {
                Class<?> clazz = Class.forName(clazzName);
                Constructor<?> c = clazz.getConstructor(RTextFileChooser.class);
                renderer = (ListCellRenderer)c.newInstance(chooser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (renderer == null) {
            renderer = new ListViewCellRenderer(chooser);
        }
        return renderer;
    }

    public static TableCellRenderer createTableFileNameRenderer(RTextFileChooser chooser) {
        TableCellRenderer renderer = null;
        if (SubstanceUtils.isSubstanceInstalled()) {
            try {
                Class<?> clazz = Class.forName("org.fife.ui.rtextfilechooser.DetailsViewSubstanceFileNameRenderer");
                Constructor<?> c = clazz.getConstructor(RTextFileChooser.class);
                renderer = (TableCellRenderer)c.newInstance(chooser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (renderer == null) {
            renderer = new DetailsViewFileNameRenderer(chooser);
        }
        return renderer;
    }
}

