/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.dockablewindows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.UIUtil;
import org.fife.ui.dockablewindows.Actions;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowPanel;
import org.fife.ui.dockablewindows.DockableWindowUtil;
import org.fife.ui.dockablewindows.DockedWindowTabbedPaneUI;

class DockableWindowGroup
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DockableWindowPanel.ContentPanel parent;
    private JTabbedPane tabbedPane;
    private TitlePanel titlePanel;

    public DockableWindowGroup(DockableWindowPanel.ContentPanel parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.tabbedPane = new DockedTabbedPane();
        this.add(this.tabbedPane);
        this.titlePanel = new TitlePanel("Hello world");
        this.tabbedPane.addChangeListener(this.titlePanel);
        this.add((Component)this.titlePanel, "North");
    }

    public boolean addDockableWindow(DockableWindow window) {
        this.tabbedPane.addTab(window.getDockableWindowName(), window.getIcon(), window);
        this.titlePanel.stateChanged(null);
        return true;
    }

    public int containsDockableWindow(DockableWindow window) {
        int count = this.tabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.tabbedPane.getComponentAt(i);
            if (c != window) continue;
            return i;
        }
        return -1;
    }

    public void focusActiveDockableWindow() {
        DockableWindow dwind = this.getDockableWindowAt(this.tabbedPane.getSelectedIndex());
        dwind.focused();
    }

    public int getDockableWindowCount() {
        return this.tabbedPane.getTabCount();
    }

    public DockableWindow[] getDockableWindows() {
        int count = this.tabbedPane.getTabCount();
        DockableWindow[] windows = new DockableWindow[count];
        for (int i = 0; i < count; ++i) {
            windows[i] = (DockableWindow)this.tabbedPane.getComponentAt(i);
        }
        return windows;
    }

    public DockableWindow getDockableWindowAt(int index) {
        return (DockableWindow)this.tabbedPane.getComponentAt(index);
    }

    public void refreshTabName(int index) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            DockableWindow w = (DockableWindow)this.tabbedPane.getComponentAt(index);
            String name = w.getDockableWindowName();
            this.tabbedPane.setTitleAt(index, name);
            this.refreshTabTitle(index);
        }
    }

    public void refreshTabTitle(int index) {
        if (index == this.tabbedPane.getSelectedIndex()) {
            DockableWindow w = (DockableWindow)this.tabbedPane.getComponentAt(index);
            String title = w.getDockableWindowTitle();
            this.titlePanel.setTitle(title);
        }
    }

    public boolean removeDockableWindow(DockableWindow window) {
        int index = this.containsDockableWindow(window);
        if (index > -1) {
            this.tabbedPane.removeTabAt(index);
            this.titlePanel.stateChanged(null);
            return true;
        }
        return false;
    }

    public void setActiveDockableWindow(int index) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private class TitlePanel
    extends JPanel
    implements ChangeListener {
        private JLabel label;
        private JButton minimizeButton;
        private Color gradient1;
        private Color gradient2;

        public TitlePanel(String title) {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.refreshGradientColors();
            this.label = new JLabel(title);
            this.refreshLabelForeground();
            this.add(this.label);
            this.minimizeButton = new JButton(new MinimizeAction());
            this.minimizeButton.setOpaque(false);
            JToolBar tb = new JToolBar();
            tb.setFloatable(false);
            tb.setOpaque(false);
            tb.setBorder(null);
            tb.add(this.minimizeButton);
            this.add((Component)tb, "After");
        }

        public Color darker(Color c) {
            double FACTOR = 0.85;
            return new Color(Math.max((int)((double)c.getRed() * 0.85), 0), Math.max((int)((double)c.getGreen() * 0.85), 0), Math.max((int)((double)c.getBlue() * 0.85), 0));
        }

        public Dimension getMinimumSize() {
            Dimension d = this.getPreferredSize();
            d.width = 32;
            return d;
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = 20;
            return d;
        }

        private boolean getUseCustomColors() {
            String laf = UIManager.getLookAndFeel().getClass().getName();
            return laf.endsWith("WindowsLookAndFeel") || laf.endsWith("MetalLookAndFeel");
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.gradient1, 0.0f, this.getHeight(), this.gradient2);
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            Rectangle bounds = this.getBounds();
            g2d.fillRect(0, 0, bounds.width, bounds.height);
            g2d.setPaint(oldPaint);
            g2d.setColor(DockableWindowUtil.getDockableWindowBorderColor());
            g2d.drawLine(0, 0, bounds.width - 1, 0);
            g2d.drawLine(0, 0, 0, bounds.height - 1);
            g2d.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            g2d.drawLine(0, bounds.height - 1, bounds.width - 1, bounds.height - 1);
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }

        public void stateChanged(ChangeEvent e) {
            int index = DockableWindowGroup.this.tabbedPane.getSelectedIndex();
            if (index > -1) {
                DockableWindow w = DockableWindowGroup.this.getDockableWindowAt(index);
                this.setTitle(w.getDockableWindowTitle());
            }
        }

        private void refreshGradientColors() {
            this.gradient2 = null;
            this.gradient1 = null;
            if (this.getUseCustomColors()) {
                this.gradient1 = new Color(225, 233, 241);
                this.gradient2 = new Color(153, 180, 209);
            } else if (SubstanceUtils.isSubstanceInstalled()) {
                try {
                    this.gradient1 = SubstanceUtils.getSubstanceColor("ultraLightColor");
                    this.gradient2 = SubstanceUtils.getSubstanceColor("lightColor");
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.gradient1 == null) {
                this.gradient1 = UIManager.getColor("TextField.selectionBackground");
                if (this.gradient1 == null) {
                    this.gradient1 = UIManager.getColor("textHighlight");
                    if (this.gradient1 == null) {
                        this.gradient1 = new Color(153, 180, 209);
                    }
                }
                this.gradient2 = this.darker(this.gradient1);
            }
        }

        private void refreshLabelForeground() {
            Color c = null;
            if (this.getUseCustomColors()) {
                c = UIManager.getColor("Label.foreground");
            } else if (SubstanceUtils.isSubstanceInstalled()) {
                c = UIManager.getColor("Label.foreground");
            }
            if (c == null && (c = UIManager.getColor("TextField.selectionForeground")) == null && (c = UIManager.getColor("nimbusSelectedText")) == null && (c = UIManager.getColor("textHighlightText")) == null) {
                c = Color.black;
            }
            c = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.label.setForeground(c);
        }

        public void updateUI() {
            super.updateUI();
            if (this.label != null) {
                this.label.updateUI();
            }
            this.refreshGradientColors();
            if (this.label != null) {
                this.refreshLabelForeground();
            }
        }

        private class MinimizeAction
        extends AbstractAction {
            public MinimizeAction() {
                this.putValue("ShortDescription", DockableWindow.getString("Button.Minimize"));
                ImageIcon icon = new ImageIcon(this.getClass().getResource("minimize.png"));
                this.putValue("SmallIcon", icon);
            }

            public void actionPerformed(ActionEvent e) {
                DockableWindowGroup.this.parent.setCollapsed(true);
            }
        }
    }

    private class DockedTabbedPane
    extends JTabbedPane {
        private JPopupMenu popup;

        public DockedTabbedPane() {
            super(3);
            this.enableEvents(16L);
        }

        private JPopupMenu getPopupMenu() {
            if (this.popup == null) {
                DockableWindowPanel dwindPanel = DockableWindowGroup.this.parent.getDockableWindowPanel();
                this.popup = Actions.createRedockPopupMenu(dwindPanel);
            }
            return this.popup;
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Map old = UIUtil.setNativeRenderingHints(g2d);
            super.paintComponent(g);
            g2d.setRenderingHints(old);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                int y;
                int x;
                int index;
                if (e.isPopupTrigger() && (index = this.indexAtLocation(x = e.getX(), y = e.getY())) != -1) {
                    this.setSelectedIndex(index);
                    DockableWindow dwind = (DockableWindow)this.getSelectedComponent();
                    this.putClientProperty("DockableWindow", dwind);
                    JPopupMenu popup = this.getPopupMenu();
                    popup.show(this, x, y);
                }
            } else {
                super.processMouseEvent(e);
            }
        }

        public void setSelectedIndex(int index) {
            super.setSelectedIndex(index);
            final DockableWindow dwind = (DockableWindow)this.getSelectedComponent();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dwind.focused();
                }
            });
        }

        public void setUI(TabbedPaneUI ui) {
            super.setUI(new DockedWindowTabbedPaneUI());
        }
    }
}

