/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderImpl;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirAbstractAnnotationResolveTransformer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002$\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0001B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001f\u001a\u00020\u0007H\u0014J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0016\u0010$\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002H\u0016J(\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0016\u0010$\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002H\u0016J(\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0016\u0010$\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002H\u0016J(\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\u00052\u0016\u0010$\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002H\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirAnnotationResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirAbstractAnnotationResolveTransformer;", "Lcom/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "metaAnnotations", "", "getMetaAnnotations", "()Ljava/util/Set;", "setMetaAnnotations", "(Ljava/util/Set;)V", "owners", "predicateBasedProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "afterTransformingChildren", "", "state", "beforeTransformingChildren", "parentDeclaration", "transformAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "transformAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "transformDeclaration", "declaration", "transformRegularClass", "regularClass", "resolve"})
final class FirAnnotationResolveTransformer
extends FirAbstractAnnotationResolveTransformer<Multimap<FqName, FirRegularClass>, PersistentList<? extends FirDeclaration>> {
    @NotNull
    private final FirPredicateBasedProviderImpl predicateBasedProvider;
    @NotNull
    private Set<FqName> metaAnnotations;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @NotNull
    private PersistentList<? extends FirDeclaration> owners;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;

    public FirAnnotationResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(session2, scopeSession);
        this.predicateBasedProvider = (FirPredicateBasedProviderImpl)FirPredicateBasedProviderKt.getPredicateBasedProvider(session2);
        this.metaAnnotations = SetsKt.emptySet();
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(session2, false, null, 4, null);
        this.owners = ExtensionsKt.persistentListOf();
        this.classDeclarationsStack = new ArrayDeque();
    }

    @NotNull
    public final Set<FqName> getMetaAnnotations() {
        return this.metaAnnotations;
    }

    public final void setMetaAnnotations(@NotNull Set<FqName> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.metaAnnotations = set;
    }

    @Override
    @NotNull
    protected PersistentList<FirDeclaration> beforeTransformingChildren(@NotNull FirDeclaration parentDeclaration) {
        Intrinsics.checkNotNullParameter(parentDeclaration, "parentDeclaration");
        PersistentList<FirDeclaration> current = this.owners;
        this.owners = this.owners.add(parentDeclaration);
        return current;
    }

    @Override
    protected void afterTransformingChildren(@Nullable PersistentList<? extends FirDeclaration> state) {
        if (state == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.owners = state;
    }

    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull Multimap<FqName, FirRegularClass> data) {
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        Intrinsics.checkNotNullParameter(data, "data");
        return this.transformAnnotation((FirAnnotation)annotationCall, data);
    }

    @Override
    @NotNull
    public FirStatement transformAnnotation(@NotNull FirAnnotation annotation2, @NotNull Multimap<FqName, FirRegularClass> data) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        Intrinsics.checkNotNullParameter(data, "data");
        return annotation2.transformAnnotationTypeRef(this.typeResolverTransformer, new ScopeClassDeclaration(this.getScopes(), this.classDeclarationsStack, null, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @NotNull Multimap<FqName, FirRegularClass> data) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter(data, "data");
        ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast(regularClass);
        try {
            FirStatement firStatement;
            boolean bl = false;
            FirStatement it = firStatement = super.transformRegularClass(regularClass, data);
            boolean bl2 = false;
            if (regularClass.getClassKind() == ClassKind.ANNOTATION_CLASS && !((Collection)this.metaAnnotations).isEmpty()) {
                void $this$filterTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = regularClass.getAnnotations();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Iterable<FqName> destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FqName it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    FirAnnotation it2 = (FirAnnotation)element$iv$iv;
                    boolean bl4 = false;
                    if (CallableIdUtilsKt.fqName(it2, this.getSession()) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List annotations2 = (List)destination$iv$iv;
                Iterable $this$filter$iv = annotations2;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FqName it3 = (FqName)element$iv$iv;
                    boolean bl6 = false;
                    if (!this.metaAnnotations.contains(it3)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (FqName annotation2 : (List)destination$iv$iv2) {
                    data.put(annotation2, regularClass);
                }
            }
            FirStatement firStatement2 = firStatement;
            return firStatement2;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration2, @NotNull Multimap<FqName, FirRegularClass> data) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data, "data");
        FirDeclaration it = firDeclaration = super.transformDeclaration(declaration2, data);
        boolean bl = false;
        this.predicateBasedProvider.registerAnnotatedDeclaration(declaration2, this.owners);
        return firDeclaration;
    }
}

