/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.ComposedSleighUseropLibrary;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.program.model.pcode.Varnode;
import ghidra.sleigh.grammar.Location;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public interface SleighUseropLibrary<T> {
    public static final SleighUseropLibrary<?> NIL = new EmptySleighUseropLibrary();

    public static <T> SleighUseropLibrary<T> nil() {
        return NIL;
    }

    public Map<String, SleighUseropDefinition<T>> getUserops();

    default public SleighUseropLibrary<T> compose(SleighUseropLibrary<T> lib) {
        if (lib == null) {
            return this;
        }
        return new ComposedSleighUseropLibrary<T>(List.of(this, lib));
    }

    default public Map<Integer, UserOpSymbol> getSymbols(SleighLanguage language) {
        HashMap<Integer, UserOpSymbol> symbols = new HashMap<Integer, UserOpSymbol>();
        HashSet<String> allNames = new HashSet<String>();
        int langOpCount = language.getNumberOfUserDefinedOpNames();
        for (int i = 0; i < langOpCount; ++i) {
            String name = language.getUserDefinedOpName(i);
            allNames.add(name);
        }
        int nextOpNo = langOpCount;
        for (SleighUseropDefinition<T> uop : new TreeMap<String, SleighUseropDefinition<T>>(this.getUserops()).values()) {
            String opName = uop.getName();
            if (!allNames.add(opName)) continue;
            int opNo = nextOpNo++;
            Location loc = new Location(this.getClass().getName() + ":" + opName, 0);
            UserOpSymbol sym = new UserOpSymbol(loc, opName);
            sym.setIndex(opNo);
            symbols.put(opNo, sym);
        }
        return symbols;
    }

    public static interface SleighUseropDefinition<T> {
        public String getName();

        public int getOperandCount();

        public void execute(PcodeExecutorStatePiece<T, T> var1, Varnode var2, List<Varnode> var3);
    }

    public static final class EmptySleighUseropLibrary
    implements SleighUseropLibrary<Object> {
        @Override
        public Map<String, SleighUseropDefinition<Object>> getUserops() {
            return Map.of();
        }
    }
}

