/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.Varnode;

public interface PcodeExecutorStatePiece<A, T> {
    default public void checkRange(AddressSpace space, long offset, int size) {
        try {
            new AddressRangeImpl(space.getAddress(offset), (long)size);
        }
        catch (AddressOutOfBoundsException | AddressOverflowException e) {
            throw new IllegalArgumentException("Given offset and length exceeds address space");
        }
    }

    public A longToOffset(AddressSpace var1, long var2);

    default public void setVar(Register reg, T val) {
        Address address = reg.getAddress();
        this.setVar(address.getAddressSpace(), address.getOffset(), reg.getMinimumByteSize(), true, val);
    }

    default public void setVar(Varnode var, T val) {
        Address address = var.getAddress();
        this.setVar(address.getAddressSpace(), address.getOffset(), var.getSize(), true, val);
    }

    public void setVar(AddressSpace var1, A var2, int var3, boolean var4, T var5);

    default public void setVar(AddressSpace space, long offset, int size, boolean truncateAddressableUnit, T val) {
        this.checkRange(space, offset, size);
        this.setVar(space, this.longToOffset(space, offset), size, truncateAddressableUnit, val);
    }

    default public T getVar(Register reg) {
        Address address = reg.getAddress();
        return this.getVar(address.getAddressSpace(), address.getOffset(), reg.getMinimumByteSize(), true);
    }

    default public T getVar(Varnode var) {
        Address address = var.getAddress();
        return this.getVar(address.getAddressSpace(), address.getOffset(), var.getSize(), true);
    }

    public T getVar(AddressSpace var1, A var2, int var3, boolean var4);

    default public T getVar(AddressSpace space, long offset, int size, boolean truncateAddressableUnit) {
        this.checkRange(space, offset, size);
        return this.getVar(space, this.longToOffset(space, offset), size, truncateAddressableUnit);
    }

    public MemBuffer getConcreteBuffer(Address var1);

    default public long truncateOffset(AddressSpace space, long offset) {
        return space.truncateAddressableWordOffset(offset) * (long)space.getAddressableUnitSize();
    }
}

