/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import java.math.BigInteger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PairedPcodeArithmetic<L, R>
implements PcodeArithmetic<Pair<L, R>> {
    private final PcodeArithmetic<L> leftArith;
    private final PcodeArithmetic<R> rightArith;

    public PairedPcodeArithmetic(PcodeArithmetic<L> leftArith, PcodeArithmetic<R> rightArith) {
        this.leftArith = leftArith;
        this.rightArith = rightArith;
    }

    @Override
    public Pair<L, R> unaryOp(UnaryOpBehavior op, int sizeout, int sizein1, Pair<L, R> in1) {
        return new ImmutablePair(this.leftArith.unaryOp(op, sizeout, sizein1, in1.getLeft()), this.rightArith.unaryOp(op, sizeout, sizein1, in1.getRight()));
    }

    @Override
    public Pair<L, R> binaryOp(BinaryOpBehavior op, int sizeout, int sizein1, Pair<L, R> in1, int sizein2, Pair<L, R> in2) {
        return new ImmutablePair(this.leftArith.binaryOp(op, sizeout, sizein1, in1.getLeft(), sizein2, in2.getLeft()), this.rightArith.binaryOp(op, sizeout, sizein1, in1.getRight(), sizein2, in2.getRight()));
    }

    @Override
    public Pair<L, R> fromConst(long value, int size) {
        return new ImmutablePair(this.leftArith.fromConst(value, size), this.rightArith.fromConst(value, size));
    }

    @Override
    public Pair<L, R> fromConst(BigInteger value, int size, boolean isContextreg) {
        return new ImmutablePair(this.leftArith.fromConst(value, size, isContextreg), this.rightArith.fromConst(value, size, isContextreg));
    }

    @Override
    public boolean isTrue(Pair<L, R> cond) {
        return this.leftArith.isTrue(cond.getLeft());
    }

    @Override
    public BigInteger toConcrete(Pair<L, R> value, boolean isContextreg) {
        return this.leftArith.toConcrete(value.getLeft(), isContextreg);
    }

    public PcodeArithmetic<L> getLeft() {
        return this.leftArith;
    }

    public PcodeArithmetic<R> getRight() {
        return this.rightArith;
    }
}

