/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import java.util.List;

public interface PcodeThread<T> {
    public String getName();

    public PcodeMachine<T> getMachine();

    public void setCounter(Address var1);

    public Address getCounter();

    public void overrideCounter(Address var1);

    public void assignContext(RegisterValue var1);

    public RegisterValue getContext();

    public void overrideContext(RegisterValue var1);

    public void overrideContextWithDefault();

    public void reInitialize();

    public void stepInstruction();

    public void stepPcodeOp();

    public PcodeFrame getFrame();

    public Instruction getInstruction();

    public void executeInstruction();

    public void finishInstruction();

    public void skipInstruction();

    public void dropInstruction();

    public void run();

    public void setSuspended(boolean var1);

    default public SleighLanguage getLanguage() {
        return this.getExecutor().getLanguage();
    }

    default public PcodeArithmetic<T> getArithmetic() {
        return this.getExecutor().getArithmetic();
    }

    public PcodeExecutor<T> getExecutor();

    public SleighUseropLibrary<T> getUseropLibrary();

    public ThreadPcodeExecutorState<T> getState();

    public void inject(Address var1, List<String> var2);

    public void clearInject(Address var1);

    public void clearAllInjects();
}

