/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.timeline;

import com.google.common.collect.BiMap;
import com.google.common.collect.BoundType;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.timeline.TimelineListener;
import ghidra.util.Swing;
import ghidra.util.UIManagerWrapper;
import ghidra.util.datastruct.ListenerSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TimelinePanel<T, N extends Number>
extends JPanel {
    public static final int INSET_WIDTH = 2;
    public static final int SLACK = 1;
    protected RowObjectTableModel<T> tableModel;
    protected ListSelectionModel selectionModel;
    protected TimelineInfo<T, N> info;
    protected Range<Double> viewRange = Range.closed((Comparable)Double.valueOf(-1.0), (Comparable)Double.valueOf(1.0));
    protected double maxAtLeast;
    private boolean isCompressed = true;
    protected final TableModelListener tableModelListener = this::tableChanged;
    protected final ListSelectionListener selectionModelListener = this::selectionChanged;
    protected final ItemTracker rows = new ItemTracker();
    protected final List<TimelineTrack<T, N>> tracks = new ArrayList<TimelineTrack<T, N>>();
    protected final Map<T, TimelineTrack<T, N>> trackMap = new HashMap<T, TimelineTrack<T, N>>();
    protected final ListenerSet<TimelineListener> timelineListeners = new ListenerSet<TimelineListener>(TimelineListener.class);
    protected final MouseListener mouseListener = new CellMouseListener();
    protected final FocusListener focusListener = new CellFocusListener();

    public static <N extends Number, M extends Number> Range<M> mapRangeEndpoints(Range<N> range, Function<N, M> func) {
        if (range.hasLowerBound()) {
            if (range.hasUpperBound()) {
                if (range.lowerBoundType() == BoundType.CLOSED) {
                    if (range.upperBoundType() == BoundType.CLOSED) {
                        return Range.closed((Comparable)((Object)((Number)func.apply((Number)((Object)range.lowerEndpoint())))), (Comparable)((Object)((Number)func.apply((Number)((Object)range.upperEndpoint())))));
                    }
                    return Range.closedOpen((Comparable)((Object)((Number)func.apply((Number)((Object)range.lowerEndpoint())))), (Comparable)((Object)((Number)func.apply((Number)((Object)range.upperEndpoint())))));
                }
                if (range.upperBoundType() == BoundType.CLOSED) {
                    return Range.openClosed((Comparable)((Object)((Number)func.apply((Number)((Object)range.lowerEndpoint())))), (Comparable)((Object)((Number)func.apply((Number)((Object)range.upperEndpoint())))));
                }
                return Range.open((Comparable)((Object)((Number)func.apply((Number)((Object)range.lowerEndpoint())))), (Comparable)((Object)((Number)func.apply((Number)((Object)range.upperEndpoint())))));
            }
            if (range.lowerBoundType() == BoundType.CLOSED) {
                return Range.atLeast((Comparable)((Object)((Number)func.apply((Number)((Object)range.lowerEndpoint())))));
            }
            return Range.greaterThan((Comparable)((Object)((Number)func.apply((Number)((Object)range.lowerEndpoint())))));
        }
        if (range.hasUpperBound()) {
            if (range.upperBoundType() == BoundType.CLOSED) {
                return Range.atMost((Comparable)((Object)((Number)func.apply((Number)((Object)range.upperEndpoint())))));
            }
            return Range.lessThan((Comparable)((Object)((Number)func.apply((Number)((Object)range.upperEndpoint())))));
        }
        return Range.all();
    }

    protected static <N extends Number> Double minWithSlack(Double a, N b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return b.doubleValue() - 1.0;
        }
        if (b == null) {
            return a;
        }
        return Math.min(a, b.doubleValue() - 1.0);
    }

    protected static <N extends Number> Double maxWithSlack(Double a, N b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return b.doubleValue() + 1.0;
        }
        if (b == null) {
            return a;
        }
        return Math.max(a, b.doubleValue() + 1.0);
    }

    public TimelinePanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setFocusable(true);
    }

    public TimelinePanel(RowObjectTableModel<T> model, TimelineInfo<T, N> info) {
        this();
        this.setTableModel(model, info);
        this.setSelectionModel(new DefaultListSelectionModel());
    }

    private synchronized void focusGainedOrLost() {
        this.recolor();
    }

    public void addTimelineListener(TimelineListener listener) {
        this.timelineListeners.add(listener);
    }

    public void removeTimelineListener(TimelineListener listener) {
        this.timelineListeners.remove(listener);
    }

    protected Range<Double> computeViewRange() {
        Double min = null;
        double max = this.maxAtLeast + 1.0;
        for (TimelineTrack<T, N> track : this.tracks) {
            for (Range range : track.objects.asMapOfRanges().keySet()) {
                Number lower = range.hasLowerBound() ? (Number)((Number)((Object)range.lowerEndpoint())) : (Number)null;
                Number upper = range.hasUpperBound() ? (Number)((Number)((Object)range.upperEndpoint())) : (Number)null;
                min = TimelinePanel.minWithSlack(min, lower);
                min = TimelinePanel.minWithSlack(min, upper);
                max = TimelinePanel.maxWithSlack(max, lower);
                max = TimelinePanel.maxWithSlack(max, upper);
            }
        }
        if (min == null) {
            min = 0.0;
        }
        return Range.closed((Comparable)min, (Comparable)Double.valueOf(max));
    }

    protected synchronized void reSortTracks() {
        HashBiMap minIndices = HashBiMap.create((int)this.tracks.size());
        List items = this.rows.items();
        for (int i = 0; i < items.size(); ++i) {
            int fi = i;
            minIndices.compute(this.trackMap.get(items.get(i)), (t, j) -> j == null ? fi : Math.min(fi, j));
        }
        this.tracks.sort((arg_0, arg_1) -> TimelinePanel.lambda$reSortTracks$1((BiMap)minIndices, arg_0, arg_1));
        this.removeAll();
        for (TimelineTrack<T, N> track : this.tracks) {
            this.add(track);
        }
    }

    protected synchronized void assignTrack(T t) {
        Range<N> range = this.info.getRange(t);
        for (TimelineTrack<T, N> track : this.tracks) {
            if (!track.fits(range)) continue;
            track.add(range, t);
            this.trackMap.put(t, track);
            return;
        }
        TimelineTrack<T, N> track = new TimelineTrack<T, N>(this.info, this.mouseListener, this.focusListener, this.isCompressed);
        this.add(track);
        this.tracks.add(track);
        track.add(range, t);
        this.trackMap.put(t, track);
    }

    protected synchronized void assignTracks(Collection<T> col) {
        for (T t : col) {
            assert (!this.trackMap.containsKey(t));
            this.assignTrack(t);
        }
    }

    protected synchronized void adjustTrack(T t) {
        Range<N> range = this.info.getRange(t);
        TimelineTrack<T, N> track = this.trackMap.get(t);
        track.remove(t);
        if (track.fits(range)) {
            track.add(range, t);
            return;
        }
        this.assignTrack(t);
    }

    protected synchronized Component getComponent(T key) {
        return (Component)this.trackMap.get(key).componentMap.get(key);
    }

    protected synchronized void reAssignTracks() {
        block0: for (Object t : this.rows.items()) {
            TimelineTrack fromTrack = this.trackMap.get(t);
            for (TimelineTrack toTrack : this.tracks) {
                Range<N> range;
                if (toTrack.fits(range = this.info.getRange(t))) {
                    fromTrack.remove(t);
                    toTrack.add(range, t);
                    this.trackMap.put(t, toTrack);
                    continue block0;
                }
                if (fromTrack != toTrack) continue;
                continue block0;
            }
        }
        Iterator<TimelineTrack<T, N>> it = this.tracks.iterator();
        while (it.hasNext()) {
            TimelineTrack<T, N> track = it.next();
            if (!track.isEmpty()) continue;
            it.remove();
            this.remove(track);
        }
    }

    protected synchronized void adjustTracks(Collection<T> col) {
        for (T t : col) {
            this.adjustTrack(t);
        }
        this.reAssignTracks();
    }

    protected synchronized void cleanTracks(Collection<T> col) {
        for (TimelineTrack<T, N> track : this.tracks) {
            track.removeAll(col);
        }
        this.trackMap.keySet().removeAll(col);
        this.reAssignTracks();
    }

    private synchronized void tableChanged(TableModelEvent e) {
        switch (e.getType()) {
            case 1: {
                List itemsInserted = this.rows.itemsInserted(e.getFirstRow(), e.getLastRow());
                this.assignTracks(itemsInserted);
                this.reSortTracks();
                this.fitView();
                this.recolor();
                break;
            }
            case 0: {
                if (e.getLastRow() >= this.tableModel.getRowCount()) {
                    this.reload();
                    this.fitView();
                    this.recolor();
                    break;
                }
                int column = e.getColumn();
                if (!this.info.columnAffectsBounds(column)) break;
                List itemsUpdated = this.rows.itemsUpdated(e.getFirstRow(), e.getLastRow());
                this.adjustTracks(itemsUpdated);
                this.reSortTracks();
                this.fitView();
                this.recolor();
                break;
            }
            case -1: {
                List itemsDeleted = this.rows.itemsDeleted(e.getFirstRow(), e.getLastRow());
                this.cleanTracks(itemsDeleted);
                this.reSortTracks();
                this.fitView();
                this.recolor();
            }
        }
    }

    protected void removeOldTableModelListeners() {
        if (this.tableModel == null) {
            return;
        }
        this.tableModel.removeTableModelListener(this.tableModelListener);
    }

    protected void addNewTableModelListeners() {
        if (this.tableModel == null) {
            return;
        }
        this.tableModel.addTableModelListener(this.tableModelListener);
    }

    public synchronized RowObjectTableModel<T> getTableModel() {
        return this.tableModel;
    }

    public synchronized void setTableModel(RowObjectTableModel<T> model, TimelineInfo<T, N> info) {
        if (this.tableModel == model) {
            return;
        }
        this.removeOldTableModelListeners();
        this.clear();
        this.tableModel = model;
        this.info = info;
        this.addNewTableModelListeners();
        this.reload();
        this.fitView();
    }

    protected void selectionChanged(ListSelectionEvent e) {
        this.recolor();
    }

    protected void removeOldSelectionModelListeners() {
        if (this.selectionModel == null) {
            return;
        }
        this.selectionModel.removeListSelectionListener(this.selectionModelListener);
    }

    protected void addNewSelectionModelListeners() {
        this.selectionModel.addListSelectionListener(this.selectionModelListener);
    }

    public synchronized void setSelectionModel(ListSelectionModel selectionModel) {
        if (this.selectionModel == selectionModel) {
            return;
        }
        this.removeOldSelectionModelListeners();
        this.selectionModel = selectionModel == null ? new DefaultListSelectionModel() : selectionModel;
        this.addNewSelectionModelListeners();
        this.recolor();
    }

    protected synchronized void clear() {
        this.rows.clear();
        this.tracks.clear();
        this.trackMap.clear();
        this.removeAll();
    }

    protected synchronized void reload() {
        this.clear();
        if (this.tableModel == null) {
            return;
        }
        this.assignTracks(this.rows.itemsRefreshed());
        this.recolor();
    }

    protected synchronized void recolor() {
        List items = this.rows.items();
        for (int i = 0; i < items.size(); ++i) {
            Object t = items.get(i);
            boolean selected = this.selectionModel.isSelectedIndex(i);
            TimelineTrack<T, N> track = this.trackMap.get(t);
            JComponent comp = (JComponent)track.componentMap.get(t);
            boolean hasFocus = comp.hasFocus();
            Color bg = this.info.getBackgroundColor(t, comp, this.tracks.indexOf(track), selected, hasFocus);
            Color fg = this.info.getForegroundColor(t, comp, this.tracks.indexOf(track), selected, hasFocus);
            comp.setBackground(bg);
            comp.setForeground(fg);
            BoundTypeBorder rangeBorder = new BoundTypeBorder(this.info.getRange(t));
            Border uiBorder = UIManagerWrapper.getBorder(hasFocus ? "Table.focusCellHighlightBorder" : "Table.cellNoFocusBorder");
            CompoundBorder border = BorderFactory.createCompoundBorder(rangeBorder, uiBorder);
            comp.setBorder(border);
        }
        this.repaint();
    }

    protected void fitView() {
        Range<Double> newViewRange = this.computeViewRange();
        if (this.viewRange.equals(newViewRange)) {
            this.validate();
            return;
        }
        this.viewRange = newViewRange;
        for (TimelineTrack<T, N> track : this.tracks) {
            track.setViewRange(newViewRange);
        }
        this.validate();
        ((TimelineListener)this.timelineListeners.fire).viewRangeChanged(newViewRange);
    }

    public Range<Double> getViewRange() {
        return this.viewRange;
    }

    protected <C> void dumpkeys(Class<C> cls, Function<C, String> fmt) {
        TreeMap sorted = new TreeMap();
        UIManager.getDefaults().entrySet().stream().filter(ent -> cls.isInstance(ent.getValue())).forEach(ent -> sorted.put(ent.getKey(), cls.cast(ent.getValue())));
        for (Map.Entry ent2 : sorted.entrySet()) {
            System.out.println(String.format("%s=%s", ent2.getKey(), fmt.apply(ent2.getValue())));
        }
    }

    public void setMaxAtLeast(double maxAtLeast) {
        if (this.maxAtLeast == maxAtLeast) {
            return;
        }
        this.maxAtLeast = maxAtLeast;
        if (!this.viewRange.contains((Comparable)Double.valueOf(maxAtLeast + 1.0))) {
            Swing.runIfSwingOrRunLater(() -> this.fitView());
        }
    }

    public double getMaxAtLeast() {
        return this.maxAtLeast;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    public synchronized Rectangle getCellBounds(T t) {
        TimelineTrack<T, N> track = this.trackMap.get(t);
        if (track == null) {
            return null;
        }
        JComponent comp = (JComponent)track.componentMap.get(t);
        if (comp == null) {
            return null;
        }
        Rectangle bounds = comp.getBounds();
        Point tl = track.getLocation();
        bounds.x += tl.x;
        bounds.y += tl.y;
        return bounds;
    }

    private static /* synthetic */ int lambda$reSortTracks$1(BiMap minIndices, TimelineTrack t1, TimelineTrack t2) {
        return Integer.compare((Integer)minIndices.get((Object)t1), (Integer)minIndices.get((Object)t2));
    }

    protected class CellFocusListener
    extends FocusAdapter {
        protected CellFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            TimelinePanel.this.focusGainedOrLost();
        }

        @Override
        public void focusLost(FocusEvent e) {
            TimelinePanel.this.focusGainedOrLost();
        }
    }

    protected class CellMouseListener
    extends MouseAdapter {
        protected CellMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component cell = e.getComponent();
            cell.requestFocus(FocusEvent.Cause.MOUSE_EVENT);
            TimelineTrack track = (TimelineTrack)cell.getParent();
            Object t = track.componentMap.inverse().get((Object)cell);
            assert (t != null);
            int index = TimelinePanel.this.rows.items().indexOf(t);
            if (e.isControlDown()) {
                if (TimelinePanel.this.selectionModel.isSelectedIndex(index)) {
                    TimelinePanel.this.selectionModel.removeSelectionInterval(index, index);
                } else {
                    TimelinePanel.this.selectionModel.addSelectionInterval(index, index);
                }
            } else {
                TimelinePanel.this.selectionModel.setSelectionInterval(index, index);
            }
            ((TimelineListener)TimelinePanel.this.timelineListeners.fire).itemActivated(index);
        }
    }

    protected class ItemTracker {
        private final List<T> trackedItems = new ArrayList();

        protected ItemTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<T> itemsInserted(int firstIndex, int lastIndex) {
            RowObjectTableModel rowObjectTableModel = TimelinePanel.this.tableModel;
            synchronized (rowObjectTableModel) {
                ArrayList inserted = new ArrayList(TimelinePanel.this.tableModel.getModelData().subList(firstIndex, lastIndex + 1));
                this.trackedItems.addAll(firstIndex, inserted);
                assert (Objects.equals(TimelinePanel.this.tableModel.getModelData(), this.trackedItems));
                return inserted;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<T> itemsUpdated(int firstIndex, int lastIndex) {
            RowObjectTableModel rowObjectTableModel = TimelinePanel.this.tableModel;
            synchronized (rowObjectTableModel) {
                ArrayList updated = new ArrayList(lastIndex - firstIndex + 1);
                for (int i = firstIndex; i <= lastIndex; ++i) {
                    Object t = TimelinePanel.this.tableModel.getModelData().get(i);
                    updated.add(t);
                    this.trackedItems.set(i, t);
                }
                assert (Objects.equals(TimelinePanel.this.tableModel.getModelData(), this.trackedItems));
                return updated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<T> itemsDeleted(int firstIndex, int lastIndex) {
            RowObjectTableModel rowObjectTableModel = TimelinePanel.this.tableModel;
            synchronized (rowObjectTableModel) {
                List sub = this.trackedItems.subList(firstIndex, lastIndex + 1);
                ArrayList deleted = new ArrayList(sub);
                sub.clear();
                assert (Objects.equals(TimelinePanel.this.tableModel.getModelData(), this.trackedItems));
                return deleted;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<T> itemsRefreshed() {
            RowObjectTableModel rowObjectTableModel = TimelinePanel.this.tableModel;
            synchronized (rowObjectTableModel) {
                this.trackedItems.clear();
                this.trackedItems.addAll(TimelinePanel.this.tableModel.getModelData());
                return this.trackedItems;
            }
        }

        public void clear() {
            this.trackedItems.clear();
        }

        public List<T> items() {
            return this.trackedItems;
        }
    }

    protected static class TimelineTrack<T, N extends Number>
    extends JPanel {
        protected final RangeMap<N, T> objects = TreeRangeMap.create();
        protected final BiMap<T, JComponent> componentMap = HashBiMap.create();
        protected final TimelineInfo<T, N> info;
        protected final MouseListener mouseListener;
        protected final FocusListener focusListener;
        protected boolean isCompressed;
        protected Range<Double> viewRange = Range.closed((Comparable)Double.valueOf(-1.0), (Comparable)Double.valueOf(1.0));

        public TimelineTrack(TimelineInfo<T, N> info, MouseListener mouseListener, FocusListener focusListener, boolean isCompressed) {
            this.info = info;
            this.mouseListener = mouseListener;
            this.focusListener = focusListener;
            this.isCompressed = isCompressed;
            this.setLayout(new TimelineTrackLayout(this));
            this.setFocusable(true);
        }

        @Override
        public boolean isOpaque() {
            return super.isOpaque();
        }

        public void setViewRange(Range<Double> viewRange) {
            this.viewRange = viewRange;
            this.invalidate();
        }

        public boolean fits(Range<N> range) {
            if (this.isCompressed) {
                return this.objects.subRangeMap(range).asMapOfRanges().isEmpty();
            }
            return false;
        }

        public void add(Range<N> range, T t) {
            this.objects.put(range, t);
            JComponent comp = this.info.getComponent(t);
            comp.setOpaque(true);
            comp.setFocusable(true);
            comp.addMouseListener(this.mouseListener);
            comp.addFocusListener(this.focusListener);
            this.add((Component)comp, range);
            this.componentMap.put(t, (Object)comp);
        }

        public void remove(T t) {
            Range found = null;
            for (Map.Entry ent : this.objects.asMapOfRanges().entrySet()) {
                if (!ent.getValue().equals(t)) continue;
                found = (Range)ent.getKey();
                break;
            }
            if (found != null) {
                this.objects.remove(found);
                Component comp = (Component)this.componentMap.remove(t);
                this.remove((T)comp);
            }
        }

        public void removeAll(Collection<T> c) {
            TreeRangeSet found = TreeRangeSet.create();
            for (Map.Entry ent : this.objects.asMapOfRanges().entrySet()) {
                if (!c.contains(ent.getValue())) continue;
                found.add((Range)ent.getKey());
            }
            for (Range range : found.asRanges()) {
                this.objects.remove(range);
            }
        }

        public boolean isEmpty() {
            return this.objects.asMapOfRanges().isEmpty();
        }
    }

    protected static class TimelineTrackLayout<N extends Number>
    implements LayoutManager2 {
        protected final TimelineTrack<?, N> track;
        protected final Map<Component, Range<N>> components = new HashMap<Component, Range<N>>();

        public TimelineTrackLayout(TimelineTrack<?, N> track) {
            this.track = track;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.components.put(comp, (Range)constraints);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.components.remove(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            double length = (Double)this.track.viewRange.upperEndpoint() - (Double)this.track.viewRange.lowerEndpoint();
            Dimension result = new Dimension();
            for (Map.Entry<Component, Range<N>> ent : this.components.entrySet()) {
                Range<Double> tRange = TimelinePanel.mapRangeEndpoints(ent.getValue(), rec$ -> ((Number)rec$).doubleValue());
                if (!tRange.isConnected(this.track.viewRange)) continue;
                Dimension size = ent.getKey().getMinimumSize();
                Range subRange = this.track.viewRange.intersection(tRange);
                double subLength = (Double)subRange.upperEndpoint() - (Double)subRange.lowerEndpoint();
                if (subLength != 0.0) {
                    double fraction = subLength / length;
                    result.width = Math.max(result.width, (int)Math.ceil((double)size.width / fraction));
                }
                result.height = Math.max(result.height, size.height);
            }
            return result;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension pDim = parent.getSize();
            double length = (Double)this.track.viewRange.upperEndpoint() - (Double)this.track.viewRange.lowerEndpoint();
            Rectangle cur = new Rectangle();
            cur.y = 0;
            cur.height = pDim.height;
            for (Map.Entry<Component, Range<N>> ent : this.components.entrySet()) {
                Range<Double> tRange = TimelinePanel.mapRangeEndpoints(ent.getValue(), rec$ -> ((Number)rec$).doubleValue());
                if (!tRange.isConnected(this.track.viewRange)) {
                    ent.getKey().setBounds(-10, -10, 1, 1);
                    continue;
                }
                Range range = this.track.viewRange.intersection(tRange);
                double subLength = (Double)range.upperEndpoint() - (Double)range.lowerEndpoint();
                double subLeft = (Double)range.lowerEndpoint() - (Double)this.track.viewRange.lowerEndpoint();
                cur.x = (int)(subLeft / length * (double)pDim.width);
                cur.width = Math.max(6, (int)(subLength / length * (double)pDim.width));
                ent.getKey().setBounds(cur);
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    protected static class BoundTypeBorder
    implements Border {
        protected final Insets unboundedInsets = new Insets(2, 0, 2, 0);
        protected final Insets rightBoundedInsets = new Insets(2, 0, 2, 2);
        protected final Insets leftBoundedInsets = new Insets(2, 2, 2, 0);
        protected final Insets boundedInsets = new Insets(2, 2, 2, 2);
        protected final Range<?> range;

        public BoundTypeBorder(Range<?> range) {
            this.range = range;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x1, int y1, int width, int height) {
            Graphics2D solid = (Graphics2D)g.create();
            solid.setStroke(new BasicStroke(3.0f));
            solid.setColor(c.getForeground());
            Graphics2D dashed = (Graphics2D)solid.create();
            dashed.setStroke(new BasicStroke(3.0f, 2, 0, 1.0f, new float[]{3.0f, 3.0f}, 0.0f));
            int x2 = x1 + width - 1;
            int y2 = y1 + height - 1;
            solid.drawLine(++x1, ++y1, --x2, y1);
            solid.drawLine(x1, --y2, x2, y2);
            if (this.range.hasLowerBound()) {
                if (this.range.lowerBoundType() == BoundType.CLOSED) {
                    solid.drawLine(x1, y1, x1, y2);
                } else {
                    dashed.drawLine(x1, y1, x1, y2);
                }
            }
            if (this.range.hasUpperBound()) {
                if (this.range.upperBoundType() == BoundType.CLOSED) {
                    solid.drawLine(x2, y1, x2, y2);
                } else {
                    dashed.drawLine(x2, y1, x2, y2);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this.range.hasLowerBound()) {
                if (this.range.hasUpperBound()) {
                    return this.boundedInsets;
                }
                return this.leftBoundedInsets;
            }
            if (this.range.hasUpperBound()) {
                return this.rightBoundedInsets;
            }
            return this.unboundedInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static interface TimelineInfo<T, N extends Number> {
        public Range<N> getRange(T var1);

        default public String getLabel(T t) {
            return t.toString();
        }

        default public boolean columnAffectsBounds(int column) {
            return true;
        }

        default public Color getForegroundColor(T t, JComponent in, int track, boolean selected, boolean hasFocus) {
            if (selected) {
                return UIManagerWrapper.getColor("Table[Enabled+Selected].textForeground");
            }
            return UIManagerWrapper.getColor("Table.textForeground");
        }

        default public Color getBackgroundColor(T t, JComponent in, int track, boolean selected, boolean hasFocus) {
            if (selected) {
                return UIManagerWrapper.getColor("Table[Enabled+Selected].textBackground");
            }
            if (track % 2 == 1) {
                return UIManagerWrapper.getColor("Table.alternateRowColor");
            }
            return UIManagerWrapper.getColor("Table:\"Table.cellRenderer\".background");
        }

        default public JComponent getComponent(T t) {
            String text = this.getLabel(t);
            JLabel label = new JLabel(text);
            label.setToolTipText(text);
            label.setHorizontalAlignment(0);
            return label;
        }
    }
}

