/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import com.google.common.collect.Range;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import java.awt.Graphics;

public class RangeTableCellRenderer<N extends Number>
extends AbstractGColumnRenderer<Range<N>> {
    protected Range<Double> doubleFullRange = Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
    protected double span = 1.0;
    protected Range<N> fullRange;
    protected Range<N> dataRange;

    public static Range<Double> validateViewRange(Range<? extends Number> fullRange) {
        if (!fullRange.hasLowerBound() || !fullRange.hasUpperBound()) {
            throw new IllegalArgumentException("Cannot have unbounded full range");
        }
        return Range.closed((Comparable)Double.valueOf(((Number)((Object)fullRange.lowerEndpoint())).doubleValue()), (Comparable)Double.valueOf(((Number)((Object)fullRange.upperEndpoint())).doubleValue()));
    }

    public void setFullRange(Range<N> fullRange) {
        this.fullRange = fullRange;
        this.doubleFullRange = RangeTableCellRenderer.validateViewRange(fullRange);
        this.span = (Double)this.doubleFullRange.upperEndpoint() - (Double)this.doubleFullRange.lowerEndpoint();
    }

    public String getFilterString(Range<N> t, Settings settings) {
        return "";
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        this.dataRange = (Range)data.getValue();
        super.getTableCellRendererComponent(data);
        this.setText("");
        return this;
    }

    protected void paintComponent(Graphics parentG) {
        super.paintComponent(parentG);
        if (this.dataRange == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int x1 = this.dataRange.hasLowerBound() ? this.interpolate(width, ((Number)((Object)this.dataRange.lowerEndpoint())).doubleValue()) : 0;
        int x2 = this.dataRange.hasUpperBound() ? this.interpolate(width, ((Number)((Object)this.dataRange.upperEndpoint())).doubleValue()) : width;
        int y1 = height > 2 ? 1 : 0;
        int y2 = height > 2 ? height - 1 : height;
        Graphics g = parentG.create();
        g.setColor(this.getForeground());
        g.fillRect(x1, y1, x2 - x1, y2 - y1);
    }

    protected int interpolate(int w, double val) {
        double lower = (Double)this.doubleFullRange.lowerEndpoint();
        if (val <= lower) {
            return 0;
        }
        if (val >= (Double)this.doubleFullRange.upperEndpoint()) {
            return w;
        }
        double dif = val - lower;
        return (int)(dif / this.span * (double)w);
    }

    public Range<N> getFullRange() {
        return this.fullRange;
    }
}

