/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.model;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GLifespanField
extends JPanel {
    private static final String NEG_INF = "-\u221e";
    private static final String POS_INF = "+\u221e";
    private final JLabel labelLower = new JLabel("[");
    private final JComboBox<String> fieldMin = new JComboBox();
    private final JComboBox<String> fieldMax = new JComboBox();
    private final JLabel labelUpper = new JLabel("]");
    private final DefaultComboBoxModel<String> modelMin = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<String> modelMax = new DefaultComboBoxModel();

    public GLifespanField() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.labelLower);
        this.add(this.fieldMin);
        this.add(new JLabel("\u2025"));
        this.add(this.fieldMax);
        this.add(this.labelUpper);
        this.modelMin.addElement(NEG_INF);
        this.modelMax.addElement(POS_INF);
        this.fieldMin.setEditable(true);
        this.fieldMin.setModel(this.modelMin);
        this.fieldMax.setEditable(true);
        this.fieldMax.setModel(this.modelMax);
        this.fieldMin.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GLifespanField.this.minFocusLost(e);
                GLifespanField.this.checkDispatchFocus(e);
            }
        });
        this.fieldMax.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GLifespanField.this.maxFocusLost(e);
                GLifespanField.this.checkDispatchFocus(e);
            }
        });
    }

    protected void checkDispatchFocus(FocusEvent e) {
        Component opp = e.getOppositeComponent();
        if (opp == null || !SwingUtilities.isDescendingFrom(opp, this)) {
            this.dispatchEvent(e);
        }
    }

    protected long parseLong(String text, long defaultVal) {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    protected void revalidateMin() {
        String value = (String)this.fieldMin.getSelectedItem();
        if (NEG_INF.equals(value)) {
            this.labelLower.setText("(");
        } else {
            this.fieldMin.setSelectedItem(Long.toString(this.parseLong(value, 0L)));
            this.labelLower.setText("[");
        }
    }

    protected void revalidateMax() {
        String value = (String)this.fieldMax.getSelectedItem();
        if (POS_INF.equals(value)) {
            this.labelUpper.setText(")");
        } else {
            this.fieldMax.setSelectedItem(Long.toString(this.parseLong(value, 0L)));
            this.labelUpper.setText("]");
        }
    }

    protected void adjustMaxToMin() {
        if (this.unbounded()) {
            return;
        }
        long min = this.parseLong((String)this.fieldMin.getSelectedItem(), 0L);
        long max = Math.max(min, this.parseLong((String)this.fieldMax.getSelectedItem(), min));
        this.fieldMax.setSelectedItem(Long.toString(max));
    }

    protected boolean unbounded() {
        return NEG_INF.equals(this.fieldMin.getSelectedItem()) || POS_INF.equals(this.fieldMax.getSelectedItem());
    }

    protected void adjustMinToMax() {
        if (this.unbounded()) {
            return;
        }
        long max = this.parseLong((String)this.fieldMax.getSelectedItem(), 0L);
        long min = Math.min(max, this.parseLong((String)this.fieldMin.getSelectedItem(), max));
        this.fieldMin.setSelectedItem(Long.toString(min));
    }

    protected void minFocusLost(FocusEvent e) {
        this.revalidateMin();
        this.adjustMaxToMin();
    }

    protected void maxFocusLost(FocusEvent e) {
        this.revalidateMax();
        this.adjustMinToMax();
    }

    public void setLifespan(Range<Long> lifespan) {
        if (lifespan.hasLowerBound() && lifespan.lowerBoundType() == BoundType.OPEN || lifespan.hasUpperBound() && lifespan.upperBoundType() == BoundType.OPEN) {
            throw new IllegalArgumentException("Lifespans must be closed or unbounded");
        }
        if (!lifespan.hasLowerBound()) {
            this.fieldMin.setSelectedItem(NEG_INF);
        } else {
            this.fieldMin.setSelectedItem(Long.toString((Long)lifespan.lowerEndpoint()));
        }
        if (!lifespan.hasUpperBound()) {
            this.fieldMax.setSelectedItem(POS_INF);
        } else {
            this.fieldMax.setSelectedItem(Long.toString((Long)lifespan.upperEndpoint()));
        }
    }

    public Range<Long> getLifespan() {
        String min = (String)this.fieldMin.getSelectedItem();
        String max = (String)this.fieldMax.getSelectedItem();
        if (NEG_INF.equals(min)) {
            if (POS_INF.equals(max)) {
                return Range.all();
            }
            return Range.atMost((Comparable)Long.valueOf(Long.parseLong(max)));
        }
        if (POS_INF.equals(max)) {
            return Range.atLeast((Comparable)Long.valueOf(Long.parseLong(min)));
        }
        return Range.closed((Comparable)Long.valueOf(Long.parseLong(min)), (Comparable)Long.valueOf(Long.parseLong(max)));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fieldMin.setEnabled(enabled);
        this.fieldMax.setEnabled(enabled);
    }
}

