/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.TreeTaskMonitor;
import docking.widgets.tree.internal.InProgressGTreeNode;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collections;
import java.util.List;
import util.CollectionUtils;

public abstract class GTreeSlowLoadingNode
extends GTreeLazyNode {
    public abstract List<GTreeNode> generateChildren(TaskMonitor var1) throws CancelledException;

    @Override
    protected final List<GTreeNode> generateChildren() {
        GTree tree = this.getTree();
        if (Swing.isSwingThread()) {
            if (tree == null) {
                return Collections.emptyList();
            }
            LoadChildrenTask loadTask = new LoadChildrenTask(tree);
            tree.runTask(loadTask);
            return CollectionUtils.asList((Object[])new GTreeNode[]{new InProgressGTreeNode()});
        }
        return this.generateChildrenNow(this.getMonitor(tree));
    }

    @Override
    public int loadAll(TaskMonitor monitor) throws CancelledException {
        if (!this.isLoaded()) {
            monitor = new TreeTaskMonitor(monitor, 2L);
            this.doSetChildren(this.generateChildren(new TreeTaskMonitor(monitor, 0L)));
            monitor.incrementProgress(1L);
        }
        return super.loadAll(monitor);
    }

    private List<GTreeNode> generateChildrenNow(TaskMonitor monitor) {
        try {
            return this.generateChildren(monitor);
        }
        catch (CancelledException e) {
            return null;
        }
    }

    private TaskMonitor getMonitor(GTree tree) {
        if (tree == null) {
            return TaskMonitor.DUMMY;
        }
        return tree.getThreadLocalMonitor();
    }

    private class LoadChildrenTask
    extends GTreeTask {
        LoadChildrenTask(GTree tree) {
            super(tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            if (GTreeSlowLoadingNode.this.isLoaded()) {
                GTreeSlowLoadingNode.this.fireNodeStructureChanged(GTreeSlowLoadingNode.this);
                return;
            }
            long progressValue = monitor.getProgress();
            long maxValue = monitor.getMaximum();
            monitor.setMessage("Loading children");
            try {
                GTreeSlowLoadingNode.this.setChildren(GTreeSlowLoadingNode.this.generateChildren(monitor));
            }
            catch (CancelledException e) {
                if (!this.tree.isDisposed()) {
                    this.runOnSwingThread(new Runnable(){

                        @Override
                        public void run() {
                            LoadChildrenTask.this.tree.collapseAll(LoadChildrenTask.this.tree.getViewRoot());
                        }
                    });
                }
                GTreeSlowLoadingNode.this.doSetChildren(null);
            }
            finally {
                monitor.initialize(maxValue);
                monitor.setProgress(progressValue);
            }
        }
    }
}

