/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.provider;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.provider.EditorProvider;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.IntegerConstraintEditor;
import docking.widgets.table.constrainteditor.LongConverter;

public class IntegerEditorProvider<T extends Number>
implements EditorProvider<T> {
    protected LongConverter<T> converter;

    IntegerEditorProvider(LongConverter<T> converter) {
        this.converter = converter;
    }

    @Override
    public ColumnConstraintEditor<T> getEditor(ColumnConstraint<T> columnConstraint, ColumnData<T> columnDataSource) {
        return new IntegerConstraintEditor<T>(columnConstraint, this.converter);
    }

    @Override
    public T parseValue(String value, Object dataSource) {
        long longValue = Long.parseLong(value);
        return (T)((Number)this.converter.fromLong(longValue));
    }

    @Override
    public String toString(T value) {
        return value.toString();
    }
}

