/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DialogComponentProvider;
import docking.ExecutableAction;
import docking.action.DockingActionIf;
import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class MultiActionDialog
extends DialogComponentProvider {
    private String keystrokeName;
    private List<ExecutableAction> list;
    private JList<String> actionList;
    private DefaultListModel<String> listModel;

    public MultiActionDialog(String keystrokeName, List<ExecutableAction> list) {
        super("Select Action", true);
        this.keystrokeName = keystrokeName;
        this.init();
        this.setActionList(list);
    }

    @Override
    protected void okCallback() {
        this.maybeDoAction();
    }

    private void maybeDoAction() {
        int index = this.actionList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.close();
        ExecutableAction actionProxy = this.list.get(index);
        actionProxy.execute();
    }

    public void setActionList(List<ExecutableAction> list) {
        this.okButton.setEnabled(false);
        this.list = list;
        this.listModel.clear();
        for (int i = 0; i < list.size(); ++i) {
            ExecutableAction actionProxy = list.get(i);
            DockingActionIf action = actionProxy.getAction();
            this.listModel.addElement(action.getName() + " (" + action.getOwnerDescription() + ")");
        }
        this.actionList.setSelectedIndex(0);
    }

    private void init() {
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.addListeners();
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        labelPanel.add(new GLabel("Multiple actions have been mapped to " + this.keystrokeName));
        labelPanel.add(new GLabel("Actions that can be enabled at the same"));
        labelPanel.add(new GLabel("time should be mapped to different keys"));
        innerPanel.setBorder(BorderFactory.createTitledBorder("Actions"));
        JPanel panel = new JPanel(new FlowLayout(0));
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        panel.add(new GIconLabel(icon));
        panel.add(labelPanel);
        this.listModel = new DefaultListModel();
        this.actionList = new JList<String>(this.listModel);
        this.actionList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    evt.consume();
                    MultiActionDialog.this.okCallback();
                } else if (evt.getKeyCode() == 27) {
                    evt.consume();
                    MultiActionDialog.this.close();
                }
            }
        });
        this.actionList.addMouseListener(new GMouseListenerAdapter(){

            @Override
            public void doubleClickTriggered(MouseEvent e) {
                MultiActionDialog.this.maybeDoAction();
            }
        });
        this.actionList.setSelectionMode(0);
        this.actionList.setVisibleRowCount(5);
        JScrollPane listScrollPane = new JScrollPane(this.actionList);
        innerPanel.add((Component)listScrollPane, "Center");
        mainPanel.add((Component)panel, "North");
        mainPanel.add((Component)innerPanel, "Center");
        return mainPanel;
    }

    private void addListeners() {
        this.actionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiersEx() != 1024) {
                    return;
                }
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    MultiActionDialog.this.okCallback();
                }
            }
        });
        this.actionList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.okButton.setEnabled(!this.actionList.isSelectionEmpty());
        });
    }
}

